/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.annotator;

import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.BGMWalker;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.IgnoreItem;
import com.sun.tools.xjc.grammar.InterfaceItem;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.grammar.WildcardItem;
import com.sun.tools.xjc.reader.annotator.JavaItemRemover;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class TemporaryClassItemRemover {
    private static PrintStream debug = null;

    TemporaryClassItemRemover() {
    }

    public static void remove(AnnotatedGrammar grammar) {
        ClassItem ci;
        Iterator itr;
        ClassItem[] items = grammar.getClasses();
        Pass1 p1 = new Pass1();
        grammar.topLevel.visit(p1);
        int i = 0;
        while (i < items.length) {
            p1.processIfUnvisited(items[i]);
            ++i;
        }
        HashSet<ClassItem> cs = new HashSet<ClassItem>();
        int i2 = 0;
        while (i2 < items.length) {
            cs.add(items[i2]);
            ++i2;
        }
        cs.removeAll(p1.notRemovableClasses);
        if (debug != null) {
            itr = cs.iterator();
            while (itr.hasNext()) {
                ci = (ClassItem)itr.next();
                if (p1.reachableClasses.contains(ci)) continue;
                debug.println(ci.getTypeAsDefined().name() + " : this is unreachable");
            }
        }
        cs.retainAll(p1.reachableClasses);
        itr = cs.iterator();
        while (itr.hasNext()) {
            if (((ClassItem)itr.next()).isTemporary) continue;
            itr.remove();
        }
        if (debug != null) {
            itr = cs.iterator();
            while (itr.hasNext()) {
                ci = (ClassItem)itr.next();
                debug.println(" " + ci.getTypeAsDefined().name() + " will be removed");
            }
        }
        JavaItemRemover jir = new JavaItemRemover(grammar.getPool(), cs);
        int i3 = 0;
        while (i3 < items.length) {
            items[i3].exp = items[i3].exp.visit(jir);
            ++i3;
        }
        grammar.removeClassItems(cs);
    }

    private static class Pass1
    extends BGMWalker {
        private final Set checkedClasses = new HashSet();
        public final Set reachableClasses = new HashSet();
        final Set notRemovableClasses = new HashSet();
        private Set childItems = new HashSet();
        private JavaItem parentItem = null;

        private Pass1() {
        }

        public void processIfUnvisited(ClassItem ci) {
            if (!this.checkedClasses.contains(ci)) {
                if (debug != null) {
                    debug.println("processIf(" + ci.getTypeAsDefined().name() + ")");
                }
                ci.visit(this);
            }
        }

        public Object onIgnore(IgnoreItem item) {
            return null;
        }

        public Object onField(FieldItem item) {
            item.exp.visit(this);
            return null;
        }

        public Object onSuper(SuperClassItem item) {
            this.updateAndVisit(item);
            return null;
        }

        public Object onInterface(InterfaceItem item) {
            this.updateAndVisit(item);
            return null;
        }

        private void updateAndVisit(JavaItem item) {
            this.childItems.add(item);
            JavaItem old = this.parentItem;
            this.parentItem = item;
            item.exp.visit(this);
            this.parentItem = old;
        }

        public Object onWildcard(WildcardItem item) {
            this.childItems.add(item);
            return null;
        }

        public Object onPrimitive(PrimitiveItem item) {
            this.childItems.add(item);
            return null;
        }

        public Object onClass(ClassItem item) {
            JDefinedClass cls = item.getTypeAsDefined();
            if (debug != null) {
                debug.println("processing " + cls.name());
            }
            this.childItems.add(item);
            if (this.parentItem != null) {
                if (!this.reachableClasses.add(item) && this.notRemovableClasses.add(item) && debug != null) {
                    debug.println(cls.name() + " : referenced more than once");
                }
            } else {
                this.notRemovableClasses.add(item);
            }
            if ((this.parentItem instanceof SuperClassItem || this.parentItem instanceof InterfaceItem) && this.notRemovableClasses.add(item) && debug != null) {
                debug.println(cls.name() + " : referenced by a superClass/interfaceItem");
            }
            if (!this.checkedClasses.add(item)) {
                return null;
            }
            Set oldChildItems = this.childItems;
            this.childItems = new HashSet();
            JavaItem oldParent = this.parentItem;
            this.parentItem = item;
            item.exp.visit(this);
            if (this.childItems.size() == 0) {
                if (this.notRemovableClasses.add(item) && debug != null) {
                    debug.println(cls.name() + " : this class has no child item");
                }
            } else if (this.childItems.size() > 1 && this.notRemovableClasses.add(item) && debug != null) {
                debug.println(cls.name() + " : this class has multiple fields");
            }
            this.childItems = oldChildItems;
            this.parentItem = oldParent;
            return null;
        }
    }
}

