/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.annotator;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.trex.ElementPattern;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.msv.grammar.xmlschema.SimpleTypeExp;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.IgnoreItem;
import com.sun.tools.xjc.grammar.InterfaceItem;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.grammar.util.Multiplicity;
import com.sun.tools.xjc.grammar.util.MultiplicityCounter;
import com.sun.tools.xjc.reader.annotator.AnnotatorController;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

class FieldItemAnnotation {
    private static PrintStream debug = null;
    private final AnnotatorController controller;
    private final Map annotatedRefs = new HashMap();

    public static void annotate(AnnotatedGrammar g, AnnotatorController controller) {
        FieldItemAnnotation ann = new FieldItemAnnotation(controller);
        ClassItem[] classes = g.getClasses();
        int i = 0;
        while (i < classes.length) {
            if (debug != null) {
                debug.println(" adding field item for " + classes[i].getTypeAsDefined().name());
            }
            classes[i].exp = classes[i].exp.visit(ann.new Annotator(g, classes[i]));
            ++i;
        }
    }

    private FieldItemAnnotation(AnnotatorController _controller) {
        this.controller = _controller;
    }

    private static void _assert(boolean b) {
        if (!b) {
            throw new Error();
        }
    }

    private class Annotator
    extends ExpressionCloner {
        private final Stack names = new Stack();
        private final AnnotatedGrammar grammar;
        private final ClassItem owner;

        private Annotator(AnnotatedGrammar g, ClassItem owner) {
            super(g.getPool());
            this.owner = owner;
            this.grammar = g;
            this.names.push("Content");
        }

        public Expression onRef(ReferenceExp exp) {
            Expression r = (Expression)FieldItemAnnotation.this.annotatedRefs.get(exp);
            if (r != null) {
                return r;
            }
            boolean pushed = false;
            if (exp.name != null && !(exp instanceof SimpleTypeExp)) {
                this.names.push(exp.name);
                pushed = true;
            }
            r = exp.exp.visit(this);
            if (pushed) {
                FieldItemAnnotation.this.annotatedRefs.put(exp, r);
            }
            r.visit(new ExpressionWalker(){

                public void onOther(OtherExp exp) {
                    if (exp instanceof FieldItem) {
                        return;
                    }
                    if (exp instanceof IgnoreItem) {
                        return;
                    }
                    if (exp instanceof JavaItem) {
                        System.err.println(exp);
                        throw new Error();
                    }
                }
            });
            if (pushed) {
                this.names.pop();
            }
            return r;
        }

        public Expression onOther(OtherExp exp) {
            if (exp instanceof PrimitiveItem || exp instanceof InterfaceItem || exp instanceof ClassItem) {
                return new FieldItem(this.decideName(exp.exp), exp, null);
            }
            if (exp instanceof IgnoreItem || exp instanceof SuperClassItem || exp instanceof FieldItem) {
                return exp;
            }
            FieldItemAnnotation._assert(!(exp instanceof JavaItem));
            exp.exp = exp.exp.visit(this);
            return exp;
        }

        public Expression onAttribute(AttributeExp exp) {
            Expression body = this.visitXMLItemContent(exp);
            if (body == exp.exp) {
                return exp;
            }
            return this.pool.createAttribute(exp.nameClass, body);
        }

        public Expression onElement(ElementExp exp) {
            Expression body = this.visitXMLItemContent(exp);
            if (body == exp.contentModel) {
                return exp;
            }
            return new ElementPattern(exp.getNameClass(), body);
        }

        private Expression visitXMLItemContent(NameClassAndExpression exp) {
            String name = null;
            NameClass nc = exp.getNameClass();
            if (nc instanceof SimpleNameClass) {
                name = ((SimpleNameClass)nc).localName;
            }
            if (exp == this.owner.exp) {
                name = null;
            }
            if (name != null) {
                this.names.push(name);
            }
            Expression body = exp.getContentModel().visit(this);
            if (name != null) {
                this.names.pop();
            }
            return body;
        }

        public Expression onChoice(ChoiceExp exp) {
            Expression r;
            Expression[] b = exp.getChildren();
            boolean[] fieldlessBranch = new boolean[b.length];
            int numLiveBranch = 0;
            boolean bBranchWithField = false;
            boolean[] bBranchWithPrimitive = new boolean[1];
            if (debug != null) {
                debug.println("Processing Choice: " + ExpressionPrinter.printContentModel(exp));
                debug.println("checking each branch");
            }
            int i = 0;
            while (i < b.length) {
                boolean[] hasChildFieldItem = new boolean[1];
                Multiplicity m = Multiplicity.calc(b[i], new MultiplicityCounter(this, hasChildFieldItem, bBranchWithPrimitive){
                    private final /* synthetic */ boolean[] val$hasChildFieldItem;
                    private final /* synthetic */ boolean[] val$bBranchWithPrimitive;
                    private final /* synthetic */ Annotator this$1;
                    {
                        this.this$1 = this$1;
                        this.val$hasChildFieldItem = val$hasChildFieldItem;
                        this.val$bBranchWithPrimitive = val$bBranchWithPrimitive;
                    }

                    protected Multiplicity isChild(Expression exp) {
                        if (exp instanceof FieldItem) {
                            this.val$hasChildFieldItem[0] = true;
                        }
                        if (exp instanceof PrimitiveItem) {
                            this.val$bBranchWithPrimitive[0] = true;
                        }
                        if (exp instanceof IgnoreItem) {
                            return Multiplicity.zero;
                        }
                        if (exp instanceof JavaItem) {
                            return Multiplicity.one;
                        }
                        return null;
                    }
                });
                if (debug != null) {
                    debug.println("  Branch: " + ExpressionPrinter.printContentModel(b[i]));
                    debug.println("    multiplicity:" + m + "  hasChildFieldItem:" + hasChildFieldItem[0]);
                }
                if (!m.isZero()) {
                    ++numLiveBranch;
                    if (!hasChildFieldItem[0]) {
                        fieldlessBranch[i] = true;
                    } else {
                        bBranchWithField = true;
                        b[i] = b[i].visit(this);
                    }
                }
                ++i;
            }
            if (numLiveBranch <= 1) {
                int i2 = 0;
                while (i2 < b.length) {
                    if (fieldlessBranch[i2]) {
                        b[i2] = b[i2].visit(this);
                    }
                    ++i2;
                }
                r = Expression.nullSet;
                int i3 = 0;
                while (i3 < b.length) {
                    r = this.pool.createChoice(r, b[i3]);
                    ++i3;
                }
                return r;
            }
            String fieldName = this.decideName(exp);
            r = Expression.nullSet;
            int i4 = 0;
            while (i4 < b.length) {
                if (bBranchWithField && fieldlessBranch[i4]) {
                    b[i4] = new FieldItem(fieldName, b[i4], null);
                }
                r = this.pool.createChoice(r, b[i4]);
                ++i4;
            }
            if (!bBranchWithField) {
                r = new FieldItem(fieldName, r, null);
            }
            return r;
        }

        private String decideName(Expression hint) {
            NameClass nc;
            String name = null;
            if (hint != null && hint instanceof NameClassAndExpression && (nc = ((NameClassAndExpression)((Object)hint)).getNameClass()) instanceof SimpleNameClass) {
                return FieldItemAnnotation.this.controller.getNameConverter().toPropertyName(((SimpleNameClass)nc).localName);
            }
            if (name == null) {
                name = (String)this.names.pop();
            }
            int idx = name.length() - 1;
            while (Character.isDigit(name.charAt(idx)) && idx >= 0) {
                --idx;
            }
            if (++idx == name.length()) {
                this.names.push(name + "1");
            } else {
                this.names.push(name.substring(0, idx) + (Integer.parseInt(name.substring(idx)) + 1));
            }
            return FieldItemAnnotation.this.controller.getNameConverter().toPropertyName(name);
        }
    }
}

