/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader;

import com.sun.codemodel.JJavaName;
import com.sun.tools.xjc.reader.NameConverter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.InputSource;

public class Util {
    public static InputSource getInputSource(String fileOrURL) {
        try {
            try {
                return new InputSource(new URL(fileOrURL).toExternalForm());
            }
            catch (MalformedURLException e) {
                return new InputSource(new File(fileOrURL).getCanonicalFile().toURL().toExternalForm());
            }
        }
        catch (Exception e) {
            return new InputSource(fileOrURL);
        }
    }

    public static String getPackageNameFromNamespaceURI(String nsUri, NameConverter nameConv) {
        ArrayList r;
        String domain;
        String lastToken;
        ArrayList tokens;
        String scheme;
        int idx = nsUri.indexOf(58);
        if (idx >= 0 && ((scheme = nsUri.substring(0, idx)).equalsIgnoreCase("http") || scheme.equalsIgnoreCase("urn"))) {
            nsUri = nsUri.substring(idx + 1);
        }
        if ((tokens = Util.tokenize(nsUri, "/: ")).size() == 0) {
            return null;
        }
        if (tokens.size() > 1 && (idx = (lastToken = (String)tokens.get(tokens.size() - 1)).lastIndexOf(46)) > 0) {
            lastToken = lastToken.substring(0, idx);
            tokens.set(tokens.size() - 1, lastToken);
        }
        if ((idx = (domain = (String)tokens.get(0)).indexOf(58)) >= 0) {
            domain = domain.substring(0, idx);
        }
        if (((String)(r = Util.reverse(Util.tokenize(domain, "."))).get(r.size() - 1)).equalsIgnoreCase("www")) {
            r.remove(r.size() - 1);
        }
        tokens.addAll(1, r);
        tokens.remove(0);
        int i = 0;
        while (i < tokens.size()) {
            String token = (String)tokens.get(i);
            if (!JJavaName.isJavaIdentifier(token = Util.removeIllegalIdentifierChars(token))) {
                token = new String("_" + token);
            }
            tokens.set(i, token.toLowerCase());
            ++i;
        }
        return Util.combine(tokens, '.');
    }

    private static String removeIllegalIdentifierChars(String token) {
        StringBuffer newToken = new StringBuffer();
        int i = 0;
        while (i < token.length()) {
            char c = token.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c)) {
                newToken.append("_" + c);
            } else if (!Character.isJavaIdentifierPart(c)) {
                newToken.append('_');
            } else {
                newToken.append(c);
            }
            ++i;
        }
        return newToken.toString();
    }

    private static ArrayList tokenize(String str, String sep) {
        StringTokenizer tokens = new StringTokenizer(str, sep);
        ArrayList<String> r = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            r.add(tokens.nextToken());
        }
        return r;
    }

    private static ArrayList reverse(List a) {
        ArrayList r = new ArrayList();
        int i = a.size() - 1;
        while (i >= 0) {
            r.add(a.get(i));
            --i;
        }
        return r;
    }

    private static String combine(List r, char sep) {
        StringBuffer buf = new StringBuffer((String)r.get(0));
        int i = 1;
        while (i < r.size()) {
            buf.append(sep);
            buf.append(r.get(i));
            ++i;
        }
        return buf.toString();
    }
}

