/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.grammar.xducer;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.generator.field.FieldRenderer;
import com.sun.tools.xjc.generator.util.BlockReference;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.xducer.Transducer;
import org.xml.sax.SAXException;

public final class TypeAdaptedTransducer
implements Transducer {
    private final Transducer xducer;
    private final JType expectedType;
    private final boolean boxing;

    public static Transducer adapt(Transducer xducer, FieldRenderer fieldRenderer) {
        return TypeAdaptedTransducer.adapt(xducer, fieldRenderer.getFieldUse().type);
    }

    public static Transducer adapt(Transducer xducer, JType expectedType) {
        JType t = xducer.getReturnType();
        if (t instanceof JPrimitiveType && expectedType instanceof JClass) {
            expectedType = ((JPrimitiveType)t).getWrapperClass();
            return new TypeAdaptedTransducer(xducer, expectedType);
        }
        if (t instanceof JClass && expectedType instanceof JPrimitiveType) {
            return new TypeAdaptedTransducer(xducer, expectedType);
        }
        return xducer;
    }

    private TypeAdaptedTransducer(Transducer _xducer, JType _expectedType) {
        this.xducer = _xducer;
        this.expectedType = _expectedType;
        this.boxing = this.expectedType instanceof JClass;
    }

    public JType getReturnType() {
        return this.expectedType;
    }

    public JExpression generateSerializer(JExpression value, JExpression context) {
        if (this.boxing) {
            return this.xducer.generateSerializer(((JPrimitiveType)this.xducer.getReturnType()).unwrap(value), context);
        }
        return this.xducer.generateSerializer(((JPrimitiveType)this.expectedType).wrap(value), context);
    }

    public JExpression generateDeserializer(JExpression literal, JExpression context) {
        if (this.boxing) {
            return ((JPrimitiveType)this.xducer.getReturnType()).wrap(this.xducer.generateDeserializer(literal, context));
        }
        return ((JPrimitiveType)this.expectedType).unwrap(this.xducer.generateDeserializer(literal, context));
    }

    public JExpression generateConstant(PrimitiveItem exp) {
        if (this.boxing) {
            return ((JPrimitiveType)this.xducer.getReturnType()).wrap(this.xducer.generateConstant(exp));
        }
        return ((JPrimitiveType)this.expectedType).unwrap(this.xducer.generateConstant(exp));
    }

    public void populate(AnnotatedGrammar grammar, GeneratorContext context) throws SAXException {
        this.xducer.populate(grammar, context);
    }

    public void declareNamespace(BlockReference body, JExpression value, JExpression context) {
        if (this.boxing) {
            this.xducer.declareNamespace(body, ((JPrimitiveType)this.xducer.getReturnType()).unwrap(value), context);
        } else {
            this.xducer.declareNamespace(body, ((JPrimitiveType)this.expectedType).wrap(value), context);
        }
    }

    public boolean needsDelayedDeserialization() {
        return this.xducer.needsDelayedDeserialization();
    }
}

