/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.grammar.xducer;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.xducer.BuiltinDatatypeTransducerFactory;
import com.sun.tools.xjc.grammar.xducer.Messages;
import com.sun.tools.xjc.grammar.xducer.Transducer;
import com.sun.tools.xjc.grammar.xducer.TransducerImpl;
import com.sun.tools.xjc.reader.NameConverter;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EnumerationXducer
extends TransducerImpl {
    private final JDefinedClass type;
    private final NameConverter nameConverter;
    private final JCodeModel codeModel;
    private final Map members;
    private Locator sourceLocator;
    private boolean populated = false;
    private ValueExp[] values;
    private JFieldVar[] items;
    private JType valueType;
    private static final String ERR_CONTEXT_DEPENDENT_TYPE = "EnumerationXducer.ContextDependentType";
    private static final String ERR_UNSUPPORTED_TYPE_FOR_ENUM = "EnumerationXducer.UnsupportedTypeForEnum";
    private static final String ERR_UNUSABLE_NAME = "EnumerationXducer.UnusableName";
    private static final String ERR_MULTIPLE_TYPES_IN_ENUM = "EnumerationXducer.MultipleTypesInEnum";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public JType getReturnType() {
        return this.type;
    }

    public EnumerationXducer(NameConverter _nc, JDefinedClass clz, Expression enumExp, Map _members, Locator _sourceLocator) {
        this.type = clz;
        this.codeModel = clz.owner();
        this.nameConverter = _nc;
        this.members = _members;
        this.sourceLocator = _sourceLocator;
        this.values = this.getValues(enumExp);
    }

    public void populate(AnnotatedGrammar grammar, GeneratorContext context) throws SAXException {
        if (this.populated) {
            return;
        }
        this.populated = true;
        JClass stringRef = this.codeModel.ref(class$java$lang$String == null ? (class$java$lang$String = EnumerationXducer.class$("java.lang.String")) : class$java$lang$String);
        JClass objectRef = this.codeModel.ref(class$java$lang$Object == null ? (class$java$lang$Object = EnumerationXducer.class$("java.lang.Object")) : class$java$lang$Object);
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i].dt.isContextDependent()) {
                this.reportError(context, Messages.format(ERR_CONTEXT_DEPENDENT_TYPE));
                return;
            }
            if (!(this.values[i].dt instanceof XSDatatype)) {
                this.reportError(context, Messages.format(ERR_UNSUPPORTED_TYPE_FOR_ENUM, this.values[i].getName()));
            }
            if (!this.values[0].dt.equals(this.values[i].dt)) {
                this.reportError(context, Messages.format(ERR_MULTIPLE_TYPES_IN_ENUM, this.values[0].name, this.values[i].name));
                return;
            }
            ++i;
        }
        Transducer xducer = BuiltinDatatypeTransducerFactory.get(grammar, (XSDatatype)this.values[0].dt);
        this.valueType = xducer.getReturnType();
        this.items = new JFieldVar[this.values.length];
        JVar[] valueObjs = new JVar[this.values.length];
        int i2 = 0;
        while (i2 < this.values.length) {
            String lexical = this.values[i2].dt instanceof XSDatatype ? ((XSDatatype)this.values[i2].dt).convertToLexicalValue(this.values[i2].value, null) : this.values[i2].value.toString();
            MemberInfo mem = (MemberInfo)this.members.get(this.values[i2]);
            String constName = null;
            if (mem != null) {
                constName = mem.name;
            }
            if (constName == null) {
                constName = this.nameConverter.toConstantName(lexical);
            }
            if (!JJavaName.isJavaIdentifier(constName)) {
                this.reportError(context, Messages.format(ERR_UNUSABLE_NAME, lexical, constName));
            }
            valueObjs[i2] = this.type.field(25, this.valueType, '_' + constName);
            this.items[i2] = this.type.field(25, this.type, constName);
            this.items[i2].init(JExpr._new(this.type).arg(valueObjs[i2]));
            if (mem != null && mem.javadoc != null) {
                this.items[i2].javadoc().appendComment(mem.javadoc);
            }
            valueObjs[i2].init(xducer.generateDeserializer(JExpr.lit(lexical), null));
            ++i2;
        }
        JFieldVar $lexical = this.type.field(12, stringRef, "lexicalValue");
        JFieldVar $value = this.type.field(12, this.valueType, "value");
        JMethod m = this.type.constructor(2);
        JVar $v = m.param(this.valueType, "v");
        m.body().assign($value, $v);
        m.body().assign($lexical, xducer.generateSerializer($v, JExpr._null()));
        this.type.method(1, stringRef, "toString").body()._return($lexical);
        this.type.method(1, this.valueType, "getValue").body()._return($value);
        this.type.method(9, this.codeModel.INT, "hashCode").body()._return(JExpr._super().invoke("hashCode"));
        m = this.type.method(9, this.codeModel.BOOLEAN, "equals");
        JVar o = m.param(this.codeModel.ref(class$java$lang$Object == null ? (class$java$lang$Object = EnumerationXducer.class$("java.lang.Object")) : class$java$lang$Object), "o");
        m.body()._return(JExpr._super().invoke("equals").arg(o));
        JMethod fromValue = this.type.method(17, this.type, "fromValue");
        $v = fromValue.param(this.valueType, "value");
        int i3 = 0;
        while (i3 < this.values.length) {
            fromValue.body()._if(this.eq(valueObjs[i3], $v))._then()._return(this.items[i3]);
            ++i3;
        }
        fromValue.body()._throw(JExpr._new(this.codeModel.ref(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = EnumerationXducer.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException)));
        JMethod fromString = this.type.method(17, this.type, "fromString");
        JVar $str = fromString.param(stringRef, "str");
        JExpression rhs = xducer.generateDeserializer($str, null);
        fromString.body()._return(JExpr.invoke("fromValue").arg(rhs));
    }

    private JExpression eq(JExpression v1, JExpression v2) {
        if (this.valueType.isPrimitive()) {
            return JOp.eq(v1, v2);
        }
        return v1.invoke("equals").arg(v2);
    }

    public JExpression generateSerializer(JExpression value, JExpression context) {
        return value.invoke("toString");
    }

    public JExpression generateDeserializer(JExpression value, JExpression context) {
        return this.type.invoke("fromString").arg(value);
    }

    public JExpression generateConstant(PrimitiveItem exp) {
        ValueExp[] specificValues = this.getValues(exp.exp);
        if (specificValues.length != 1) {
            throw new InternalError();
        }
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i].value.equals(specificValues[0].value)) {
                return this.type.ref(this.items[i].name());
            }
            ++i;
        }
        throw new InternalError();
    }

    private ValueExp[] getValues(Expression exp) {
        if (!(exp instanceof ChoiceExp)) {
            if (!(exp instanceof ValueExp)) {
                System.out.println(ExpressionPrinter.printContentModel(exp));
                throw new InternalError("assertion failed");
            }
            return new ValueExp[]{(ValueExp)exp};
        }
        Expression[] children = ((ChoiceExp)exp).getChildren();
        ValueExp[] values = new ValueExp[children.length];
        System.arraycopy(children, 0, values, 0, children.length);
        return values;
    }

    private void reportError(GeneratorContext context, String msg) throws SAXException {
        SAXParseException e = new SAXParseException(msg, this.sourceLocator);
        context.getErrorHandler().error(e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MemberInfo {
        public final String name;
        public final String javadoc;

        public MemberInfo(String _name, String _javadoc) {
            this.name = _name;
            this.javadoc = _javadoc;
        }
    }
}

