/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.test.DatabaseTestCase;
import net.sourceforge.jtds.util.Logger;

public class TimestampTest
extends DatabaseTestCase {
    static /* synthetic */ Class class$net$sourceforge$jtds$test$TimestampTest;

    public TimestampTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        boolean bl = stringArray.length > 0;
        Logger.setActive(bl);
        if (stringArray.length > 0) {
            TestSuite testSuite = new TestSuite();
            int n = 0;
            while (n < stringArray.length) {
                testSuite.addTest((Test)new TimestampTest(stringArray[n]));
                ++n;
            }
            TestRunner.run((Test)testSuite);
        } else {
            TestRunner.run((Class)(class$net$sourceforge$jtds$test$TimestampTest == null ? (class$net$sourceforge$jtds$test$TimestampTest = TimestampTest.class$("net.sourceforge.jtds.test.TimestampTest")) : class$net$sourceforge$jtds$test$TimestampTest));
        }
    }

    public void testBigint0000() throws Exception {
        Object object;
        Connection connection = this.getConnection();
        this.dropTable("#t0000");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0000   (i  decimal(28,10) not null,    s  char(10) not null) ");
        int n = 0;
        int n2 = 1;
        while (n2 <= 20) {
            object = "insert into #t0000 values (" + n2 + ", 'row" + n2 + "')";
            n += statement.executeUpdate((String)object);
            ++n2;
        }
        Assert.assertTrue((n == 20 ? 1 : 0) != 0);
        object = connection.prepareStatement("select i from #t0000 where i = ?");
        object.setLong(1, 7L);
        ResultSet resultSet = object.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((resultSet.getLong(1) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        object.setLong(1, 8L);
        resultSet = object.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((resultSet.getLong(1) == 8L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
    }

    public void testTimestamps0001() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0001");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0001               (t1 datetime not null,          t2 datetime null,              t3 smalldatetime not null,     t4 smalldatetime null)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0001 values (?, '1998-03-09 15:35:06.4',                                  ?, '1998-03-09 15:35:00')");
        Timestamp timestamp = Timestamp.valueOf("1998-03-09 15:35:06.4");
        Timestamp timestamp2 = Timestamp.valueOf("1998-03-09 15:35:00");
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.setTimestamp(2, timestamp2);
        int n = preparedStatement.executeUpdate();
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select t1, t2, t3, t4 from #t0001");
        ResultSet resultSet = preparedStatement.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertEquals((Object)timestamp, (Object)resultSet.getTimestamp(1));
        Assert.assertEquals((Object)timestamp, (Object)resultSet.getTimestamp(2));
        Assert.assertEquals((Object)timestamp2, (Object)resultSet.getTimestamp(3));
        Assert.assertEquals((Object)timestamp2, (Object)resultSet.getTimestamp(4));
    }

    public void testTimestamps0004() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0004");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0004   (mytime  datetime not null,    mytime2 datetime null,        mytime3 datetime null     )");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0004 values ('1998-09-09 15:35:05', ?, ?)");
        Timestamp timestamp = Timestamp.valueOf("1998-09-09 15:35:05");
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.setTimestamp(2, timestamp);
        int n = preparedStatement.executeUpdate();
        preparedStatement.setNull(2, 93);
        n = preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select mytime, mytime2, mytime3 from #t0004");
        ResultSet resultSet = preparedStatement.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Timestamp timestamp2 = resultSet.getTimestamp(1);
        Timestamp timestamp3 = resultSet.getTimestamp(2);
        Timestamp timestamp4 = resultSet.getTimestamp(3);
        Assert.assertEquals((Object)timestamp2, (Object)timestamp3);
        Assert.assertEquals((Object)timestamp2, (Object)timestamp4);
        Assert.assertEquals((Object)timestamp3, (Object)timestamp4);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        timestamp2 = resultSet.getTimestamp(1);
        timestamp3 = resultSet.getTimestamp(2);
        timestamp4 = resultSet.getTimestamp(3);
        Assert.assertEquals((Object)timestamp2, (Object)timestamp3);
        Assert.assertTrue((timestamp2 != timestamp4 ? 1 : 0) != 0);
        Assert.assertTrue((timestamp3 != timestamp4 ? 1 : 0) != 0);
    }

    public void testEscape(String string, String string2) throws Exception {
        String string3 = Tds.toNativeSql(string, 1);
        Assert.assertEquals((Object)string3, (Object)string2);
    }

    public void testEscapes0006() throws Exception {
        this.testEscape("select * from tmp where d={d 1999-09-19}", "select * from tmp where d='19990919'");
        this.testEscape("select * from tmp where d={d '1999-09-19'}", "select * from tmp where d='19990919'");
        this.testEscape("select * from tmp where t={t 12:34:00}", "select * from tmp where t='12:34:00'");
        this.testEscape("select * from tmp where ts={ts 1998-12-15 12:34:00.1234}", "select * from tmp where ts='19981215 12:34:00.123'");
        this.testEscape("select * from tmp where ts={ts 1998-12-15 12:34:00}", "select * from tmp where ts='19981215 12:34:00.000'");
        this.testEscape("select * from tmp where ts={ts 1998-12-15 12:34:00.1}", "select * from tmp where ts='19981215 12:34:00.100'");
        this.testEscape("select * from tmp where ts={ts 1998-12-15 12:34:00}", "select * from tmp where ts='19981215 12:34:00.000'");
        this.testEscape("select * from tmp where d={d 1999-09-19}", "select * from tmp where d='19990919'");
        this.testEscape("select * from tmp where a like '\\%%'", "select * from tmp where a like '\\%%'");
        this.testEscape("select * from tmp where a like 'b%%' {escape 'b'}", "select * from tmp where a like '\\%%' ");
        this.testEscape("select * from tmp where a like 'bbb' {escape 'b'}", "select * from tmp where a like 'bbb' ");
        this.testEscape("select * from tmp where a='{fn user}'", "select * from tmp where a='{fn user}'");
        this.testEscape("select * from tmp where a={fn user()}", "select * from tmp where a=user_name()");
    }

    public void testPreparedStatement0007() throws Exception {
        Object object;
        Connection connection = this.getConnection();
        this.dropTable("#t0007");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0007   (i  integer  not null,    s  char(10) not null) ");
        int n = 0;
        int n2 = 1;
        while (n2 <= 20) {
            object = "insert into #t0007 values (" + n2 + ", 'row" + n2 + "')";
            n += statement.executeUpdate((String)object);
            ++n2;
        }
        Assert.assertTrue((n == 20 ? 1 : 0) != 0);
        object = connection.prepareStatement("select s from #t0007 where i = ?");
        object.setInt(1, 7);
        ResultSet resultSet = object.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertEquals((Object)resultSet.getString(1).trim(), (Object)"row7");
        object.setInt(1, 8);
        resultSet = object.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertEquals((Object)resultSet.getString(1).trim(), (Object)"row8");
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
    }

    public void testPreparedStatement0008() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0008");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0008                (i  integer  not null,         s  char(10) not null)      ");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0008 values (?, ?)");
        int n = 0;
        int n2 = 1;
        while (n2 <= 8) {
            preparedStatement.setInt(1, n2);
            preparedStatement.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, n2));
            n += preparedStatement.executeUpdate();
            ++n2;
        }
        Assert.assertTrue((n == 8 ? 1 : 0) != 0);
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select s, i from #t0008");
        Assert.assertNotNull((Object)resultSet);
        n = 0;
        while (resultSet.next()) {
            ++n;
            Assert.assertTrue((resultSet.getString(1).trim().length() == resultSet.getInt(2) ? 1 : 0) != 0);
        }
        Assert.assertTrue((n == 8 ? 1 : 0) != 0);
    }

    public void testPreparedStatement0009() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0009");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0009   (i  integer  not null,         s  char(10) not null)      ");
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0009 values (?, ?)");
        int n = 8;
        int n2 = 0;
        int n3 = 1;
        while (n3 <= n) {
            preparedStatement.setInt(1, n3);
            preparedStatement.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, n3));
            n2 += preparedStatement.executeUpdate();
            ++n3;
        }
        preparedStatement.close();
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        connection.rollback();
        statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select s, i from #t0009");
        Assert.assertNotNull((Object)resultSet);
        n2 = 0;
        while (resultSet.next()) {
            ++n2;
            Assert.assertTrue((resultSet.getString(1).trim().length() == resultSet.getInt(2) ? 1 : 0) != 0);
        }
        Assert.assertTrue((n2 == 0 ? 1 : 0) != 0);
        connection.commit();
        statement.close();
        preparedStatement = connection.prepareStatement("insert into #t0009 values (?, ?)");
        n = 6;
        n2 = 0;
        int n4 = 1;
        while (n4 <= n) {
            preparedStatement.setInt(1, n4);
            preparedStatement.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, n4));
            n2 += preparedStatement.executeUpdate();
            ++n4;
        }
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        connection.commit();
        preparedStatement.close();
        statement = connection.createStatement();
        resultSet = statement.executeQuery("select s, i from #t0009");
        n2 = 0;
        while (resultSet.next()) {
            ++n2;
            Assert.assertTrue((resultSet.getString(1).trim().length() == resultSet.getInt(2) ? 1 : 0) != 0);
        }
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        connection.commit();
        statement.close();
        connection.setAutoCommit(true);
    }

    public void testTransactions0010() throws Exception {
        int n;
        Connection connection = this.getConnection();
        this.dropTable("#t0010");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0010   (i  integer  not null,         s  char(10) not null)      ");
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0010 values (?, ?)");
        int n2 = 8;
        int n3 = 0;
        int n4 = 1;
        while (n4 <= n2) {
            preparedStatement.setInt(1, n4);
            preparedStatement.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, n4));
            n3 += preparedStatement.executeUpdate();
            ++n4;
        }
        Assert.assertTrue((n3 == n2 ? 1 : 0) != 0);
        connection.rollback();
        statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select s, i from #t0010");
        Assert.assertNotNull((Object)resultSet);
        n3 = 0;
        while (resultSet.next()) {
            ++n3;
            Assert.assertTrue((resultSet.getString(1).trim().length() == resultSet.getInt(2) ? 1 : 0) != 0);
        }
        Assert.assertTrue((n3 == 0 ? 1 : 0) != 0);
        connection.commit();
        n2 = 6;
        int n5 = 1;
        while (n5 <= 2) {
            n3 = 0;
            n = 1;
            while (n <= n2) {
                preparedStatement.setInt(1, n + (n5 - 1) * n2);
                preparedStatement.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, n));
                n3 += preparedStatement.executeUpdate();
                ++n;
            }
            Assert.assertTrue((n3 == n2 ? 1 : 0) != 0);
            connection.commit();
            ++n5;
        }
        resultSet = statement.executeQuery("select s, i from #t0010");
        n3 = 0;
        while (resultSet.next()) {
            ++n3;
            n = resultSet.getInt(2);
            if (n > n2) {
                n -= n2;
            }
            Assert.assertTrue((resultSet.getString(1).trim().length() == n ? 1 : 0) != 0);
        }
        Assert.assertTrue((n3 == 2 * n2 ? 1 : 0) != 0);
        connection.commit();
        connection.setAutoCommit(true);
    }

    public void testEmptyResults0011() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0011");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0011   (mytime  datetime not null,    mytime2 datetime null     )");
        ResultSet resultSet = statement.executeQuery("select mytime, mytime2 from #t0011");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        statement.close();
        statement = connection.createStatement();
        resultSet = statement.executeQuery("select mytime, mytime2 from #t0011");
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        statement.close();
    }

    public void testEmptyResults0012() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0012");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0012   (mytime  datetime not null,    mytime2 datetime null     )");
        PreparedStatement preparedStatement = connection.prepareStatement("select mytime, mytime2 from #t0012");
        ResultSet resultSet = preparedStatement.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        preparedStatement.close();
    }

    public void testEmptyResults0013() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0013");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0013   (mytime  datetime not null,    mytime2 datetime null     )");
        ResultSet resultSet = statement.executeQuery("select mytime, mytime2 from #t0013");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        PreparedStatement preparedStatement = connection.prepareStatement("select mytime, mytime2 from #t0013");
        ResultSet resultSet2 = preparedStatement.executeQuery();
        Assert.assertNotNull((Object)resultSet2);
        Assert.assertTrue((String)"Expected no result set", (!resultSet2.next() ? 1 : 0) != 0);
    }

    public void testForBrowse0014() throws Exception {
        int n;
        Connection connection = this.getConnection();
        this.dropTable("#t0014");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0014 (i integer not null)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0014 values (?)");
        int n2 = 0;
        int n3 = 1;
        while (n3 <= 100) {
            preparedStatement.setInt(1, n3);
            n2 += preparedStatement.executeUpdate();
            ++n3;
        }
        Assert.assertTrue((n2 == 100 ? 1 : 0) != 0);
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select i from #t0014 for browse");
        ResultSet resultSet = preparedStatement.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        n2 = 0;
        while (resultSet.next()) {
            n = resultSet.getInt("i");
            ++n2;
        }
        Assert.assertTrue((n2 == 100 ? 1 : 0) != 0);
        preparedStatement.close();
        resultSet = statement.executeQuery("select * from #t0014");
        Assert.assertNotNull((Object)resultSet);
        n2 = 0;
        while (resultSet.next()) {
            n = resultSet.getInt("i");
            ++n2;
        }
        Assert.assertTrue((n2 == 100 ? 1 : 0) != 0);
        resultSet = statement.executeQuery("select * from #t0014");
        Assert.assertNotNull((Object)resultSet);
        n2 = 0;
        while (resultSet.next() && n2 < 5) {
            n = resultSet.getInt("i");
            ++n2;
        }
        Assert.assertTrue((n2 == 5 ? 1 : 0) != 0);
        resultSet = statement.executeQuery("select * from #t0014");
        Assert.assertNotNull((Object)resultSet);
        n2 = 0;
        while (resultSet.next()) {
            n = resultSet.getInt("i");
            ++n2;
        }
        Assert.assertTrue((n2 == 100 ? 1 : 0) != 0);
        statement.close();
    }

    public void testMultipleResults0015() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0015");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0015   (i  integer  not null,         s  char(10) not null)      ");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0015 values (?, ?)");
        int n = 8;
        int n2 = 0;
        int n3 = 1;
        while (n3 <= n) {
            preparedStatement.setInt(1, n3);
            preparedStatement.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, n3));
            n2 += preparedStatement.executeUpdate();
            ++n3;
        }
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        preparedStatement.close();
        statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select s from #t0015 select i from #t0015");
        Assert.assertNotNull((Object)resultSet);
        n2 = 0;
        while (resultSet.next()) {
            ++n2;
        }
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        Assert.assertTrue((boolean)statement.getMoreResults());
        resultSet = statement.getResultSet();
        Assert.assertNotNull((Object)resultSet);
        n2 = 0;
        while (resultSet.next()) {
            ++n2;
        }
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        resultSet = statement.executeQuery("select i, s from #t0015");
        n2 = 0;
        while (resultSet.next()) {
            ++n2;
        }
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        connection.close();
    }

    public void testMissingParameter0016() throws Exception {
        ResultSet resultSet;
        Object object;
        Connection connection = this.getConnection();
        this.dropTable("#t0016");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0016   (i  integer  not null,         s  char(10) not null)      ");
        statement = connection.createStatement();
        int n = 0;
        int n2 = 1;
        while (n2 <= 20) {
            object = "insert into #t0016 values (" + n2 + ", 'row" + n2 + "')";
            n += statement.executeUpdate((String)object);
            ++n2;
        }
        Assert.assertTrue((n == 20 ? 1 : 0) != 0);
        object = connection.prepareStatement("select s from #t0016 where i=? and s=?");
        try {
            resultSet = object.executeQuery();
            Assert.assertTrue((String)"Failed to throw exception", (boolean)false);
        }
        catch (SQLException sQLException) {
            Assert.assertTrue((sQLException.getMessage().equals("parameter #1 has not been set") || sQLException.getMessage().equals("parameter #2 has not been set") ? 1 : 0) != 0);
        }
        object.clearParameters();
        try {
            object.setInt(1, 7);
            object.setString(2, "row7");
            object.clearParameters();
            resultSet = object.executeQuery();
            Assert.assertTrue((String)"Failed to throw exception", (boolean)false);
        }
        catch (SQLException sQLException) {
            Assert.assertTrue((sQLException.getMessage().equals("parameter #1 has not been set") || sQLException.getMessage().equals("parameter #2 has not been set") ? 1 : 0) != 0);
        }
        object.clearParameters();
        try {
            object.setInt(1, 7);
            resultSet = object.executeQuery();
            Assert.assertTrue((String)"Failed to throw exception", (boolean)false);
        }
        catch (SQLException sQLException) {
            Assert.assertTrue((boolean)sQLException.getMessage().equals("parameter #2 has not been set"));
        }
        object.clearParameters();
        try {
            object.setString(2, "row7");
            resultSet = object.executeQuery();
            Assert.assertTrue((String)"Failed to throw exception", (boolean)false);
        }
        catch (SQLException sQLException) {
            Assert.assertTrue((boolean)sQLException.getMessage().equals("parameter #1 has not been set"));
        }
    }

    Object[][] getDatatypes() {
        return new Object[][]{{"float(6)", "65.4321", new BigDecimal("65.4321")}, {"binary(5)", "0x1213141516", new byte[]{18, 19, 20, 21, 22}}, {"varbinary(4)", "0x1718191A", new byte[]{23, 24, 25, 26}}, {"varchar(8)", "'12345678'", new String("12345678")}, {"datetime", "'19990815 21:29:59.01'", Timestamp.valueOf("1999-08-15 21:29:59.01")}, {"smalldatetime", "'19990215 20:45'", Timestamp.valueOf("1999-02-15 20:45:00")}, {"float(6)", "65.4321", new Float(65.4321)}, {"float(14)", "1.123456789", new Double(1.123456789)}, {"real", "7654321.0", new Double(7654321.0)}, {"int", "4097", new Integer(4097)}, {"float(6)", "65.4321", new BigDecimal("65.4321")}, {"float(14)", "1.123456789", new BigDecimal("1.123456789")}, {"decimal(10,3)", "1234567.089", new BigDecimal("1234567.089")}, {"numeric(5,4)", "1.2345", new BigDecimal("1.2345")}, {"smallint", "4094", new Short(4094)}, {"smallint", "127", new Byte(127)}, {"smallint", "-128", new Byte(-128)}, {"money", "19.95", new BigDecimal("19.95")}, {"smallmoney", "9.97", new BigDecimal("9.97")}, {"bit", "1", Boolean.TRUE}, {"image", "0x0a0a0b", new byte[]{10, 10, 11}}};
    }

    public void testOutputParams() throws Exception {
        Statement statement = this.con.createStatement();
        this.dropProcedure("#jtds_outputTest");
        Object[][] objectArray = this.getDatatypes();
        int n = 0;
        while (n < objectArray.length) {
            boolean bl = objectArray[n][0].equals("image");
            String string = bl ? "" : " = " + objectArray[n][1];
            String string2 = "create procedure #jtds_outputTest @a1 " + objectArray[n][0] + " = null out " + "as select @a1" + string;
            statement.executeUpdate(string2);
            int n2 = 0;
            while (n2 < 2 && !bl || n2 < 1) {
                CallableStatement callableStatement = this.con.prepareCall("{call #jtds_outputTest(?)}");
                int n3 = DatabaseTestCase.getType(objectArray[n][2]);
                if (n2 == 1) {
                    callableStatement.setObject(1, null, n3, 10);
                }
                if (n3 == 2 || n3 == 3) {
                    callableStatement.registerOutParameter(1, n3, 10);
                    if (n2 == 0) {
                        callableStatement.setObject(1, objectArray[n][2], n3, 10);
                    }
                } else if (n3 == 12) {
                    callableStatement.registerOutParameter(1, n3, 255);
                    if (n2 == 0) {
                        callableStatement.setObject(1, objectArray[n][2]);
                    }
                } else {
                    callableStatement.registerOutParameter(1, n3);
                    if (n2 == 0) {
                        callableStatement.setObject(1, objectArray[n][2]);
                    }
                }
                if (!bl) {
                    Assert.assertTrue((!callableStatement.execute() ? 1 : 0) != 0);
                }
                while (callableStatement.getUpdateCount() != -1 && callableStatement.getMoreResults()) {
                }
                if (n3 == -3) {
                    Assert.assertTrue((DatabaseTestCase.compareBytes(callableStatement.getBytes(1), (byte[])objectArray[n][2]) == 0 ? 1 : 0) != 0);
                } else if (objectArray[n][2] instanceof Number) {
                    Number number = (Number)callableStatement.getObject(1);
                    Assert.assertEquals((String)("Failed on " + objectArray[n][0]), (double)((Number)callableStatement.getObject(1)).doubleValue(), (double)((Number)objectArray[n][2]).doubleValue(), (double)0.001);
                } else {
                    Assert.assertEquals((String)("Failed on " + objectArray[n][0]), (Object)callableStatement.getObject(1), (Object)objectArray[n][2]);
                }
                ++n2;
            }
            statement.executeUpdate(" drop procedure #jtds_outputTest");
            ++n;
        }
    }

    public void testDatatypes0017() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        this.dropTable("#t0017");
    }

    public void testStatements0020() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0020a");
        this.dropTable("#t0020b");
        this.dropTable("#t0020c");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0020a (   i1   int not null,       s1   char(10) not null )                        ");
        statement.executeUpdate("create table #t0020b (   i2a   int not null,       i2b   int not null,       s2   char(10) not null )                        ");
        statement.executeUpdate("create table #t0020c (   i3   int not null,       s3   char(10) not null )                        ");
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        while (n3 < 50) {
            statement.executeUpdate("insert into #t0020a   values(" + n3 + ", " + "         'row" + n3 + "') " + "");
            int n4 = n;
            while (n % 5 != 0) {
                statement.executeUpdate("insert into #t0020b  values(" + n3 + ", " + "        " + n4 + ", " + "        'row" + n3 + "." + n4 + "' " + "        )" + "");
                int n5 = n2;
                while (n2 % 3 != 0) {
                    statement.executeUpdate("insert into #t0020c  values(" + n4 + ", " + "        'row" + n3 + "." + n4 + "." + n5 + "' " + "        )" + "");
                    ++n5;
                    ++n2;
                }
                ++n4;
                ++n;
            }
            ++n3;
        }
        Statement statement2 = connection.createStatement();
        PreparedStatement preparedStatement = connection.prepareStatement("select i2b, s2 from #t0020b where i2a=?");
        PreparedStatement preparedStatement2 = connection.prepareStatement("select s3 from #t0020c where i3=?");
        ResultSet resultSet = statement2.executeQuery("select i1 from #t0020a");
        Assert.assertNotNull((Object)resultSet);
        while (resultSet.next()) {
            int n6 = resultSet.getInt("i1");
            preparedStatement.setInt(1, resultSet.getInt("i1"));
            ResultSet resultSet2 = preparedStatement.executeQuery();
            Assert.assertNotNull((Object)resultSet2);
            while (resultSet2.next()) {
                preparedStatement2.setInt(1, resultSet2.getInt(1));
                ResultSet resultSet3 = preparedStatement2.executeQuery();
                Assert.assertNotNull((Object)resultSet3);
                if (!resultSet3.next()) continue;
            }
        }
    }

    public void testBlob0021() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
        String string = "abcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnop";
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        this.dropTable("#t0021");
        statement.executeUpdate("create table #t0021 (  mybinary         binary(16) not null,  myimage          image not null,  mynullimage      image null,  mytext           text not null,  mynulltext       text null) ");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0021(      mybinary,              myimage,               mynullimage,           mytext,                mynulltext            )                      values(?, ?, ?, ?, ?)  ");
        preparedStatement.setBytes(1, byArray);
        preparedStatement.setBytes(2, byArray2);
        preparedStatement.setBytes(3, byArray2);
        preparedStatement.setString(4, "abcd");
        preparedStatement.setString(5, "defg");
        int n = preparedStatement.executeUpdate();
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select * from #t0021");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        byte[] byArray3 = resultSet.getBytes("myimage");
        byte[] byArray4 = resultSet.getBytes("mynullimage");
        Assert.assertTrue((DatabaseTestCase.compareBytes(byArray3, byArray2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((DatabaseTestCase.compareBytes(byArray4, byArray2) == 0 ? 1 : 0) != 0);
        connection.close();
    }

    public void testNestedStatements0022() throws Exception {
        Object object;
        Connection connection = this.getConnection();
        this.dropTable("#t0022a");
        this.dropTable("#t0022b");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0022a   (i   integer not null,    str char(254) not null) ");
        statement.executeUpdate("create table #t0022b               (i   integer not null,         t   datetime not null)     ");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0022a values (?, ?)");
        PreparedStatement preparedStatement2 = connection.prepareStatement("insert into #t0022b values (?, getdate())");
        int n = 0;
        int n2 = 1;
        while (n2 <= 1000) {
            preparedStatement.setInt(1, n2);
            object = "";
            while (((String)object).length() < 240) {
                object = (String)object + "row " + n2 + ". ";
            }
            preparedStatement.setString(2, (String)object);
            n += preparedStatement.executeUpdate();
            preparedStatement2.setInt(1, n2);
            preparedStatement2.executeUpdate();
            ++n2;
        }
        Assert.assertTrue((n == 1000 ? 1 : 0) != 0);
        object = connection.createStatement();
        Statement statement2 = connection.createStatement();
        n = 0;
        ResultSet resultSet = object.executeQuery("select * from #t0022a");
        Assert.assertNotNull((Object)resultSet);
        while (resultSet.next()) {
            ++n;
            ResultSet resultSet2 = statement2.executeQuery("select * from #t0022b where i=" + resultSet.getInt("i"));
            Assert.assertNotNull((Object)resultSet2);
            Assert.assertTrue((String)"Expected a result set", (boolean)resultSet2.next());
            Assert.assertTrue((String)"Expected no result set", (!resultSet2.next() ? 1 : 0) != 0);
        }
        Assert.assertTrue((n == 1000 ? 1 : 0) != 0);
    }

    public void testPrimaryKeyFloat0023() throws Exception {
        int n;
        Double[] doubleArray = new Double[]{new Double(-1.0), new Double(1234.543), new Double(0.0), new Double(1.0), new Double(-2.0), new Double(0.14), new Double(0.79), new Double(1000000.12345), new Double(-1000000.12345), new Double(1000000.0), new Double(-1000000.0), new Double(1.7E308), new Double(1.7E-307)};
        Connection connection = this.getConnection();
        this.dropTable("#t0023");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0023   (pk   float not null,    type char(30) not null,    b    bit,    str  char(30) not null,    t int identity(1,1),    primary key (pk, type))    ");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0023 (pk, type, b, str) values(?, 'prepared', 0, ?)");
        int n2 = 0;
        while (n2 < doubleArray.length) {
            preparedStatement.setDouble(1, doubleArray[n2]);
            preparedStatement.setString(2, doubleArray[n2].toString());
            n = preparedStatement.executeUpdate();
            Assert.assertTrue((n == 1 ? 1 : 0) != 0);
            int n3 = statement.executeUpdate("insert into #t0023         (pk, type, b, str)       values(   " + doubleArray[n2] + ",         " + "       'adhoc',          " + "       1,                " + "   '" + doubleArray[n2] + "')       ");
            Assert.assertTrue((n3 == 1 ? 1 : 0) != 0);
            ++n2;
        }
        n = 0;
        ResultSet resultSet = statement.executeQuery("select * from #t0023 where type='prepared' order by t");
        Assert.assertNotNull((Object)resultSet);
        while (resultSet.next()) {
            Assert.assertEquals((Object)doubleArray[n].toString(), (Object)("" + resultSet.getDouble("pk")));
            ++n;
        }
        Assert.assertTrue((n == doubleArray.length ? 1 : 0) != 0);
        n = 0;
        resultSet = statement.executeQuery("select * from #t0023 where type='adhoc' order by t");
        while (resultSet.next()) {
            Assert.assertEquals((Object)doubleArray[n].toString(), (Object)("" + resultSet.getDouble("pk")));
            ++n;
        }
        Assert.assertTrue((n == doubleArray.length ? 1 : 0) != 0);
    }

    public void testPrimaryKeyReal0024() throws Exception {
        String string;
        String string2;
        int n;
        Float[] floatArray = new Float[]{new Float(-1.0), new Float(1234.543), new Float(0.0), new Float(1.0f), new Float(-2.0), new Float(0.14), new Float(0.79), new Float(1000000.12345), new Float(-1000000.12345), new Float(1000000.0f), new Float(-1000000.0f), new Float(3.4E38), new Float(3.4E-38)};
        Connection connection = this.getConnection();
        this.dropTable("#t0024");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0024                    (pk   real not null,                type char(30) not null,             b    bit,                           str  char(30) not null,             t int identity(1,1),     primary key (pk, type))    ");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0024 (pk, type, b, str) values(?, 'prepared', 0, ?)");
        int n2 = 0;
        while (n2 < floatArray.length) {
            preparedStatement.setFloat(1, floatArray[n2].floatValue());
            preparedStatement.setString(2, floatArray[n2].toString());
            n = preparedStatement.executeUpdate();
            Assert.assertTrue((n == 1 ? 1 : 0) != 0);
            int n3 = statement.executeUpdate("insert into #t0024         (pk, type, b, str)       values(   " + floatArray[n2] + ",         " + "       'adhoc',          " + "       1,                " + "   '" + floatArray[n2] + "')       ");
            Assert.assertTrue((n3 == 1 ? 1 : 0) != 0);
            ++n2;
        }
        n = 0;
        ResultSet resultSet = statement.executeQuery("select * from #t0024 where type='prepared' order by t");
        Assert.assertNotNull((Object)resultSet);
        while (resultSet.next()) {
            string2 = floatArray[n].toString().trim();
            string = ("" + resultSet.getFloat("pk")).trim();
            Assert.assertTrue((boolean)string2.equalsIgnoreCase(string));
            ++n;
        }
        Assert.assertTrue((n == floatArray.length ? 1 : 0) != 0);
        n = 0;
        resultSet = statement.executeQuery("select * from #t0024 where type='adhoc' order by t");
        while (resultSet.next()) {
            string2 = floatArray[n].toString().trim();
            string = ("" + resultSet.getFloat("pk")).trim();
            Assert.assertTrue((boolean)string2.equalsIgnoreCase(string));
            ++n;
        }
        Assert.assertTrue((n == floatArray.length ? 1 : 0) != 0);
    }

    public void testGetBoolean0025() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0025");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0025   (i      integer,    b      bit,        s      char(5),    f      float)   ");
        Assert.assertTrue((statement.executeUpdate("insert into #t0025 values(0, 0, 'false', 0.0)") == 1 ? 1 : 0) != 0);
        Assert.assertTrue((statement.executeUpdate("insert into #t0025 values(0, 0, '0', 0.0)") == 1 ? 1 : 0) != 0);
        Assert.assertTrue((statement.executeUpdate("insert into #t0025 values(1, 1, 'true', 7.0)") == 1 ? 1 : 0) != 0);
        Assert.assertTrue((statement.executeUpdate("insert into #t0025 values(2, 1, '1', -5.0)") == 1 ? 1 : 0) != 0);
        ResultSet resultSet = statement.executeQuery("select * from #t0025 order by i");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((!resultSet.getBoolean("i") ? 1 : 0) != 0);
        Assert.assertTrue((!resultSet.getBoolean("b") ? 1 : 0) != 0);
        Assert.assertTrue((!resultSet.getBoolean("s") ? 1 : 0) != 0);
        Assert.assertTrue((!resultSet.getBoolean("f") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((!resultSet.getBoolean("i") ? 1 : 0) != 0);
        Assert.assertTrue((!resultSet.getBoolean("b") ? 1 : 0) != 0);
        Assert.assertTrue((!resultSet.getBoolean("s") ? 1 : 0) != 0);
        Assert.assertTrue((!resultSet.getBoolean("f") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((boolean)resultSet.getBoolean("i"));
        Assert.assertTrue((boolean)resultSet.getBoolean("b"));
        Assert.assertTrue((boolean)resultSet.getBoolean("s"));
        Assert.assertTrue((boolean)resultSet.getBoolean("f"));
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((boolean)resultSet.getBoolean("i"));
        Assert.assertTrue((boolean)resultSet.getBoolean("b"));
        Assert.assertTrue((boolean)resultSet.getBoolean("s"));
        Assert.assertTrue((boolean)resultSet.getBoolean("f"));
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
    }

    public void testErrors0036() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        int n = 0;
        while (n < 5) {
            String string = "#t0036_do_not_create_" + n;
            try {
                statement.executeUpdate("drop table " + string);
                Assert.assertTrue((String)"Did not expect to reach here", (boolean)false);
            }
            catch (SQLException sQLException) {
                Assert.assertTrue((boolean)sQLException.getMessage().startsWith("Cannot drop the table '" + string + "', because it does"));
            }
            ++n;
        }
    }

    public void testTimestamps0037() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select                                      convert(smalldatetime, '1999-01-02') a,   convert(smalldatetime, null)         b,   convert(datetime, '1999-01-02')      c,   convert(datetime, null)              d  ");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((resultSet.getDate("a") != null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getDate("b") == null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getDate("c") != null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getDate("d") == null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getTime("a") != null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getTime("b") == null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getTime("c") != null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getTime("d") == null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getTimestamp("a") != null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getTimestamp("b") == null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getTimestamp("c") != null ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getTimestamp("d") == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
    }

    public void testConnection0038() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0038");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0038 ( keyfield char(255)     not null,  descField varchar(255)  not null) ");
        int n = statement.executeUpdate("insert into #t0038 values ('value', 'test')");
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        connection.setTransactionIsolation(1);
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("update #t0038 set descField=descField where keyField=?");
        preparedStatement.setString(1, "value");
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.commit();
        Statement statement2 = connection.createStatement();
        ResultSet resultSet = statement2.executeQuery("select descField from #t0038 where keyField='value'");
        Assert.assertTrue((boolean)resultSet.next());
        statement2.close();
        connection.close();
    }

    public void testConnection0039() throws Exception {
        int n = 0;
        while (n < 10) {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select 5");
            Assert.assertNotNull((Object)resultSet);
            resultSet.close();
            statement.close();
            connection.close();
            ++n;
        }
    }

    public void testPreparedStatement0040() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0040");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0040 ( c255 char(255)     not null,  v255 varchar(255)  not null) ");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0040 values (?, ?)");
        String string = this.getLongString('a');
        String string2 = this.getLongString('b');
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string);
        int n = preparedStatement.executeUpdate();
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        preparedStatement.close();
        n = statement.executeUpdate("insert into #t0040 values ( '" + string2 + "', " + "'" + string2 + "')");
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        preparedStatement = connection.prepareStatement("select c255, v255 from #t0040 order by c255");
        ResultSet resultSet = preparedStatement.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertEquals((Object)resultSet.getString("c255"), (Object)string);
        Assert.assertEquals((Object)resultSet.getString("v255"), (Object)string);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertEquals((Object)resultSet.getString("c255"), (Object)string2);
        Assert.assertEquals((Object)resultSet.getString("v255"), (Object)string2);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        preparedStatement.close();
        resultSet = statement.executeQuery("select c255, v255 from #t0040 order by c255");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertEquals((Object)resultSet.getString("c255"), (Object)string);
        Assert.assertEquals((Object)resultSet.getString("v255"), (Object)string);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertEquals((Object)resultSet.getString("c255"), (Object)string2);
        Assert.assertEquals((Object)resultSet.getString("v255"), (Object)string2);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        statement.close();
        connection.close();
    }

    public void testPreparedStatement0041() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0041");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0041   (i  integer  not null,    s  text     not null) ");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0041 values (?, ?)");
        String string = this.getLongString(400);
        int n = 0;
        int n2 = 1;
        while (n2 <= 400) {
            preparedStatement.setInt(1, n2);
            preparedStatement.setString(2, string.substring(0, n2));
            n += preparedStatement.executeUpdate();
            ++n2;
        }
        Assert.assertTrue((n == 400 ? 1 : 0) != 0);
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select s, i from #t0041");
        Assert.assertNotNull((Object)resultSet);
        n = 0;
        while (resultSet.next()) {
            resultSet.getString("s");
            ++n;
        }
        Assert.assertTrue((n == 400 ? 1 : 0) != 0);
        connection.close();
    }

    public void testPreparedStatement0042() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0042");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0042 (s char(5) null, i integer null, j integer not null)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0042 (s, i, j) values (?, ?, ?)");
        preparedStatement.setString(1, "hello");
        preparedStatement.setNull(2, 4);
        preparedStatement.setInt(3, 1);
        int n = preparedStatement.executeUpdate();
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        preparedStatement.setInt(2, 42);
        preparedStatement.setInt(3, 2);
        n = preparedStatement.executeUpdate();
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select i from #t0042 order by j");
        ResultSet resultSet = preparedStatement.executeQuery();
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        resultSet.getInt(1);
        Assert.assertTrue((boolean)resultSet.wasNull());
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((resultSet.getInt(1) == 42 ? 1 : 0) != 0);
        Assert.assertTrue((!resultSet.wasNull() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        connection.close();
    }

    public void testResultSet0043() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("select 1");
            Assert.assertNotNull((Object)resultSet);
            resultSet.getInt(1);
            Assert.assertTrue((String)"Did not expect to reach here", (boolean)false);
        }
        catch (SQLException sQLException) {
            Assert.assertTrue((boolean)sQLException.getMessage().startsWith("No current row in the ResultSet"));
        }
    }

    public void testResultSet0044() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select 1");
        Assert.assertNotNull((Object)resultSet);
        resultSet.close();
        try {
            Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        }
        catch (SQLException sQLException) {
            Assert.assertTrue((boolean)sQLException.getMessage().startsWith("Invalid state"));
        }
    }

    public void testResultSet0045() throws Exception {
        try {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select 1");
            Assert.assertNotNull((Object)resultSet);
            Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
            resultSet.getInt(1);
            Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
            resultSet.getInt(1);
            Assert.assertTrue((String)"Did not expect to reach here", (boolean)false);
        }
        catch (SQLException sQLException) {
            Assert.assertTrue((boolean)sQLException.getMessage().startsWith("No more results in ResultSet"));
        }
    }

    public void testMetaData0046() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0046");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0046 (   i integer identity,    a integer not null,    b integer null ) ");
        int n = statement.executeUpdate("insert into #t0046 (a, b) values (-2, -3)");
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        ResultSet resultSet = statement.executeQuery("select i, a, b, 17 c from #t0046");
        Assert.assertNotNull((Object)resultSet);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertNotNull((Object)resultSetMetaData);
        Assert.assertTrue((boolean)resultSetMetaData.isAutoIncrement(1));
        Assert.assertTrue((!resultSetMetaData.isAutoIncrement(2) ? 1 : 0) != 0);
        Assert.assertTrue((!resultSetMetaData.isAutoIncrement(3) ? 1 : 0) != 0);
        Assert.assertTrue((!resultSetMetaData.isAutoIncrement(4) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)resultSetMetaData.isReadOnly(1));
        Assert.assertTrue((!resultSetMetaData.isReadOnly(2) ? 1 : 0) != 0);
        Assert.assertTrue((!resultSetMetaData.isReadOnly(3) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)resultSetMetaData.isReadOnly(4));
        Assert.assertEquals((int)resultSetMetaData.isNullable(1), (int)0);
        Assert.assertEquals((int)resultSetMetaData.isNullable(2), (int)0);
        Assert.assertEquals((int)resultSetMetaData.isNullable(3), (int)1);
        resultSet.close();
    }

    public void testTimestamps0047() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0047");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0047 (                                 t1   datetime not null,         t2   datetime null,             t3   smalldatetime not null,    t4   smalldatetime null       )");
        String string = "insert into #t0047 (t1, t2, t3, t4)  values('2000-01-02 19:35:01.333',         '2000-01-02 19:35:01.333',         '2000-01-02 19:35:01.333',         '2000-01-02 19:35:01.333'  )";
        int n = statement.executeUpdate(string);
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        ResultSet resultSet = statement.executeQuery("select t1, t2, t3, t4 from #t0047");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Timestamp timestamp = resultSet.getTimestamp("t1");
        Timestamp timestamp2 = resultSet.getTimestamp("t2");
        Timestamp timestamp3 = resultSet.getTimestamp("t3");
        Timestamp timestamp4 = resultSet.getTimestamp("t4");
        Timestamp timestamp5 = Timestamp.valueOf("2000-01-02 19:35:01.333");
        Timestamp timestamp6 = Timestamp.valueOf("2000-01-02 19:35:00");
        Assert.assertEquals((Object)timestamp5, (Object)timestamp);
        Assert.assertEquals((Object)timestamp5, (Object)timestamp2);
        Assert.assertEquals((Object)timestamp6, (Object)timestamp3);
        Assert.assertEquals((Object)timestamp6, (Object)timestamp4);
    }

    public void testTimestamps0048() throws Exception {
        Connection connection = this.getConnection();
        this.dropTable("#t0048");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table #t0048              (                                 t1   datetime not null,         t2   datetime null,             t3   smalldatetime not null,    t4   smalldatetime null       )");
        Timestamp timestamp = Timestamp.valueOf("2000-01-02 19:35:01");
        Timestamp timestamp2 = Timestamp.valueOf("2000-01-02 19:35:00");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into #t0048 (t1, t2, t3, t4) values(?, ?, ?, ?)");
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.setTimestamp(2, timestamp);
        preparedStatement.setTimestamp(3, timestamp);
        preparedStatement.setTimestamp(4, timestamp);
        int n = preparedStatement.executeUpdate();
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select t1, t2, t3, t4 from #t0048");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Timestamp timestamp3 = resultSet.getTimestamp("t1");
        Timestamp timestamp4 = resultSet.getTimestamp("t2");
        Timestamp timestamp5 = resultSet.getTimestamp("t3");
        Timestamp timestamp6 = resultSet.getTimestamp("t4");
        Assert.assertEquals((Object)timestamp, (Object)timestamp3);
        Assert.assertEquals((Object)timestamp, (Object)timestamp4);
        Assert.assertEquals((Object)timestamp2, (Object)timestamp5);
        Assert.assertEquals((Object)timestamp2, (Object)timestamp6);
    }

    public void testDecimalConversion0058() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select convert(DECIMAL(4,0), 0)");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((resultSet.getInt(1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        resultSet = statement.executeQuery("select convert(DECIMAL(4,0), 1)");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((resultSet.getInt(1) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
        resultSet = statement.executeQuery("select convert(DECIMAL(4,0), -1)");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((String)"Expected a result set", (boolean)resultSet.next());
        Assert.assertTrue((resultSet.getInt(1) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!resultSet.next() ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

