/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.CursorResultSet;
import net.sourceforge.jtds.jdbc.PacketEndTokenResult;
import net.sourceforge.jtds.jdbc.PacketMsgResult;
import net.sourceforge.jtds.jdbc.PacketOutputParamResult;
import net.sourceforge.jtds.jdbc.PacketRetStatResult;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsResultSet;

public class TdsStatement
implements Statement {
    public static final String cvsVersion = "$Id: TdsStatement.java,v 1.4 2002/10/22 11:22:51 alin_sinpalean Exp $";
    private TdsConnection connection;
    SQLWarningChain warningChain;
    TdsResultSet results = null;
    private Tds actTds = null;
    private boolean escapeProcessing = true;
    private int updateCount = -1;
    private int maxFieldSize = Integer.MAX_VALUE;
    private int maxRows = 0;
    private int timeout = 0;
    private int fetchSize = 100;
    private int fetchDir = 1000;
    private int type = 1003;
    private int concurrency = 1007;
    private boolean isClosed = false;

    public TdsStatement(TdsConnection tdsConnection, int n, int n2) throws SQLException {
        this.connection = tdsConnection;
        this.warningChain = new SQLWarningChain();
        this.type = n;
        this.concurrency = n2;
    }

    public TdsStatement(TdsConnection tdsConnection) throws SQLException {
        this(tdsConnection, 1003, 1007);
    }

    protected synchronized void releaseTds() throws SQLException {
        if (this.actTds == null) {
            return;
        }
        if (this.actTds.moreResults()) {
            return;
        }
        try {
            this.connection.freeTds(this.actTds);
            this.actTds = null;
        }
        catch (TdsException tdsException) {
            throw new SQLException("Confusion in freeing Tds: " + tdsException);
        }
    }

    private void NotImplemented() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed();
        if (this.type == 1003 && this.concurrency == 1007) {
            if (this.internalExecute(string)) {
                return this.results;
            }
            throw new SQLException("No ResultSet was produced.");
        }
        return new CursorResultSet(this, string, this.fetchDir);
    }

    public final synchronized boolean internalExecute(String string) throws SQLException {
        this.checkClosed();
        return this.executeImpl(this.getTds(false), string, this.warningChain);
    }

    public final synchronized boolean internalExecute(String string, Tds tds, SQLWarningChain sQLWarningChain) throws SQLException {
        this.checkClosed();
        return this.executeImpl(tds, string, sQLWarningChain);
    }

    private final boolean executeImpl(Tds tds, String string, SQLWarningChain sQLWarningChain) throws SQLException {
        sQLWarningChain.clearWarnings();
        this.updateCount = -1;
        this.skipToEnd();
        try {
            if (this.escapeProcessing) {
                string = Tds.toNativeSql(string, tds.getServerType());
            }
            tds.executeQuery(string, this, sQLWarningChain, this.timeout);
        }
        catch (IOException iOException) {
            throw new SQLException("Network error: " + iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException("TDS error: " + tdsException.getMessage());
        }
        sQLWarningChain.checkForExceptions();
        return this.getMoreResults(tds, sQLWarningChain, true);
    }

    public final synchronized boolean internalExecuteCall(String string, ParameterListItem[] parameterListItemArray, ParameterListItem[] parameterListItemArray2, Tds tds, SQLWarningChain sQLWarningChain) throws SQLException {
        this.checkClosed();
        return this.executeCallImpl(tds, string, parameterListItemArray, parameterListItemArray2, sQLWarningChain);
    }

    private boolean executeCallImpl(Tds tds, String string, ParameterListItem[] parameterListItemArray, ParameterListItem[] parameterListItemArray2, SQLWarningChain sQLWarningChain) throws SQLException {
        boolean bl;
        sQLWarningChain.clearWarnings();
        this.skipToEnd();
        try {
            try {
                tds.executeProcedure(string, parameterListItemArray, parameterListItemArray2, this, sQLWarningChain, this.getQueryTimeout());
                bl = this.getMoreResults(tds, this.warningChain, true);
            }
            catch (TdsException tdsException) {
                throw new SQLException(tdsException.toString());
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            Object var10_7 = null;
            tds.comm.packetType = 0;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            tds.comm.packetType = 0;
            throw throwable;
        }
        return bl;
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        this.checkClosed();
        if (this.internalExecute(string)) {
            this.skipToEnd();
            throw new SQLException("executeUpdate can't return a result set");
        }
        int n = this.getUpdateCount();
        return n == -1 ? 0 : n;
    }

    protected synchronized void closeResults(boolean bl) throws SQLException {
        if (this.results != null) {
            this.results.close(bl);
            this.results = null;
        }
    }

    protected synchronized void skipToEnd() throws SQLException {
        if (this.actTds != null) {
            while (this.getMoreResults(this.actTds, this.warningChain, false) || this.updateCount != -1) {
            }
        }
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.connection.markAsClosed(this);
        if (this.actTds != null) {
            try {
                this.skipToEnd();
                this.connection.freeTds(this.actTds);
                this.actTds = null;
            }
            catch (TdsException tdsException) {
                throw new SQLException(tdsException.toString());
            }
        }
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        this.checkClosed();
        this.maxFieldSize = n;
    }

    public synchronized int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        this.checkClosed();
        if (this.maxRows < 0) {
            throw new SQLException("Negative row count");
        }
        this.maxRows = n;
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
        this.escapeProcessing = bl;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.checkClosed();
        this.timeout = n;
    }

    public void cancel() throws SQLException {
        this.checkClosed();
        try {
            if (this.actTds != null) {
                this.actTds.cancel();
            }
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain.getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain.clearWarnings();
    }

    public void setCursorName(String string) throws SQLException {
    }

    public synchronized boolean execute(String string) throws SQLException {
        this.checkClosed();
        return this.internalExecute(string);
    }

    synchronized Tds getTds(boolean bl) throws SQLException {
        if (bl) {
            return this.connection.allocateTds(bl);
        }
        if (this.actTds == null) {
            this.actTds = this.connection.allocateTds(bl);
            this.actTds.setStatement(this);
            return this.actTds;
        }
        return this.actTds;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.results;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.updateCount;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return this.getMoreResults(this.actTds, this.warningChain, true);
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    void handleRetStat(PacketRetStatResult packetRetStatResult) {
    }

    void handleParamResult(PacketOutputParamResult packetOutputParamResult) throws SQLException {
    }

    synchronized boolean getMoreResults(Tds tds, SQLWarningChain sQLWarningChain, boolean bl) throws SQLException {
        this.updateCount = -1;
        if (tds == null) {
            return false;
        }
        this.closeResults(false);
        if (!tds.moreResults()) {
            if (bl) {
                this.releaseTds();
            }
            return false;
        }
        try {
            block16: {
                while (true) {
                    if (tds.isResultSet()) {
                        this.results = new TdsResultSet(tds, this, sQLWarningChain, this.fetchSize);
                        break block16;
                    }
                    if (tds.peek() == -3 || tds.getStatement() instanceof PreparedStatement && !(tds.getStatement() instanceof CallableStatement) && tds.peek() == -1) {
                        PacketEndTokenResult packetEndTokenResult = (PacketEndTokenResult)tds.processSubPacket();
                        this.updateCount = packetEndTokenResult.getRowCount();
                        tds.goToNextResult(sQLWarningChain);
                        if (bl) {
                            this.releaseTds();
                        }
                        break block16;
                    }
                    if (tds.isEndOfResults()) {
                        tds.processSubPacket();
                        tds.goToNextResult(sQLWarningChain);
                        if (tds.moreResults()) continue;
                        if (bl) {
                            this.releaseTds();
                        }
                        break block16;
                    }
                    if (tds.isMessagePacket() || tds.isErrorPacket()) {
                        sQLWarningChain.addOrReturn((PacketMsgResult)tds.processSubPacket());
                        continue;
                    }
                    if (tds.isRetStat()) {
                        this.handleRetStat((PacketRetStatResult)tds.processSubPacket());
                        continue;
                    }
                    if (tds.isParamResult()) {
                        this.handleParamResult((PacketOutputParamResult)tds.processSubPacket());
                        continue;
                    }
                    if (tds.isEnvChange()) {
                        tds.processSubPacket();
                        continue;
                    }
                    if (!tds.isProcId()) break;
                    tds.processSubPacket();
                }
                throw new SQLException("Protocol confusion. Got a 0x" + Integer.toHexString(tds.peek() & 0xFF) + " packet.");
            }
            sQLWarningChain.checkForExceptions();
            return this.results != null;
        }
        catch (Exception exception) {
            this.releaseTds();
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException("Network error: " + exception.getMessage());
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException("Invalid fetch direction.");
        }
        this.fetchDir = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Invalid fetch size.");
        }
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.concurrency;
    }

    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.type;
    }

    public void addBatch(String string) throws SQLException {
        this.NotImplemented();
    }

    public void clearBatch() throws SQLException {
        this.NotImplemented();
    }

    public int[] executeBatch() throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    protected synchronized void changeSettings(boolean bl, int n) throws SQLException {
        String string;
        if (this.actTds != null && (string = this.actTds.sqlStatementForSettings(bl, n)) != null) {
            this.executeImpl(this.actTds, string, this.warningChain);
            this.skipToEnd();
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Statement already closed.");
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Not Implemented");
    }
}

