/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;

public abstract class EscapeProcessor {
    public static final String cvsVersion = "$Id: EscapeProcessor.java,v 1.4 2002/10/22 09:50:10 alin_sinpalean Exp $";
    String input;
    private static final String ESCAPE_PREFIX_DATE = "d ";
    private static final String ESCAPE_PREFIX_TIME = "t ";
    private static final String ESCAPE_PREFIX_TIMESTAMP = "ts ";
    private static final String ESCAPE_PREFIX_OUTER_JOIN = "oj ";
    private static final String ESCAPE_PREFIX_FUNCTION = "fn ";
    private static final String ESCAPE_PREFIX_CALL = "call ";
    private static final String ESCAPE_PREFIX_ESCAPE_CHAR = "escape ";

    public EscapeProcessor(String string) {
        this.input = string;
    }

    public abstract String expandDBSpecificFunction(String var1) throws SQLException;

    private static boolean validDigits(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static int skipWhitespace(String string, int n) {
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static int skipQuote(String string, int n) {
        if (n < string.length() && (string.charAt(n) == '\'' || string.charAt(n) == '\"')) {
            ++n;
        }
        return n;
    }

    private static String getDate(String string) throws SQLException {
        int n = 2;
        n = EscapeProcessor.skipWhitespace(string, n);
        n = EscapeProcessor.skipQuote(string, n);
        if (string.length() - n < 10 || string.charAt(n + 4) != '-' || string.charAt(n + 7) != '-') {
            throw new SQLException("Malformed date");
        }
        String string2 = string.substring(n, n + 4);
        String string3 = string.substring(n + 5, n + 5 + 2);
        String string4 = string.substring(n + 5 + 3, n + 5 + 3 + 2);
        if (!(EscapeProcessor.validDigits(string2) && EscapeProcessor.validDigits(string3) && EscapeProcessor.validDigits(string4))) {
            throw new SQLException("Malformed date");
        }
        n += 10;
        n = EscapeProcessor.skipWhitespace(string, n);
        n = EscapeProcessor.skipQuote(string, n);
        if ((n = EscapeProcessor.skipWhitespace(string, n)) < string.length()) {
            throw new SQLException("Malformed date");
        }
        return "'" + string2 + string3 + string4 + "'";
    }

    private static String getTime(String string) throws SQLException {
        int n = 2;
        n = EscapeProcessor.skipWhitespace(string, n);
        n = EscapeProcessor.skipQuote(string, n);
        if (string.length() - n < 8 || string.charAt(n + 2) != ':' || string.charAt(n + 5) != ':') {
            throw new SQLException("Malformed time");
        }
        String string2 = string.substring(n, n + 2);
        String string3 = string.substring(n + 3, n + 3 + 2);
        String string4 = string.substring(n + 3 + 3, n + 3 + 3 + 2);
        if (!(EscapeProcessor.validDigits(string2) && EscapeProcessor.validDigits(string3) && EscapeProcessor.validDigits(string4))) {
            throw new SQLException("Malformed time");
        }
        n += 8;
        n = EscapeProcessor.skipWhitespace(string, n);
        n = EscapeProcessor.skipQuote(string, n);
        if ((n = EscapeProcessor.skipWhitespace(string, n)) < string.length()) {
            throw new SQLException("Malformed time");
        }
        return "'" + string2 + ":" + string3 + ":" + string4 + "'";
    }

    /*
     * Unable to fully structure code
     */
    private static String getTimestamp(String var0) throws SQLException {
        block7: {
            var1_1 = 2;
            var1_1 = EscapeProcessor.skipWhitespace(var0, var1_1);
            var1_1 = EscapeProcessor.skipQuote(var0, var1_1);
            if (var0.length() - var1_1 < 19 || var0.charAt(var1_1 + 4) != '-' || var0.charAt(var1_1 + 7) != '-') {
                throw new SQLException("Malformed date");
            }
            var2_2 = var0.substring(var1_1, var1_1 + 4);
            var3_3 = var0.substring(var1_1 + 5, var1_1 + 5 + 2);
            var4_4 = var0.substring(var1_1 + 5 + 3, var1_1 + 5 + 3 + 2);
            if (!(EscapeProcessor.validDigits(var2_2) && EscapeProcessor.validDigits(var3_3) && EscapeProcessor.validDigits(var4_4))) {
                throw new SQLException("Malformed date");
            }
            if (!Character.isWhitespace(var0.charAt(var1_1 += 10))) {
                throw new SQLException("Malformed date");
            }
            var1_1 = EscapeProcessor.skipWhitespace(var0, var1_1);
            if (var0.length() - var1_1 < 8 || var0.charAt(var1_1 + 2) != ':' || var0.charAt(var1_1 + 5) != ':') {
                throw new SQLException("Malformed time");
            }
            var5_5 = var0.substring(var1_1, var1_1 + 2);
            var6_6 = var0.substring(var1_1 + 3, var1_1 + 3 + 2);
            var7_7 = var0.substring(var1_1 + 3 + 3, var1_1 + 3 + 3 + 2);
            var8_8 = "000";
            if (var0.length() <= (var1_1 += 8) || var0.charAt(var1_1) != '.') break block7;
            var8_8 = "";
            ++var1_1;
            while (var0.length() > var1_1 && EscapeProcessor.validDigits(var0.substring(var1_1, var1_1 + 1))) {
                var8_8 = var8_8 + var0.substring(var1_1++, var1_1);
            }
            if (var8_8.length() <= 3) ** GOTO lbl30
            var8_8 = var8_8.substring(0, 3);
            break block7;
lbl-1000:
            // 1 sources

            {
                var8_8 = var8_8 + "0";
lbl30:
                // 2 sources

                ** while (var8_8.length() < 3)
            }
        }
        var1_1 = EscapeProcessor.skipWhitespace(var0, var1_1);
        var1_1 = EscapeProcessor.skipQuote(var0, var1_1);
        if ((var1_1 = EscapeProcessor.skipWhitespace(var0, var1_1)) < var0.length()) {
            throw new SQLException("Malformed date");
        }
        return "'" + var2_2 + var3_3 + var4_4 + " " + var5_5 + ":" + var6_6 + ":" + var7_7 + "." + var8_8 + "'";
    }

    public String expandEscape(String string) throws SQLException {
        String string2 = new String(string);
        String string3 = null;
        if (EscapeProcessor.startsWithIgnoreCase(string2, ESCAPE_PREFIX_FUNCTION)) {
            string3 = this.expandCommonFunction(string2 = string2.substring(ESCAPE_PREFIX_FUNCTION.length()));
            if (string3 == null) {
                string3 = this.expandDBSpecificFunction(string2);
            }
            if (string3 == null) {
                string3 = string2;
            }
        } else if (EscapeProcessor.startsWithIgnoreCase(string2, ESCAPE_PREFIX_CALL) || string2.startsWith("?=") && EscapeProcessor.startsWithIgnoreCase(string2.substring(2).trim(), ESCAPE_PREFIX_CALL)) {
            boolean bl = string2.startsWith("?=");
            int n = (string2 = string2.substring(string2.indexOf("call") + 4).trim()).indexOf(40);
            if (n >= 0) {
                if (string2.charAt(string2.length() - 1) != ')') {
                    throw new SQLException("Malformed procedure call: " + string2);
                }
                string3 = "exec " + (bl ? "?=" : "") + string2.substring(0, n) + " " + string2.substring(n + 1, string2.length() - 1);
            } else {
                string3 = "exec " + (bl ? "?=" : "") + string2;
            }
        } else if (EscapeProcessor.startsWithIgnoreCase(string2, ESCAPE_PREFIX_DATE)) {
            string3 = EscapeProcessor.getDate(string2);
        } else if (EscapeProcessor.startsWithIgnoreCase(string2, ESCAPE_PREFIX_TIME)) {
            string3 = EscapeProcessor.getTime(string2);
        } else if (EscapeProcessor.startsWithIgnoreCase(string2, ESCAPE_PREFIX_TIMESTAMP)) {
            string3 = EscapeProcessor.getTimestamp(string2);
        } else if (EscapeProcessor.startsWithIgnoreCase(string2, ESCAPE_PREFIX_OUTER_JOIN)) {
            string3 = string2.substring(ESCAPE_PREFIX_OUTER_JOIN.length()).trim();
        } else {
            throw new SQLException("Unrecognized escape sequence: " + string);
        }
        return string3;
    }

    public String expandCommonFunction(String string) throws SQLException {
        String string2 = null;
        int n = string.indexOf(40);
        if (n < 0) {
            throw new SQLException("Malformed function escape: " + string);
        }
        String string3 = string.substring(0, n).trim();
        if (string3.equalsIgnoreCase("user")) {
            string2 = "user_name" + string.substring(n);
        } else if (string3.equalsIgnoreCase("database")) {
            string2 = "db_name" + string.substring(n);
        } else if (string3.equalsIgnoreCase("ifnull")) {
            string2 = "isnull" + string.substring(n);
        } else if (string3.equalsIgnoreCase("now")) {
            string2 = "getdate" + string.substring(n);
        } else if (string3.equalsIgnoreCase("atan2")) {
            string2 = "atn2" + string.substring(n);
        } else if (string3.equalsIgnoreCase("length")) {
            string2 = "len" + string.substring(n);
        } else if (string3.equalsIgnoreCase("locate")) {
            string2 = "charindex" + string.substring(n);
        } else if (string3.equalsIgnoreCase("repeat")) {
            string2 = "replicate" + string.substring(n);
        } else if (string3.equalsIgnoreCase("insert")) {
            string2 = "stuff" + string.substring(n);
        } else if (string3.equalsIgnoreCase("lcase")) {
            string2 = "lower" + string.substring(n);
        } else if (string3.equalsIgnoreCase("ucase")) {
            string2 = "upper" + string.substring(n);
        }
        return string2;
    }

    public String nativeString() throws SQLException {
        return this.nativeString(this.input, '\\');
    }

    private String nativeString(String string, char c) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String string2 = "";
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            switch (n) {
                case 0: {
                    if (c2 == '{') {
                        n2 = n3;
                        n = 3;
                        string2 = "";
                        break;
                    }
                    stringBuffer.append(c2);
                    if (c2 != '\'') break;
                    n = 1;
                    break;
                }
                case 1: 
                case 2: {
                    if (n3 + 1 < string.length() && c2 == c && (string.charAt(n3 + 1) == '_' || string.charAt(n3 + 1) == '%')) {
                        c2 = string.charAt(++n3);
                        stringBuffer.append('\\');
                        stringBuffer.append(c2);
                        break;
                    }
                    stringBuffer.append(c2);
                    if (n == 2) {
                        n = 1;
                        break;
                    }
                    if (c2 == '\\') {
                        n = 2;
                    }
                    if (c2 != '\'') break;
                    n = 0;
                    break;
                }
                case 3: {
                    if (c2 == '}') {
                        if (EscapeProcessor.startsWithIgnoreCase(string2 = string2.trim(), ESCAPE_PREFIX_ESCAPE_CHAR)) {
                            if (n3 + 1 != string.length()) {
                                throw new SQLException("Malformed statement. Escape clause must be at the end of the query.");
                            }
                            char c3 = EscapeProcessor.findEscapeCharacter(string2);
                            stringBuffer.delete(0, stringBuffer.length());
                            stringBuffer.append(this.nativeString(string.substring(0, n2), c3));
                            n = 0;
                            break;
                        }
                        n = 0;
                        stringBuffer.append(this.expandEscape(string2));
                        n2 = -1;
                        break;
                    }
                    string2 = string2 + c2;
                    if (c2 != '\'') break;
                    n = 4;
                    break;
                }
                case 4: 
                case 5: {
                    string2 = string2 + c2;
                    if (n == 5) {
                        n = 4;
                        break;
                    }
                    if (c2 != '\'') break;
                    n = 3;
                    break;
                }
                default: {
                    throw new SQLException("Internal error.  Unknown state in FSM");
                }
            }
            ++n3;
        }
        if (n != 0 && n != 1) {
            throw new SQLException("Syntax error in SQL escape syntax");
        }
        return stringBuffer.toString();
    }

    static char findEscapeCharacter(String string) throws SQLException {
        String string2 = string.trim();
        if (!string2.substring(0, 6).equalsIgnoreCase("escape")) {
            throw new SQLException("Internal Error");
        }
        if ((string2 = string2.substring(6).trim()).length() != 3 || string2.charAt(0) != '\'' || string2.charAt(2) != '\'') {
            throw new SQLException("Malformed escape clause: |" + string + "|");
        }
        return string2.charAt(1);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        int n = string2.length() - 1;
        while (n >= 0) {
            if (Character.toLowerCase(string.charAt(n)) != Character.toLowerCase(string2.charAt(n))) {
                return false;
            }
            --n;
        }
        return true;
    }
}

