/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.util;

import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.Messages;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXBSource
extends SAXSource {
    private final Marshaller marshaller;
    private final Object contentObject;
    private final XMLReader pseudoParser = new XMLReader(){
        private EntityResolver entityResolver;
        private DTDHandler dtdHandler;
        private XMLFilterImpl repeater = new XMLFilterImpl();
        private ErrorHandler errorHandler;

        public boolean getFeature(String name) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        public Object getProperty(String name) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        public void setEntityResolver(EntityResolver resolver) {
            this.entityResolver = resolver;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public void setDTDHandler(DTDHandler handler) {
            this.dtdHandler = handler;
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public void setContentHandler(ContentHandler handler) {
            this.repeater.setContentHandler(handler);
        }

        public ContentHandler getContentHandler() {
            return this.repeater.getContentHandler();
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void parse(InputSource input) throws IOException, SAXException {
            this.parse();
        }

        public void parse(String systemId) throws IOException, SAXException {
            this.parse();
        }

        public void parse() throws SAXException {
            try {
                JAXBSource.this.marshaller.marshal(JAXBSource.this.contentObject, this.repeater);
            }
            catch (JAXBException e) {
                SAXParseException se = new SAXParseException(e.getMessage(), null, null, -1, -1, e);
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(se);
                }
                throw se;
            }
        }
    };

    public JAXBSource(JAXBContext context, Object contentObject) throws JAXBException {
        this(context == null ? JAXBSource.assertionFailed(Messages.format("JAXBSource.NullContext")) : context.createMarshaller(), contentObject == null ? JAXBSource.assertionFailed(Messages.format("JAXBSource.NullContent")) : contentObject);
    }

    public JAXBSource(Marshaller marshaller, Object contentObject) throws JAXBException {
        if (marshaller == null) {
            throw new JAXBException(Messages.format("JAXBSource.NullMarshaller"));
        }
        if (contentObject == null) {
            throw new JAXBException(Messages.format("JAXBSource.NullContent"));
        }
        this.marshaller = marshaller;
        this.contentObject = contentObject;
        super.setXMLReader(this.pseudoParser);
        super.setInputSource(new InputSource());
    }

    private static Marshaller assertionFailed(String message) throws JAXBException {
        throw new JAXBException(message);
    }
}

