/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.models.XSAllCM;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.models.XSDFACM;
import org.apache.xerces.impl.xs.models.XSEmptyCM;

public class CMBuilder {
    private XSDeclarationPool fDeclPool = null;
    private static XSEmptyCM fEmptyCM = new XSEmptyCM();
    private int fLeafCount;
    private int fParticleCount;

    public CMBuilder() {
        this.fDeclPool = null;
    }

    public CMBuilder(XSDeclarationPool pool) {
        this.fDeclPool = pool;
    }

    public void setDeclPool(XSDeclarationPool declPool) {
        this.fDeclPool = declPool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl typeDecl) {
        short contentType = typeDecl.getContentType();
        if (contentType == 1 || contentType == 0) {
            return null;
        }
        XSParticleDecl particle = (XSParticleDecl)typeDecl.getParticle();
        if (particle == null) {
            return fEmptyCM;
        }
        XSCMValidator cmValidator = null;
        cmValidator = particle.fType == 3 && ((XSModelGroupImpl)particle.fValue).fCompositor == 103 ? this.createAllCM(particle) : this.createDFACM(particle);
        if (cmValidator == null) {
            cmValidator = fEmptyCM;
        }
        return cmValidator;
    }

    XSCMValidator createAllCM(XSParticleDecl particle) {
        if (particle.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
        XSAllCM allContent = new XSAllCM(particle.fMinOccurs == 0, group.fParticleCount);
        int i = 0;
        while (i < group.fParticleCount) {
            if (group.fParticles[i].fType != 0 && group.fParticles[i].fMaxOccurs != 0) {
                allContent.addElement((XSElementDecl)group.fParticles[i].fValue, group.fParticles[i].fMinOccurs == 0);
            }
            ++i;
        }
        return allContent;
    }

    XSCMValidator createDFACM(XSParticleDecl particle) {
        this.fLeafCount = 0;
        this.fParticleCount = 0;
        CMNode node = this.buildSyntaxTree(particle);
        if (node == null) {
            return null;
        }
        return new XSDFACM(node, this.fLeafCount);
    }

    private CMNode buildSyntaxTree(XSParticleDecl particle) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        short type = particle.fType;
        CMNode nodeRet = null;
        if (type == 2 || type == 1) {
            nodeRet = new XSCMLeaf(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.expandContentModel(nodeRet, minOccurs, maxOccurs);
        } else if (type == 3) {
            XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
            CMNode temp = null;
            boolean twoChildren = false;
            int i = 0;
            while (i < group.fParticleCount) {
                temp = this.buildSyntaxTree(group.fParticles[i]);
                if (temp != null) {
                    if (nodeRet == null) {
                        nodeRet = temp;
                    } else {
                        nodeRet = new XSCMBinOp(group.fCompositor, nodeRet, temp);
                        twoChildren = true;
                    }
                }
                ++i;
            }
            if (nodeRet != null) {
                if (group.fCompositor == 101 && !twoChildren && group.fParticleCount > 1) {
                    nodeRet = new XSCMUniOp(5, nodeRet);
                }
                nodeRet = this.expandContentModel(nodeRet, minOccurs, maxOccurs);
            }
        }
        return nodeRet;
    }

    private CMNode expandContentModel(CMNode node, int minOccurs, int maxOccurs) {
        CMNode nodeRet;
        block5: {
            int i;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                nodeRet = null;
                                if (minOccurs != 1 || maxOccurs != 1) break block4;
                                nodeRet = node;
                                break block5;
                            }
                            if (minOccurs != 0 || maxOccurs != 1) break block6;
                            nodeRet = new XSCMUniOp(5, node);
                            break block5;
                        }
                        if (minOccurs != 0 || maxOccurs != -1) break block7;
                        nodeRet = new XSCMUniOp(4, node);
                        break block5;
                    }
                    if (minOccurs != 1 || maxOccurs != -1) break block8;
                    nodeRet = new XSCMUniOp(6, node);
                    break block5;
                }
                if (maxOccurs != -1) break block9;
                nodeRet = new XSCMUniOp(6, node);
                int i2 = 0;
                while (i2 < minOccurs - 1) {
                    nodeRet = new XSCMBinOp(102, this.copyNode(node), nodeRet);
                    ++i2;
                }
                break block5;
            }
            if (minOccurs > 0) {
                nodeRet = node;
                i = 0;
                while (i < minOccurs - 1) {
                    nodeRet = new XSCMBinOp(102, nodeRet, this.copyNode(node));
                    ++i;
                }
            }
            if (maxOccurs <= minOccurs) break block5;
            node = new XSCMUniOp(5, node);
            nodeRet = nodeRet == null ? node : new XSCMBinOp(102, nodeRet, this.copyNode(node));
            i = minOccurs;
            while (i < maxOccurs - 1) {
                nodeRet = new XSCMBinOp(102, nodeRet, this.copyNode(node));
                ++i;
            }
        }
        return nodeRet;
    }

    private CMNode copyNode(CMNode node) {
        int type = node.type();
        if (type == 101 || type == 102) {
            XSCMBinOp bin = (XSCMBinOp)node;
            node = new XSCMBinOp(type, this.copyNode(bin.getLeft()), this.copyNode(bin.getRight()));
        } else if (type == 4 || type == 6 || type == 5) {
            XSCMUniOp uni = (XSCMUniOp)node;
            node = new XSCMUniOp(type, this.copyNode(uni.getChild()));
        } else if (type == 1 || type == 2) {
            XSCMLeaf leaf = (XSCMLeaf)node;
            node = new XSCMLeaf(leaf.type(), leaf.getLeaf(), leaf.getParticleId(), this.fLeafCount++);
        }
        return node;
    }
}

