/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.AttributePSVImpl;
import org.apache.xerces.impl.xs.ElementPSVImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSModelImpl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IDValue;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLSchemaValidator
implements XMLComponent,
XMLDocumentFilter,
FieldActivator,
RevalidationHandler {
    private static final boolean DEBUG = false;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SCHEMA_ELEMENT_DEFAULT = "http://apache.org/xml/features/validation/schema/element-default";
    protected static final String SCHEMA_AUGMENT_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/continue-after-fatal-error"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, null, null, null, null, null};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource", "http://java.sun.com/xml/jaxp/properties/schemaLanguage"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null, null, null, null, null};
    protected static final int ID_CONSTRAINT_NUM = 1;
    protected ElementPSVImpl fCurrentPSVI = new ElementPSVImpl();
    protected final AugmentationsImpl fAugmentations = new AugmentationsImpl();
    protected XMLString fDefaultValue;
    protected boolean fDynamicValidation = false;
    protected boolean fDoValidation = false;
    protected boolean fFullChecking = false;
    protected boolean fNormalizeData = true;
    protected boolean fSchemaElementDefault = true;
    protected boolean fAugPSVI = true;
    protected boolean fEntityRef = false;
    protected boolean fInCDATA = false;
    protected SymbolTable fSymbolTable;
    protected final XSIErrorReporter fXSIErrorReporter = new XSIErrorReporter();
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager = null;
    protected ValidationState fValidationState = new ValidationState();
    protected XMLGrammarPool fGrammarPool;
    protected String fExternalSchemas = null;
    protected String fExternalNoNamespaceSchema = null;
    protected Object fJaxpSchemaSource = null;
    final XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    protected final XSDDescription fXSDDescription = new XSDDescription();
    protected final Hashtable fLocationPairs = new Hashtable();
    protected final XMLSchemaLoader.LocationArray fNoNamespaceLocationArray = new XMLSchemaLoader.LocationArray();
    protected String fBaseURI = null;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    static final int INITIAL_STACK_SIZE = 8;
    static final int INC_STACK_SIZE = 8;
    private static final boolean DEBUG_NORMALIZATION = false;
    private final XMLString fEmptyXMLStr = new XMLString(null, 0, -1);
    private static final int BUFFER_SIZE = 20;
    private final XMLString fNormalizedStr = new XMLString();
    private boolean fFirstChunk = true;
    private boolean fTrailing = false;
    private short fWhiteSpace = (short)-1;
    private boolean fUnionType = false;
    final XSGrammarBucket fGrammarBucket;
    final SubstitutionGroupHandler fSubGroupHandler;
    final XMLSchemaLoader fSchemaLoader;
    final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    final CMBuilder fCMBuilder = new CMBuilder();
    String fValidationRoot;
    int fSkipValidationDepth;
    int fNFullValidationDepth;
    int fNNoneValidationDepth;
    int fElementDepth;
    boolean fSubElement;
    boolean[] fSubElementStack = new boolean[8];
    XSElementDecl fCurrentElemDecl;
    XSElementDecl[] fElemDeclStack = new XSElementDecl[8];
    boolean fNil;
    boolean[] fNilStack = new boolean[8];
    XSNotationDecl fNotation;
    XSNotationDecl[] fNotationStack = new XSNotationDecl[8];
    XSTypeDecl fCurrentType;
    XSTypeDecl[] fTypeStack = new XSTypeDecl[8];
    XSCMValidator fCurrentCM;
    XSCMValidator[] fCMStack = new XSCMValidator[8];
    int[] fCurrCMState;
    int[][] fCMStateStack = new int[8][];
    boolean fStrictAssess = true;
    boolean[] fStrictAssessStack = new boolean[8];
    final StringBuffer fBuffer = new StringBuffer();
    boolean fAppendBuffer = true;
    boolean fSawText = false;
    boolean[] fSawTextStack = new boolean[8];
    boolean fSawCharacters = false;
    boolean[] fStringContent = new boolean[8];
    boolean fSawChildren = false;
    boolean[] fSawChildrenStack = new boolean[8];
    final QName fTempQName = new QName();
    ValidatedInfo fValidatedInfo = new ValidatedInfo();
    private ValidationState fState4XsiType = new ValidationState();
    private ValidationState fState4ApplyDefault = new ValidationState();
    protected XPathMatcherStack fMatcherStack = new XPathMatcherStack();
    protected ValueStoreCache fValueStoreCache = new ValueStoreCache();

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String featureId) {
        int i = 0;
        while (i < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[i].equals(featureId)) {
                return FEATURE_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        int i = 0;
        while (i < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[i].equals(propertyId)) {
                return PROPERTY_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentSource(XMLDocumentSource source) {
        this.fDocumentSource = source;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.fValidationState.setNamespaceSupport(namespaceContext);
        this.fState4XsiType.setNamespaceSupport(namespaceContext);
        this.fState4ApplyDefault.setNamespaceSupport(namespaceContext);
        this.handleStartDocument(locator, encoding);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(locator, encoding, namespaceContext, augs);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(version, encoding, standalone, augs);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(rootElement, publicId, systemId, augs);
        }
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startPrefixMapping(prefix, uri, augs);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Augmentations modifiedAugs = this.handleStartElement(element, attributes, augs);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(element, attributes, modifiedAugs);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Augmentations modifiedAugs = this.handleStartElement(element, attributes, augs);
        this.fDefaultValue = null;
        if (this.fElementDepth != -2) {
            modifiedAugs = this.handleEndElement(element, modifiedAugs);
        }
        if (this.fDocumentHandler != null) {
            if (!this.fSchemaElementDefault || this.fDefaultValue == null) {
                this.fDocumentHandler.emptyElement(element, attributes, modifiedAugs);
            } else {
                this.fDocumentHandler.startElement(element, attributes, modifiedAugs);
                this.fDocumentHandler.characters(this.fDefaultValue, null);
                this.fDocumentHandler.endElement(element, modifiedAugs);
            }
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        text = this.handleCharacters(text);
        if (this.fDocumentHandler != null) {
            if (this.fNormalizeData && this.fUnionType) {
                if (augs != null) {
                    this.fDocumentHandler.characters(this.fEmptyXMLStr, augs);
                }
            } else {
                this.fDocumentHandler.characters(text, augs);
            }
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.handleIgnorableWhitespace(text);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(text, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.fDefaultValue = null;
        Augmentations modifiedAugs = this.handleEndElement(element, augs);
        if (this.fDocumentHandler != null) {
            if (!this.fSchemaElementDefault || this.fDefaultValue == null) {
                this.fDocumentHandler.endElement(element, modifiedAugs);
            } else {
                this.fDocumentHandler.characters(this.fDefaultValue, null);
                this.fDocumentHandler.endElement(element, modifiedAugs);
            }
        }
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endPrefixMapping(prefix, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.fInCDATA = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.fInCDATA = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(augs);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        this.handleEndDocument();
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augs);
        }
    }

    public void setBaseURI(String base) {
        this.fBaseURI = base;
    }

    public boolean characterData(String data, Augmentations augs) {
        boolean bl = this.fSawText = this.fSawText || data.length() > 0;
        if (this.fNormalizeData && this.fWhiteSpace != -1 && this.fWhiteSpace != 0) {
            this.normalizeWhitespace(data, this.fWhiteSpace == 2);
            this.fBuffer.append(this.fNormalizedStr.ch, this.fNormalizedStr.offset, this.fNormalizedStr.length);
        } else if (this.fAppendBuffer) {
            this.fBuffer.append(data);
        }
        boolean allWhiteSpace = true;
        if (this.fCurrentType != null && this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
            if (ctype.fContentType == 2) {
                int i = 0;
                while (i < data.length()) {
                    if (!XMLChar.isSpace(data.charAt(i))) {
                        allWhiteSpace = false;
                        this.fSawCharacters = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        this.fFirstChunk = false;
        return allWhiteSpace;
    }

    public void elementDefault(String data) {
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        this.fEntityRef = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startGeneralEntity(name, identifier, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(version, encoding, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        this.fSawChildren = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(text, augs);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        this.fSawChildren = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(target, data, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        this.fEntityRef = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endGeneralEntity(name, augs);
        }
    }

    public XMLSchemaValidator() {
        this.fGrammarBucket = new XSGrammarBucket();
        this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
        this.fSchemaLoader = new XMLSchemaLoader(this.fXSIErrorReporter.fErrorReporter, this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder);
        this.fState4XsiType.setExtraChecking(false);
        this.fState4ApplyDefault.setFacetChecking(false);
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fXSIErrorReporter.reset((XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER));
        this.fSchemaLoader.setProperty(ERROR_REPORTER, this.fXSIErrorReporter.fErrorReporter);
        SymbolTable symbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        if (symbolTable != this.fSymbolTable) {
            this.fSchemaLoader.setProperty(SYMBOL_TABLE, symbolTable);
            this.fSymbolTable = symbolTable;
        }
        try {
            this.fDynamicValidation = componentManager.getFeature(DYNAMIC_VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fDynamicValidation = false;
        }
        if (this.fDynamicValidation) {
            this.fDoValidation = true;
        } else {
            try {
                this.fDoValidation = componentManager.getFeature(VALIDATION);
            }
            catch (XMLConfigurationException e) {
                this.fDoValidation = false;
            }
        }
        if (this.fDoValidation) {
            try {
                this.fDoValidation = componentManager.getFeature(SCHEMA_VALIDATION);
            }
            catch (XMLConfigurationException e) {
                // empty catch block
            }
        }
        try {
            this.fFullChecking = componentManager.getFeature(SCHEMA_FULL_CHECKING);
        }
        catch (XMLConfigurationException e) {
            this.fFullChecking = false;
        }
        this.fSchemaLoader.setFeature(SCHEMA_FULL_CHECKING, false);
        try {
            this.fNormalizeData = componentManager.getFeature(NORMALIZE_DATA);
        }
        catch (XMLConfigurationException e) {
            this.fNormalizeData = false;
        }
        try {
            this.fSchemaElementDefault = componentManager.getFeature(SCHEMA_ELEMENT_DEFAULT);
        }
        catch (XMLConfigurationException e) {
            this.fSchemaElementDefault = false;
        }
        try {
            this.fAugPSVI = componentManager.getFeature(SCHEMA_AUGMENT_PSVI);
        }
        catch (XMLConfigurationException e) {
            this.fAugPSVI = true;
        }
        this.fEntityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_MANAGER);
        this.fSchemaLoader.setEntityResolver(this.fEntityResolver);
        this.fValidationManager = (ValidationManager)componentManager.getProperty(VALIDATION_MANAGER);
        this.fValidationManager.addValidationState(this.fValidationState);
        this.fValidationState.setSymbolTable(this.fSymbolTable);
        this.fLocationPairs.clear();
        this.fNoNamespaceLocationArray.resize(0, 2);
        try {
            this.fExternalSchemas = (String)componentManager.getProperty(SCHEMA_LOCATION);
            this.fExternalNoNamespaceSchema = (String)componentManager.getProperty(SCHEMA_NONS_LOCATION);
        }
        catch (XMLConfigurationException e) {
            this.fExternalSchemas = null;
            this.fExternalNoNamespaceSchema = null;
        }
        this.fSchemaLoader.setProperty(SCHEMA_LOCATION, this.fExternalSchemas);
        this.fSchemaLoader.setProperty(SCHEMA_NONS_LOCATION, this.fExternalNoNamespaceSchema);
        this.storeLocations(this.fExternalSchemas, this.fExternalNoNamespaceSchema);
        try {
            this.fJaxpSchemaSource = componentManager.getProperty(JAXP_SCHEMA_SOURCE);
        }
        catch (XMLConfigurationException e) {
            this.fJaxpSchemaSource = null;
        }
        this.fSchemaLoader.setProperty(JAXP_SCHEMA_SOURCE, this.fJaxpSchemaSource);
        this.fResourceIdentifier.clear();
        try {
            this.fGrammarPool = (XMLGrammarPool)componentManager.getProperty(XMLGRAMMAR_POOL);
        }
        catch (XMLConfigurationException e) {
            this.fGrammarPool = null;
        }
        this.fSchemaLoader.setProperty(XMLGRAMMAR_POOL, this.fGrammarPool);
        try {
            boolean allowJavaEncodings = componentManager.getFeature(ALLOW_JAVA_ENCODINGS);
            this.fSchemaLoader.setFeature(ALLOW_JAVA_ENCODINGS, allowJavaEncodings);
        }
        catch (XMLConfigurationException e) {
            // empty catch block
        }
        try {
            boolean fatalError = componentManager.getFeature(CONTINUE_AFTER_FATAL_ERROR);
            this.fSchemaLoader.setFeature(CONTINUE_AFTER_FATAL_ERROR, fatalError);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        this.fSchemaLoader.reset();
        this.fCurrentElemDecl = null;
        this.fCurrentCM = null;
        this.fCurrCMState = null;
        this.fSkipValidationDepth = -1;
        this.fNFullValidationDepth = -1;
        this.fNNoneValidationDepth = -1;
        this.fElementDepth = -1;
        this.fSubElement = false;
        this.fEntityRef = false;
        this.fInCDATA = false;
        this.fMatcherStack.clear();
        this.fBaseURI = null;
        this.fState4XsiType.setSymbolTable(symbolTable);
        this.fState4ApplyDefault.setSymbolTable(symbolTable);
    }

    public void startValueScopeFor(IdentityConstraint identityConstraint, int initialDepth) throws XNIException {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(identityConstraint, initialDepth);
        valueStore.startValueScope();
    }

    public XPathMatcher activateField(Field field, int initialDepth) {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(field.getIdentityConstraint(), initialDepth);
        field.setMayMatch(true);
        XPathMatcher matcher = field.createMatcher(valueStore);
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment(this.fSymbolTable);
        return matcher;
    }

    public void endValueScopeFor(IdentityConstraint identityConstraint, int initialDepth) throws XNIException {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(identityConstraint, initialDepth);
        valueStore.endValueScope();
    }

    private void activateSelectorFor(IdentityConstraint ic) throws XNIException {
        Selector selector = ic.getSelector();
        XMLSchemaValidator activator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher matcher = selector.createMatcher(activator, this.fElementDepth);
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment(this.fSymbolTable);
    }

    void ensureStackCapacity() {
        if (this.fElementDepth == this.fElemDeclStack.length) {
            int newSize = this.fElementDepth + 8;
            boolean[] newArrayB = new boolean[newSize];
            System.arraycopy(this.fSubElementStack, 0, newArrayB, 0, this.fElementDepth);
            this.fSubElementStack = newArrayB;
            XSElementDecl[] newArrayE = new XSElementDecl[newSize];
            System.arraycopy(this.fElemDeclStack, 0, newArrayE, 0, this.fElementDepth);
            this.fElemDeclStack = newArrayE;
            newArrayB = new boolean[newSize];
            System.arraycopy(this.fNilStack, 0, newArrayB, 0, this.fElementDepth);
            this.fNilStack = newArrayB;
            XSNotationDecl[] newArrayN = new XSNotationDecl[newSize];
            System.arraycopy(this.fNotationStack, 0, newArrayN, 0, this.fElementDepth);
            this.fNotationStack = newArrayN;
            XSTypeDecl[] newArrayT = new XSTypeDecl[newSize];
            System.arraycopy(this.fTypeStack, 0, newArrayT, 0, this.fElementDepth);
            this.fTypeStack = newArrayT;
            XSCMValidator[] newArrayC = new XSCMValidator[newSize];
            System.arraycopy(this.fCMStack, 0, newArrayC, 0, this.fElementDepth);
            this.fCMStack = newArrayC;
            newArrayB = new boolean[newSize];
            System.arraycopy(this.fSawTextStack, 0, newArrayB, 0, this.fElementDepth);
            this.fSawTextStack = newArrayB;
            newArrayB = new boolean[newSize];
            System.arraycopy(this.fStringContent, 0, newArrayB, 0, this.fElementDepth);
            this.fStringContent = newArrayB;
            newArrayB = new boolean[newSize];
            System.arraycopy(this.fSawChildrenStack, 0, newArrayB, 0, this.fElementDepth);
            this.fSawChildrenStack = newArrayB;
            newArrayB = new boolean[newSize];
            System.arraycopy(this.fStrictAssessStack, 0, newArrayB, 0, this.fElementDepth);
            this.fStrictAssessStack = newArrayB;
            int[][] newArrayIA = new int[newSize][];
            System.arraycopy(this.fCMStateStack, 0, newArrayIA, 0, this.fElementDepth);
            this.fCMStateStack = newArrayIA;
        }
    }

    void handleStartDocument(XMLLocator locator, String encoding) {
        this.fValueStoreCache.startDocument();
    }

    void handleEndDocument() {
        this.fValueStoreCache.endDocument();
    }

    XMLString handleCharacters(XMLString text) {
        if (this.fSkipValidationDepth >= 0) {
            return text;
        }
        boolean bl = this.fSawText = this.fSawText || text.length > 0;
        if (this.fNormalizeData && this.fWhiteSpace != -1 && this.fWhiteSpace != 0) {
            this.normalizeWhitespace(text, this.fWhiteSpace == 2);
            text = this.fNormalizedStr;
        }
        if (this.fAppendBuffer) {
            this.fBuffer.append(text.ch, text.offset, text.length);
        }
        if (this.fCurrentType != null && this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
            if (ctype.fContentType == 2) {
                int i = text.offset;
                while (i < text.offset + text.length) {
                    if (!XMLChar.isSpace(text.ch[i])) {
                        this.fSawCharacters = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        this.fFirstChunk = false;
        return text;
    }

    private void normalizeWhitespace(XMLString value, boolean collapse) {
        int spaces;
        boolean skipSpace = collapse;
        boolean sawNonWS = false;
        int leading = 0;
        int trailing = 0;
        int size = value.offset + value.length;
        if (this.fNormalizedStr.ch == null || this.fNormalizedStr.ch.length < value.length + 1) {
            this.fNormalizedStr.ch = new char[value.length + 1];
        }
        this.fNormalizedStr.offset = 1;
        this.fNormalizedStr.length = 1;
        int i = value.offset;
        while (i < size) {
            char c = value.ch[i];
            if (XMLChar.isSpace(c)) {
                if (!skipSpace) {
                    this.fNormalizedStr.ch[this.fNormalizedStr.length++] = 32;
                    skipSpace = collapse;
                }
                if (!sawNonWS) {
                    leading = 1;
                }
            } else {
                this.fNormalizedStr.ch[this.fNormalizedStr.length++] = c;
                skipSpace = false;
                sawNonWS = true;
            }
            ++i;
        }
        if (skipSpace) {
            if (this.fNormalizedStr.length > 1) {
                --this.fNormalizedStr.length;
                trailing = 2;
            } else if (leading != 0 && !sawNonWS) {
                trailing = 2;
            }
        }
        int n = spaces = collapse ? leading + trailing : 0;
        if (this.fNormalizedStr.length > 1 && !this.fFirstChunk && this.fWhiteSpace == 2) {
            if (this.fTrailing) {
                this.fNormalizedStr.offset = 0;
                this.fNormalizedStr.ch[0] = 32;
            } else if (spaces == 1 || spaces == 3) {
                this.fNormalizedStr.offset = 0;
                this.fNormalizedStr.ch[0] = 32;
            }
        }
        this.fNormalizedStr.length -= this.fNormalizedStr.offset;
        this.fTrailing = spaces > 1;
    }

    private void normalizeWhitespace(String value, boolean collapse) {
        boolean skipSpace = collapse;
        int size = value.length();
        if (this.fNormalizedStr.ch == null || this.fNormalizedStr.ch.length < size) {
            this.fNormalizedStr.ch = new char[size];
        }
        this.fNormalizedStr.offset = 0;
        this.fNormalizedStr.length = 0;
        int i = 0;
        while (i < size) {
            char c = value.charAt(i);
            if (XMLChar.isSpace(c)) {
                if (!skipSpace) {
                    this.fNormalizedStr.ch[this.fNormalizedStr.length++] = 32;
                    skipSpace = collapse;
                }
            } else {
                this.fNormalizedStr.ch[this.fNormalizedStr.length++] = c;
                skipSpace = false;
            }
            ++i;
        }
        if (skipSpace && this.fNormalizedStr.length != 0) {
            --this.fNormalizedStr.length;
        }
    }

    void handleIgnorableWhitespace(XMLString text) {
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
    }

    Augmentations handleStartElement(QName element, XMLAttributes attributes, Augmentations augs) {
        String xsiNil;
        XSComplexTypeDecl ctype;
        String xsiType;
        if (this.fElementDepth == -1 && this.fValidationManager.isGrammarFound()) {
            this.fDynamicValidation = true;
        }
        String sLocation = attributes.getValue(SchemaSymbols.URI_XSI, SchemaSymbols.XSI_SCHEMALOCATION);
        String nsLocation = attributes.getValue(SchemaSymbols.URI_XSI, SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
        this.storeLocations(sLocation, nsLocation);
        if (this.fSkipValidationDepth >= 0) {
            ++this.fElementDepth;
            if (this.fAugPSVI) {
                augs = this.getEmptyAugs(augs);
            }
            return augs;
        }
        SchemaGrammar sGrammar = this.findSchemaGrammar((short)5, element.uri, null, element, attributes);
        Object decl = null;
        if (this.fCurrentCM != null) {
            decl = this.fCurrentCM.oneTransition(element, this.fCurrCMState, this.fSubGroupHandler);
            if (this.fCurrCMState[0] == -1) {
                XSComplexTypeDecl ctype2 = (XSComplexTypeDecl)this.fCurrentType;
                if (ctype2.fParticle != null) {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{element.rawname, ctype2.fParticle.toString()});
                } else {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{element.rawname, "mixed with no element content"});
                }
            }
        }
        this.fXSIErrorReporter.pushContext();
        if (this.fElementDepth != -1) {
            this.ensureStackCapacity();
            this.fSubElementStack[this.fElementDepth] = true;
            this.fSubElement = false;
            this.fElemDeclStack[this.fElementDepth] = this.fCurrentElemDecl;
            this.fNilStack[this.fElementDepth] = this.fNil;
            this.fNotationStack[this.fElementDepth] = this.fNotation;
            this.fTypeStack[this.fElementDepth] = this.fCurrentType;
            this.fStrictAssessStack[this.fElementDepth] = this.fStrictAssess;
            this.fCMStack[this.fElementDepth] = this.fCurrentCM;
            this.fCMStateStack[this.fElementDepth] = this.fCurrCMState;
            this.fSawTextStack[this.fElementDepth] = this.fSawText;
            this.fStringContent[this.fElementDepth] = this.fSawCharacters;
            this.fSawChildrenStack[this.fElementDepth] = this.fSawChildren;
        }
        ++this.fElementDepth;
        this.fCurrentElemDecl = null;
        XSWildcardDecl wildcard = null;
        this.fCurrentType = null;
        this.fStrictAssess = true;
        this.fNil = false;
        this.fNotation = null;
        this.fBuffer.setLength(0);
        this.fSawText = false;
        this.fSawCharacters = false;
        this.fSawChildren = false;
        if (decl != null) {
            if (decl instanceof XSElementDecl) {
                this.fCurrentElemDecl = (XSElementDecl)decl;
            } else {
                wildcard = (XSWildcardDecl)decl;
            }
        }
        if (wildcard != null && wildcard.fProcessContents == 2) {
            this.fSkipValidationDepth = this.fElementDepth;
            if (this.fAugPSVI) {
                augs = this.getEmptyAugs(augs);
            }
            return augs;
        }
        if (this.fCurrentElemDecl == null && sGrammar != null) {
            this.fCurrentElemDecl = sGrammar.getGlobalElementDecl(element.localpart);
        }
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getIsAbstract()) {
            this.reportSchemaError("cvc-elt.2", new Object[]{element.rawname});
        }
        if (this.fCurrentElemDecl != null) {
            this.fCurrentType = this.fCurrentElemDecl.fType;
        }
        if ((xsiType = attributes.getValue(SchemaSymbols.URI_XSI, SchemaSymbols.XSI_TYPE)) != null) {
            this.fCurrentType = this.getAndCheckXsiType(element, xsiType, attributes);
        }
        if (this.fCurrentType == null) {
            if (this.fElementDepth == 0) {
                if (this.fDynamicValidation) {
                    if (this.fDocumentSource != null) {
                        this.fDocumentSource.setDocumentHandler(this.fDocumentHandler);
                        if (this.fDocumentHandler != null) {
                            this.fDocumentHandler.setDocumentSource(this.fDocumentSource);
                        }
                        this.fElementDepth = -2;
                        return augs;
                    }
                    this.fSkipValidationDepth = this.fElementDepth;
                    if (this.fAugPSVI) {
                        augs = this.getEmptyAugs(augs);
                    }
                    return augs;
                }
                this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "cvc-elt.1", new Object[]{element.rawname}, (short)1);
            } else if (wildcard != null && wildcard.fProcessContents == 1) {
                this.reportSchemaError("cvc-complex-type.2.4.c", new Object[]{element.rawname});
            }
            this.fCurrentType = SchemaGrammar.fAnyType;
            this.fStrictAssess = false;
            this.fNFullValidationDepth = this.fElementDepth;
            this.fAppendBuffer = false;
        } else {
            this.fNNoneValidationDepth = this.fElementDepth;
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2) {
                this.fAppendBuffer = true;
            } else if (this.fCurrentType.getTypeCategory() == 14) {
                this.fAppendBuffer = true;
            } else {
                ctype = (XSComplexTypeDecl)this.fCurrentType;
                boolean bl = this.fAppendBuffer = ctype.fContentType == 1;
            }
        }
        if (this.fElementDepth == 0) {
            this.fValidationRoot = element.rawname;
        }
        if (this.fNormalizeData) {
            this.fFirstChunk = true;
            this.fTrailing = false;
            this.fUnionType = false;
            this.fWhiteSpace = (short)-1;
        }
        if (this.fCurrentType.getTypeCategory() == 13) {
            ctype = (XSComplexTypeDecl)this.fCurrentType;
            if (ctype.getIsAbstract()) {
                this.reportSchemaError("cvc-type.2", new Object[]{"Element " + element.rawname + " is declared with a type that is abstract.  Use xsi:type to specify a non-abstract type"});
            }
            if (this.fNormalizeData && ctype.fContentType == 1) {
                if (ctype.fXSSimpleType.getVariety() == 3) {
                    this.fUnionType = true;
                } else {
                    try {
                        this.fWhiteSpace = ctype.fXSSimpleType.getWhitespace();
                    }
                    catch (DatatypeException e) {}
                }
            }
        } else if (this.fNormalizeData) {
            XSSimpleType dv = (XSSimpleType)this.fCurrentType;
            if (dv.getVariety() == 3) {
                this.fUnionType = true;
            } else {
                try {
                    this.fWhiteSpace = dv.getWhitespace();
                }
                catch (DatatypeException e) {
                    // empty catch block
                }
            }
        }
        this.fCurrentCM = null;
        if (this.fCurrentType.getTypeCategory() == 13) {
            this.fCurrentCM = ((XSComplexTypeDecl)this.fCurrentType).getContentModel(this.fCMBuilder);
        }
        this.fCurrCMState = null;
        if (this.fCurrentCM != null) {
            this.fCurrCMState = this.fCurrentCM.startContentModel();
        }
        if ((xsiNil = attributes.getValue(SchemaSymbols.URI_XSI, SchemaSymbols.XSI_NIL)) != null && this.fCurrentElemDecl != null) {
            this.fNil = this.getXsiNil(element, xsiNil);
        }
        XSAttributeGroupDecl attrGrp = null;
        if (this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl ctype3 = (XSComplexTypeDecl)this.fCurrentType;
            attrGrp = ctype3.getAttrGrp();
        }
        this.processAttributes(element, attributes, attrGrp);
        if (attrGrp != null) {
            this.addDefaultAttributes(element, attributes, attrGrp);
        }
        this.fValueStoreCache.startElement();
        this.fMatcherStack.pushContext();
        if (this.fCurrentElemDecl != null) {
            this.fValueStoreCache.initValueStoresFor(this.fCurrentElemDecl);
            int icCount = this.fCurrentElemDecl.fIDCPos;
            int uniqueOrKey = 0;
            while (uniqueOrKey < icCount) {
                if (this.fCurrentElemDecl.fIDConstraints[uniqueOrKey].getCategory() == 2) break;
                this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[uniqueOrKey]);
                ++uniqueOrKey;
            }
            int keyref = uniqueOrKey;
            while (keyref < icCount) {
                this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[keyref]);
                ++keyref;
            }
        }
        int count = this.fMatcherStack.getMatcherCount();
        int i = 0;
        while (i < count) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.startElement(element, attributes, this.fCurrentElemDecl);
            ++i;
        }
        if (this.fAugPSVI) {
            augs = this.getEmptyAugs(augs);
            this.fCurrentPSVI.fValidationContext = this.fValidationRoot;
            this.fCurrentPSVI.fDeclaration = this.fCurrentElemDecl;
            this.fCurrentPSVI.fTypeDecl = this.fCurrentType;
            this.fCurrentPSVI.fNotation = this.fNotation;
        }
        return augs;
    }

    Augmentations handleEndElement(QName element, Augmentations augs) {
        if (this.fSkipValidationDepth >= 0) {
            if (this.fSkipValidationDepth == this.fElementDepth && this.fSkipValidationDepth > 0) {
                this.fNFullValidationDepth = this.fSkipValidationDepth - 1;
                this.fSkipValidationDepth = -1;
                --this.fElementDepth;
                this.fSubElement = this.fSubElementStack[this.fElementDepth];
                this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
                this.fNil = this.fNilStack[this.fElementDepth];
                this.fNotation = this.fNotationStack[this.fElementDepth];
                this.fCurrentType = this.fTypeStack[this.fElementDepth];
                this.fCurrentCM = this.fCMStack[this.fElementDepth];
                this.fStrictAssess = this.fStrictAssessStack[this.fElementDepth];
                this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
                this.fSawText = this.fSawTextStack[this.fElementDepth];
                this.fSawCharacters = this.fStringContent[this.fElementDepth];
                this.fSawChildren = this.fSawChildrenStack[this.fElementDepth];
            } else {
                --this.fElementDepth;
            }
            if (this.fElementDepth == -1 && this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
            if (this.fAugPSVI) {
                augs = this.getEmptyAugs(augs);
            }
            return augs;
        }
        this.processElementContent(element);
        int oldCount = this.fMatcherStack.getMatcherCount();
        int i = oldCount - 1;
        while (i >= 0) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.endElement(element, this.fCurrentElemDecl, this.fDefaultValue == null ? this.fValidatedInfo.normalizedValue : this.fCurrentElemDecl.fDefault.normalizedValue);
            --i;
        }
        if (this.fMatcherStack.size() > 0) {
            this.fMatcherStack.popContext();
        }
        int newCount = this.fMatcherStack.getMatcherCount();
        int i2 = oldCount - 1;
        while (i2 >= newCount) {
            Selector.Matcher selMatcher;
            IdentityConstraint id;
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i2);
            if (matcher instanceof Selector.Matcher && (id = (selMatcher = (Selector.Matcher)matcher).getIdentityConstraint()) != null && id.getCategory() != 2) {
                this.fValueStoreCache.transplant(id, selMatcher.getInitialDepth());
            }
            --i2;
        }
        int i3 = oldCount - 1;
        while (i3 >= newCount) {
            ValueStoreBase values;
            Selector.Matcher selMatcher;
            IdentityConstraint id;
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i3);
            if (matcher instanceof Selector.Matcher && (id = (selMatcher = (Selector.Matcher)matcher).getIdentityConstraint()) != null && id.getCategory() == 2 && (values = this.fValueStoreCache.getValueStoreFor(id, selMatcher.getInitialDepth())) != null) {
                values.endDocumentFragment();
            }
            --i3;
        }
        this.fValueStoreCache.endElement();
        Grammar[] grammars = null;
        if (this.fElementDepth == 0) {
            String invIdRef = this.fValidationState.checkIDRefID();
            if (invIdRef != null) {
                this.reportSchemaError("cvc-id.1", new Object[]{invIdRef});
            }
            if (this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
            this.fValidationState.resetIDTables();
            grammars = this.fGrammarBucket.getGrammars();
            if (this.fGrammarPool != null) {
                this.fGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", grammars);
            }
            augs = this.endElementPSVI(true, (SchemaGrammar[])grammars, augs);
        } else {
            augs = this.endElementPSVI(false, (SchemaGrammar[])grammars, augs);
            --this.fElementDepth;
            this.fSubElement = this.fSubElementStack[this.fElementDepth];
            this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
            this.fNil = this.fNilStack[this.fElementDepth];
            this.fNotation = this.fNotationStack[this.fElementDepth];
            this.fCurrentType = this.fTypeStack[this.fElementDepth];
            this.fCurrentCM = this.fCMStack[this.fElementDepth];
            this.fStrictAssess = this.fStrictAssessStack[this.fElementDepth];
            this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
            this.fSawText = this.fSawTextStack[this.fElementDepth];
            this.fSawCharacters = this.fStringContent[this.fElementDepth];
            this.fSawChildren = this.fSawChildrenStack[this.fElementDepth];
            this.fWhiteSpace = (short)-1;
            this.fAppendBuffer = false;
            this.fUnionType = false;
        }
        return augs;
    }

    final Augmentations endElementPSVI(boolean root, SchemaGrammar[] grammars, Augmentations augs) {
        if (this.fAugPSVI) {
            augs = this.getEmptyAugs(augs);
            this.fCurrentPSVI.fDeclaration = this.fCurrentElemDecl;
            this.fCurrentPSVI.fTypeDecl = this.fCurrentType;
            this.fCurrentPSVI.fNotation = this.fNotation;
            this.fCurrentPSVI.fValidationContext = this.fValidationRoot;
            if (this.fElementDepth > this.fNFullValidationDepth) {
                this.fCurrentPSVI.fValidationAttempted = (short)2;
            } else if (this.fElementDepth > this.fNNoneValidationDepth) {
                this.fCurrentPSVI.fValidationAttempted = 0;
            } else {
                this.fCurrentPSVI.fValidationAttempted = 1;
                this.fNFullValidationDepth = this.fNNoneValidationDepth = this.fElementDepth - 1;
            }
            if (this.fDefaultValue != null) {
                this.fCurrentPSVI.fSpecified = true;
            }
            this.fCurrentPSVI.fNil = this.fNil;
            this.fCurrentPSVI.fMemberType = this.fValidatedInfo.memberType;
            this.fCurrentPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
            if (this.fStrictAssess) {
                String[] errors = this.fXSIErrorReporter.mergeContext();
                this.fCurrentPSVI.fErrorCodes = errors;
                this.fCurrentPSVI.fValidity = (short)(errors == null ? 2 : 1);
            } else {
                this.fCurrentPSVI.fValidity = 0;
                this.fXSIErrorReporter.popContext();
            }
            if (root) {
                this.fCurrentPSVI.fSchemaInformation = new XSModelImpl(grammars);
            }
        }
        return augs;
    }

    Augmentations getEmptyAugs(Augmentations augs) {
        if (augs == null) {
            augs = this.fAugmentations;
            augs.clear();
        }
        augs.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        this.fCurrentPSVI.reset();
        return augs;
    }

    void storeLocations(String sLocation, String nsLocation) {
        if (sLocation != null && !XMLSchemaLoader.tokenizeSchemaLocationStr(sLocation, this.fLocationPairs)) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{sLocation}, (short)0);
        }
        if (nsLocation != null) {
            this.fNoNamespaceLocationArray.addLocation(nsLocation);
            this.fLocationPairs.put(XMLSymbols.EMPTY_STRING, this.fNoNamespaceLocationArray);
        }
    }

    SchemaGrammar findSchemaGrammar(short contextType, String namespace, QName enclosingElement, QName triggeringComponet, XMLAttributes attributes) {
        SchemaGrammar grammar = null;
        grammar = this.fGrammarBucket.getGrammar(namespace);
        if (grammar == null) {
            this.fXSDDescription.reset();
            this.fXSDDescription.fContextType = contextType;
            this.fXSDDescription.fTargetNamespace = namespace;
            this.fXSDDescription.fEnclosedElementName = enclosingElement;
            this.fXSDDescription.fTriggeringComponent = triggeringComponet;
            this.fXSDDescription.fAttributes = attributes;
            if (this.fBaseURI != null) {
                this.fXSDDescription.setBaseSystemId(this.fBaseURI);
            }
            String[] temp = null;
            if (namespace != null) {
                Object locationArray = this.fLocationPairs.get(namespace);
                if (locationArray != null) {
                    temp = ((XMLSchemaLoader.LocationArray)locationArray).getLocationArray();
                }
            } else {
                temp = this.fNoNamespaceLocationArray.getLocationArray();
            }
            if (temp != null && temp.length != 0) {
                this.fXSDDescription.fLocationHints = new String[temp.length];
                System.arraycopy(temp, 0, this.fXSDDescription.fLocationHints, 0, temp.length);
            }
            if (this.fGrammarPool != null && (grammar = (SchemaGrammar)this.fGrammarPool.retrieveGrammar(this.fXSDDescription)) != null && !this.fGrammarBucket.putGrammar(grammar, true)) {
                this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
                grammar = null;
            }
            if (grammar == null) {
                try {
                    XMLInputSource xis = XMLSchemaLoader.resolveDocument(this.fXSDDescription, this.fLocationPairs, this.fEntityResolver);
                    grammar = this.fSchemaLoader.loadSchema(this.fXSDDescription, xis, this.fLocationPairs);
                }
                catch (IOException ex) {
                    this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{this.fXSDDescription.getLocationHints()[0]}, (short)0);
                }
            }
        }
        return grammar;
    }

    XSTypeDecl getAndCheckXsiType(QName element, String xsiType, XMLAttributes attributes) {
        SchemaGrammar grammar;
        QName typeName = null;
        try {
            typeName = (QName)this.fQNameDV.validate(xsiType, (ValidationContext)this.fValidationState, null);
        }
        catch (InvalidDatatypeValueException e) {
            this.reportSchemaError(e.getKey(), e.getArgs());
            this.reportSchemaError("cvc-elt.4.1", new Object[]{element.rawname, SchemaSymbols.URI_XSI + "," + SchemaSymbols.XSI_TYPE, xsiType});
            return null;
        }
        XSTypeDecl type = null;
        if (typeName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA) {
            type = SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(typeName.localpart);
        }
        if (type == null && (grammar = this.findSchemaGrammar((short)7, typeName.uri, element, typeName, attributes)) != null) {
            type = grammar.getGlobalTypeDecl(typeName.localpart);
        }
        if (type == null) {
            this.reportSchemaError("cvc-elt.4.2", new Object[]{element.rawname, xsiType});
            return null;
        }
        if (this.fCurrentType != null) {
            short block = this.fCurrentElemDecl.fBlock;
            if (this.fCurrentType.getTypeCategory() == 13) {
                block = (short)(block | ((XSComplexTypeDecl)this.fCurrentType).fBlock);
            }
            if (!XSConstraints.checkTypeDerivationOk(type, this.fCurrentType, block)) {
                this.reportSchemaError("cvc-elt.4.3", new Object[]{element.rawname, xsiType});
            }
        }
        return type;
    }

    boolean getXsiNil(QName element, String xsiNil) {
        if (this.fCurrentElemDecl != null && !this.fCurrentElemDecl.getIsNillable()) {
            this.reportSchemaError("cvc-elt.3.1", new Object[]{element.rawname, SchemaSymbols.URI_XSI + "," + SchemaSymbols.XSI_NIL});
        } else {
            String value = xsiNil.trim();
            if (value.equals("true") || value.equals("1")) {
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2) {
                    this.reportSchemaError("cvc-elt.3.2.2", new Object[]{element.rawname, SchemaSymbols.URI_XSI + "," + SchemaSymbols.XSI_NIL});
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    void processAttributes(QName element, XMLAttributes attributes, XSAttributeGroupDecl attrGrp) {
        wildcardIDName = null;
        attCount = attributes.getLength();
        augs = null;
        attrPSVI = null;
        isSimple = this.fCurrentType == null || this.fCurrentType.getTypeCategory() == 14;
        attrUses = null;
        useCount = 0;
        attrWildcard = null;
        if (!isSimple) {
            attrUses = attrGrp.getAttributeUses();
            useCount = attrUses.getLength();
            attrWildcard = attrGrp.fAttributeWC;
        }
        index = 0;
        while (index < attCount) {
            block26: {
                block29: {
                    block28: {
                        block27: {
                            block25: {
                                attributes.getName(index, this.fTempQName);
                                if (this.fAugPSVI) {
                                    augs = attributes.getAugmentations(index);
                                    attrPSVI = (AttributePSVImpl)augs.getItem("ATTRIBUTE_PSVI");
                                    if (attrPSVI != null) {
                                        attrPSVI.reset();
                                    } else {
                                        attrPSVI = new AttributePSVImpl();
                                        augs.putItem("ATTRIBUTE_PSVI", attrPSVI);
                                    }
                                    attrPSVI.fValidationContext = this.fValidationRoot;
                                }
                                if (this.fTempQName.uri != SchemaSymbols.URI_XSI) break block25;
                                attrDecl = null;
                                if (this.fTempQName.localpart == SchemaSymbols.XSI_SCHEMALOCATION) {
                                    attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_SCHEMALOCATION);
                                } else if (this.fTempQName.localpart == SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION) {
                                    attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
                                } else if (this.fTempQName.localpart == SchemaSymbols.XSI_NIL) {
                                    attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NIL);
                                } else if (this.fTempQName.localpart == SchemaSymbols.XSI_TYPE) {
                                    attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_TYPE);
                                }
                                if (attrDecl == null) break block25;
                                this.processOneAttribute(element, attributes, index, attrDecl, null, attrPSVI);
                                break block26;
                            }
                            if (this.fTempQName.rawname == XMLSymbols.PREFIX_XMLNS || this.fTempQName.rawname.startsWith("xmlns:")) break block26;
                            if (!isSimple) break block27;
                            this.reportSchemaError("cvc-type.3.1.1", new Object[]{element.rawname});
                            break block26;
                        }
                        currUse = null;
                        i = 0;
                        while (i < useCount) {
                            oneUse = (XSAttributeUseImpl)attrUses.getItem(i);
                            if (oneUse.fAttrDecl.fName == this.fTempQName.localpart && oneUse.fAttrDecl.fTargetNamespace == this.fTempQName.uri) {
                                currUse = oneUse;
                                break;
                            }
                            ++i;
                        }
                        if (currUse != null || attrWildcard != null && attrWildcard.allowNamespace(this.fTempQName.uri)) break block28;
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{element.rawname, this.fTempQName.rawname});
                        break block26;
                    }
                    currDecl = null;
                    if (currUse == null) break block29;
                    currDecl = currUse.fAttrDecl;
                    ** GOTO lbl79
                }
                if (attrWildcard.fProcessContents == 2) break block26;
                grammar = this.findSchemaGrammar((short)6, this.fTempQName.uri, element, this.fTempQName, attributes);
                if (grammar != null) {
                    currDecl = grammar.getGlobalAttributeDecl(this.fTempQName.localpart);
                }
                if (currDecl == null) {
                    if (attrWildcard.fProcessContents == 1) {
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{element.rawname, this.fTempQName.rawname});
                    }
                } else {
                    if (currDecl.fType.getTypeCategory() == 14 && currDecl.fType.isIDType()) {
                        if (wildcardIDName != null) {
                            this.reportSchemaError("cvc-complex-type.5.1", new Object[]{element.rawname, currDecl.fName, wildcardIDName});
                        } else {
                            wildcardIDName = currDecl.fName;
                        }
                    }
lbl79:
                    // 5 sources

                    this.processOneAttribute(element, attributes, index, currDecl, currUse, attrPSVI);
                }
            }
            ++index;
        }
        if (!isSimple && attrGrp.fIDAttrName != null && wildcardIDName != null) {
            this.reportSchemaError("cvc-complex-type.5.2", new Object[]{element.rawname, wildcardIDName, attrGrp.fIDAttrName});
        }
    }

    void processOneAttribute(QName element, XMLAttributes attributes, int index, XSAttributeDecl currDecl, XSAttributeUseImpl currUse, AttributePSVImpl attrPSVI) {
        String attrValue = attributes.getValue(index);
        this.fXSIErrorReporter.pushContext();
        XSSimpleType attDV = currDecl.fType;
        Object actualValue = null;
        try {
            actualValue = attDV.validate(attrValue, (ValidationContext)this.fValidationState, this.fValidatedInfo);
            if (this.fNormalizeData) {
                attributes.setValue(index, this.fValidatedInfo.normalizedValue);
            }
            if (attributes instanceof XMLAttributesImpl) {
                XMLAttributesImpl attrs = (XMLAttributesImpl)attributes;
                boolean schemaId = this.fValidatedInfo.memberType != null ? this.fValidatedInfo.memberType.isIDType() : attDV.isIDType();
                attrs.setSchemaId(index, schemaId);
            }
            if (attDV.getVariety() == 1 && attDV.getPrimitiveKind() == 19) {
                QName qName = (QName)actualValue;
                SchemaGrammar grammar = this.fGrammarBucket.getGrammar(qName.uri);
                if (grammar != null) {
                    this.fNotation = grammar.getGlobalNotationDecl(qName.localpart);
                }
            }
        }
        catch (InvalidDatatypeValueException idve) {
            this.reportSchemaError(idve.getKey(), idve.getArgs());
            this.reportSchemaError("cvc-attribute.3", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
        }
        if (actualValue != null && currDecl.getConstraintType() == 2 && !actualValue.equals(currDecl.fDefault.actualValue)) {
            this.reportSchemaError("cvc-attribute.4", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
        }
        if (actualValue != null && currUse != null && currUse.fConstraintType == 2 && !actualValue.equals(currUse.fDefault.actualValue)) {
            this.reportSchemaError("cvc-complex-type.3.1", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
        }
        if (this.fAugPSVI) {
            attrPSVI.fDeclaration = currDecl;
            if (currDecl != null && currDecl.fDefault != null) {
                attrPSVI.fSchemaDefault = currDecl.fDefault.toString();
            }
            attrPSVI.fTypeDecl = attDV;
            attrPSVI.fMemberType = this.fValidatedInfo.memberType;
            attrPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
            attrPSVI.fValidationAttempted = (short)2;
            String[] errors = this.fXSIErrorReporter.mergeContext();
            attrPSVI.fErrorCodes = errors;
            attrPSVI.fValidity = (short)(errors == null ? 2 : 1);
        }
    }

    void addDefaultAttributes(QName element, XMLAttributes attributes, XSAttributeGroupDecl attrGrp) {
        XSObjectList attrUses = attrGrp.getAttributeUses();
        int useCount = attrUses.getLength();
        int i = 0;
        while (i < useCount) {
            boolean isSpecified;
            XSAttributeUseImpl currUse = (XSAttributeUseImpl)attrUses.getItem(i);
            XSAttributeDecl currDecl = currUse.fAttrDecl;
            short constType = currUse.fConstraintType;
            ValidatedInfo defaultValue = currUse.fDefault;
            if (constType == 0) {
                constType = currDecl.getConstraintType();
                defaultValue = currDecl.fDefault;
            }
            boolean bl = isSpecified = attributes.getValue(currDecl.fTargetNamespace, currDecl.fName) != null;
            if (currUse.fUse == 1 && !isSpecified) {
                this.reportSchemaError("cvc-complex-type.4", new Object[]{element.rawname, currDecl.fName});
            }
            if (!isSpecified && constType != 0) {
                QName attName = new QName(null, currDecl.fName, currDecl.fName, currDecl.fTargetNamespace);
                String normalized = defaultValue != null ? defaultValue.stringValue() : "";
                int attrIndex = attributes.addAttribute(attName, "CDATA", normalized);
                if (attributes instanceof XMLAttributesImpl) {
                    XMLAttributesImpl attrs = (XMLAttributesImpl)attributes;
                    boolean schemaId = defaultValue != null && defaultValue.memberType != null ? defaultValue.memberType.isIDType() : currDecl.fType.isIDType();
                    attrs.setSchemaId(attrIndex, schemaId);
                }
                if (this.fAugPSVI) {
                    Augmentations augs = attributes.getAugmentations(attrIndex);
                    AttributePSVImpl attrPSVI = new AttributePSVImpl();
                    augs.putItem("ATTRIBUTE_PSVI", attrPSVI);
                    attrPSVI.fDeclaration = currDecl;
                    attrPSVI.fTypeDecl = currDecl.fType;
                    attrPSVI.fMemberType = defaultValue.memberType;
                    attrPSVI.fNormalizedValue = normalized;
                    attrPSVI.fSchemaDefault = normalized;
                    attrPSVI.fValidationContext = this.fValidationRoot;
                    attrPSVI.fValidity = (short)2;
                    attrPSVI.fValidationAttempted = (short)2;
                    attrPSVI.fSpecified = true;
                }
            }
            ++i;
        }
    }

    void processElementContent(QName element) {
        int bufLen;
        if (!(this.fCurrentElemDecl == null || this.fCurrentElemDecl.fDefault == null || this.fSawText || this.fSubElement || this.fNil)) {
            String strv = this.fCurrentElemDecl.fDefault.stringValue();
            bufLen = strv.length();
            if (this.fNormalizedStr.ch == null || this.fNormalizedStr.ch.length < bufLen) {
                this.fNormalizedStr.ch = new char[bufLen];
            }
            strv.getChars(0, bufLen, this.fNormalizedStr.ch, 0);
            this.fNormalizedStr.offset = 0;
            this.fNormalizedStr.length = bufLen;
            this.fDefaultValue = this.fNormalizedStr;
        }
        this.fValidatedInfo.normalizedValue = null;
        if (this.fNil && (this.fSubElement || this.fSawText)) {
            this.reportSchemaError("cvc-elt.3.2.1", new Object[]{element.rawname, SchemaSymbols.URI_XSI + "," + SchemaSymbols.XSI_NIL});
        }
        this.fValidatedInfo.reset();
        if (!(this.fCurrentElemDecl == null || this.fCurrentElemDecl.getConstraintType() == 0 || this.fSubElement || this.fSawText || this.fNil)) {
            if (this.fCurrentType != this.fCurrentElemDecl.fType && XSConstraints.ElementDefaultValidImmediate(this.fCurrentType, this.fCurrentElemDecl.fDefault.stringValue(), this.fState4XsiType, null) == null) {
                this.reportSchemaError("cvc-elt.5.1.1", new Object[]{element.rawname, this.fCurrentType.getName(), this.fCurrentElemDecl.fDefault.stringValue()});
            }
            this.elementLocallyValidType(element, this.fCurrentElemDecl.fDefault.stringValue());
        } else {
            Object actualValue = this.elementLocallyValidType(element, this.fBuffer);
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2 && !this.fNil) {
                String content = this.fBuffer.toString();
                if (this.fSubElement) {
                    this.reportSchemaError("cvc-elt.5.2.2.1", new Object[]{element.rawname});
                }
                if (this.fCurrentType.getTypeCategory() == 13) {
                    XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
                    if (ctype.fContentType == 3) {
                        if (!this.fCurrentElemDecl.fDefault.normalizedValue.equals(content)) {
                            this.reportSchemaError("cvc-elt.5.2.2.2.1", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.normalizedValue});
                        }
                    } else if (ctype.fContentType == 1 && actualValue != null && !actualValue.equals(this.fCurrentElemDecl.fDefault.actualValue)) {
                        this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.stringValue()});
                    }
                } else if (this.fCurrentType.getTypeCategory() == 14) {
                    XSSimpleType sType = (XSSimpleType)this.fCurrentType;
                    if (actualValue != null && !actualValue.equals(this.fCurrentElemDecl.fDefault.actualValue)) {
                        this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.stringValue()});
                    }
                }
            }
        }
        if (this.fDefaultValue == null && this.fNormalizeData && this.fDocumentHandler != null && this.fUnionType) {
            String content = this.fValidatedInfo.normalizedValue;
            if (content == null) {
                content = this.fBuffer.toString();
            }
            bufLen = content.length();
            if (this.fNormalizedStr.ch == null || this.fNormalizedStr.ch.length < bufLen) {
                this.fNormalizedStr.ch = new char[bufLen];
            }
            content.getChars(0, bufLen, this.fNormalizedStr.ch, 0);
            this.fNormalizedStr.offset = 0;
            this.fNormalizedStr.length = bufLen;
            this.fDocumentHandler.characters(this.fNormalizedStr, null);
        }
    }

    Object elementLocallyValidType(QName element, Object textContent) {
        if (this.fCurrentType == null) {
            return null;
        }
        Object retValue = null;
        if (this.fCurrentType.getTypeCategory() == 14) {
            if (this.fSubElement) {
                this.reportSchemaError("cvc-type.3.1.2", new Object[]{element.rawname});
            }
            if (!this.fNil) {
                XSSimpleType dv = (XSSimpleType)this.fCurrentType;
                try {
                    if (!this.fNormalizeData || this.fUnionType) {
                        this.fValidationState.setNormalizationRequired(true);
                    }
                    retValue = dv.validate(textContent, (ValidationContext)this.fValidationState, this.fValidatedInfo);
                }
                catch (InvalidDatatypeValueException e) {
                    this.reportSchemaError(e.getKey(), e.getArgs());
                    this.reportSchemaError("cvc-type.3.1.3", new Object[]{element.rawname, textContent});
                }
            }
        } else {
            retValue = this.elementLocallyValidComplexType(element, textContent);
        }
        return retValue;
    }

    Object elementLocallyValidComplexType(QName element, Object textContent) {
        Object actualValue = null;
        XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
        if (!this.fNil) {
            if (ctype.fContentType == 0 && (this.fSubElement || this.fSawText || this.fSawChildren)) {
                this.reportSchemaError("cvc-complex-type.2.1", new Object[]{element.rawname});
            } else if (ctype.fContentType == 1) {
                if (this.fSubElement) {
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{element.rawname});
                }
                XSSimpleType dv = ctype.fXSSimpleType;
                try {
                    if (!this.fNormalizeData || this.fUnionType) {
                        this.fValidationState.setNormalizationRequired(true);
                    }
                    actualValue = dv.validate(textContent, (ValidationContext)this.fValidationState, this.fValidatedInfo);
                }
                catch (InvalidDatatypeValueException e) {
                    this.reportSchemaError(e.getKey(), e.getArgs());
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{element.rawname});
                }
            } else if (ctype.fContentType == 2 && this.fSawCharacters) {
                this.reportSchemaError("cvc-complex-type.2.3", new Object[]{element.rawname});
            }
            if (!(ctype.fContentType != 2 && ctype.fContentType != 3 || this.fCurrCMState[0] < 0 || this.fCurrentCM.endContentModel(this.fCurrCMState))) {
                this.reportSchemaError("cvc-complex-type.2.4.b", new Object[]{element.rawname, ((XSParticleDecl)ctype.getParticle()).toString()});
            }
        }
        return actualValue;
    }

    void reportSchemaError(String key, Object[] arguments) {
        if (this.fDoValidation) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, arguments, (short)1);
        }
    }

    protected class LocalIDKey {
        private IdentityConstraint fId;
        private int fDepth;

        public LocalIDKey(IdentityConstraint id, int depth) {
            this.fId = id;
            this.fDepth = depth;
        }

        public int hashCode() {
            return this.fId.hashCode() + this.fDepth;
        }

        public boolean equals(Object localIDKey) {
            if (localIDKey instanceof LocalIDKey) {
                LocalIDKey lIDKey = (LocalIDKey)localIDKey;
                return lIDKey.fId == this.fId && lIDKey.fDepth == this.fDepth;
            }
            return false;
        }
    }

    static final class OrderedHashtable
    implements Cloneable {
        private int fSize;
        private Entry[] fEntries = null;

        OrderedHashtable() {
        }

        public int size() {
            return this.fSize;
        }

        public void put(Field key, IDValue value) {
            int index = this.indexOf(key);
            if (index == -1) {
                this.ensureCapacity(this.fSize);
                index = this.fSize++;
                this.fEntries[index].key = key;
            }
            this.fEntries[index].value = value;
        }

        public IDValue get(Field key) {
            return this.fEntries[this.indexOf((Field)key)].value;
        }

        public int indexOf(Field key) {
            int i = 0;
            while (i < this.fSize) {
                if (this.fEntries[i].key == key) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Field keyAt(int index) {
            return this.fEntries[index].key;
        }

        public IDValue valueAt(int index) {
            return this.fEntries[index].value;
        }

        public void clear() {
            this.fSize = 0;
        }

        private void ensureCapacity(int size) {
            int osize = -1;
            int nsize = -1;
            if (this.fEntries == null) {
                osize = 0;
                nsize = 2;
                this.fEntries = new Entry[nsize];
            } else if (this.fEntries.length <= size) {
                osize = this.fEntries.length;
                nsize = 2 * osize;
                Entry[] array = new Entry[nsize];
                System.arraycopy(this.fEntries, 0, array, 0, osize);
                this.fEntries = array;
            }
            int i = osize;
            while (i < nsize) {
                this.fEntries[i] = new Entry();
                ++i;
            }
        }

        public Object clone() {
            OrderedHashtable hashtable = new OrderedHashtable();
            int i = 0;
            while (i < this.fSize) {
                hashtable.put(this.fEntries[i].key, this.fEntries[i].value);
                ++i;
            }
            return hashtable;
        }

        public String toString() {
            if (this.fSize == 0) {
                return "[]";
            }
            StringBuffer str = new StringBuffer();
            str.append('[');
            int i = 0;
            while (i < this.fSize) {
                if (i > 0) {
                    str.append(',');
                }
                str.append('{');
                str.append(this.fEntries[i].key);
                str.append(',');
                str.append(this.fEntries[i].value);
                str.append('}');
                ++i;
            }
            str.append(']');
            return str.toString();
        }

        public static final class Entry {
            public Field key;
            public IDValue value;
        }
    }

    protected class ValueStoreCache {
        protected final Vector fValueStores = new Vector();
        protected final Hashtable fIdentityConstraint2ValueStoreMap = new Hashtable();
        protected final Stack fGlobalMapStack = new Stack();
        protected final Hashtable fGlobalIDConstraintMap = new Hashtable();

        public void startDocument() throws XNIException {
            this.fValueStores.removeAllElements();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            if (this.fGlobalIDConstraintMap.size() > 0) {
                this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            } else {
                this.fGlobalMapStack.push(null);
            }
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            Hashtable oldMap = (Hashtable)this.fGlobalMapStack.pop();
            if (oldMap == null) {
                return;
            }
            Enumeration keys = oldMap.keys();
            while (keys.hasMoreElements()) {
                IdentityConstraint id = (IdentityConstraint)keys.nextElement();
                ValueStoreBase oldVal = (ValueStoreBase)oldMap.get(id);
                if (oldVal == null) continue;
                ValueStoreBase currVal = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
                if (currVal == null) {
                    this.fGlobalIDConstraintMap.put(id, oldVal);
                    continue;
                }
                currVal.append(oldVal);
            }
        }

        public void initValueStoresFor(XSElementDecl eDecl) {
            IdentityConstraint[] icArray = eDecl.fIDConstraints;
            int icCount = eDecl.fIDCPos;
            int i = 0;
            while (i < icCount) {
                switch (icArray[i].getCategory()) {
                    case 3: {
                        UniqueOrKey unique = (UniqueOrKey)icArray[i];
                        LocalIDKey toHash = new LocalIDKey(unique, XMLSchemaValidator.this.fElementDepth);
                        UniqueValueStore uniqueValueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(toHash);
                        if (uniqueValueStore == null) {
                            uniqueValueStore = new UniqueValueStore(unique);
                            this.fIdentityConstraint2ValueStoreMap.put(toHash, uniqueValueStore);
                        } else {
                            uniqueValueStore.clear();
                        }
                        this.fValueStores.addElement(uniqueValueStore);
                        break;
                    }
                    case 1: {
                        UniqueOrKey key = (UniqueOrKey)icArray[i];
                        LocalIDKey toHash = new LocalIDKey(key, XMLSchemaValidator.this.fElementDepth);
                        KeyValueStore keyValueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(toHash);
                        if (keyValueStore == null) {
                            keyValueStore = new KeyValueStore(key);
                            this.fIdentityConstraint2ValueStoreMap.put(toHash, keyValueStore);
                        } else {
                            keyValueStore.clear();
                        }
                        this.fValueStores.addElement(keyValueStore);
                        break;
                    }
                    case 2: {
                        KeyRef keyRef = (KeyRef)icArray[i];
                        LocalIDKey toHash = new LocalIDKey(keyRef, XMLSchemaValidator.this.fElementDepth);
                        KeyRefValueStore keyRefValueStore = (KeyRefValueStore)this.fIdentityConstraint2ValueStoreMap.get(toHash);
                        if (keyRefValueStore == null) {
                            keyRefValueStore = new KeyRefValueStore(keyRef, null);
                            this.fIdentityConstraint2ValueStoreMap.put(toHash, keyRefValueStore);
                        } else {
                            keyRefValueStore.clear();
                        }
                        this.fValueStores.addElement(keyRefValueStore);
                    }
                }
                ++i;
            }
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint id, int initialDepth) {
            ValueStoreBase vb = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(new LocalIDKey(id, initialDepth));
            return vb;
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint id) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
        }

        public void transplant(IdentityConstraint id, int initialDepth) {
            ValueStoreBase newVals = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(new LocalIDKey(id, initialDepth));
            if (id.getCategory() == 2) {
                return;
            }
            ValueStoreBase currVals = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
            if (currVals != null) {
                currVals.append(newVals);
                this.fGlobalIDConstraintMap.put(id, currVals);
            } else {
                this.fGlobalIDConstraintMap.put(id, newVals);
            }
        }

        public void endDocument() {
            int count = this.fValueStores.size();
            int i = 0;
            while (i < count) {
                ValueStoreBase valueStore = (ValueStoreBase)this.fValueStores.elementAt(i);
                valueStore.endDocument();
                ++i;
            }
        }

        public String toString() {
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                return s.substring(index1 + 1);
            }
            int index2 = s.lastIndexOf(46);
            if (index2 != -1) {
                return s.substring(index2 + 1);
            }
            return s;
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore) {
            super(keyRef);
            this.fKeyValueStore = keyValueStore;
        }

        public void endDocumentFragment() throws XNIException {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)XMLSchemaValidator.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                String code = "KeyRefOutOfScope";
                String value = this.fIdentityConstraint.toString();
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value});
                return;
            }
            int count = this.fValueTuples.size();
            int i = 0;
            while (i < count) {
                OrderedHashtable values = (OrderedHashtable)this.fValueTuples.elementAt(i);
                if (!this.fKeyValueStore.contains(values)) {
                    String code = "KeyNotFound";
                    String value = this.toString(values);
                    String element = this.fIdentityConstraint.getElementName();
                    String name = this.fIdentityConstraint.getName();
                    XMLSchemaValidator.this.reportSchemaError(code, new Object[]{name, value, element});
                }
                ++i;
            }
        }

        public void endDocument() throws XNIException {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(UniqueOrKey key) {
            super(key);
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
            String code = "DuplicateKey";
            String value = this.toString(tuple);
            String ename = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value, ename});
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(UniqueOrKey unique) {
            super(unique);
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
            String code = "DuplicateUnique";
            String value = this.toString(tuple);
            String ename = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value, ename});
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IDValue NOT_AN_IDVALUE = new IDValue("\uffff", null);
        protected IdentityConstraint fIdentityConstraint;
        protected final OrderedHashtable fValues = new OrderedHashtable();
        protected int fValuesCount;
        protected final Vector fValueTuples = new Vector();

        protected ValueStoreBase(IdentityConstraint identityConstraint) {
            this.fIdentityConstraint = identityConstraint;
        }

        public void clear() {
            this.fValuesCount = 0;
            this.fValues.clear();
            this.fValueTuples.removeAllElements();
        }

        public void append(ValueStoreBase newVal) {
            int i = 0;
            while (i < newVal.fValueTuples.size()) {
                OrderedHashtable o = (OrderedHashtable)newVal.fValueTuples.elementAt(i);
                if (!this.contains(o)) {
                    this.fValueTuples.addElement(o);
                }
                ++i;
            }
        }

        public void startValueScope() throws XNIException {
            this.fValuesCount = 0;
            int count = this.fIdentityConstraint.getFieldCount();
            int i = 0;
            while (i < count) {
                this.fValues.put(this.fIdentityConstraint.getFieldAt(i), this.NOT_AN_IDVALUE);
                ++i;
            }
        }

        public void endValueScope() throws XNIException {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getCategory() == 1) {
                    String code = "AbsentKeyValue";
                    String eName = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(code, new Object[]{eName});
                }
                return;
            }
            if (this.fValuesCount != this.fIdentityConstraint.getFieldCount()) {
                switch (this.fIdentityConstraint.getCategory()) {
                    case 3: {
                        String code = "UniqueNotEnoughValues";
                        String ename = this.fIdentityConstraint.getElementName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename});
                        break;
                    }
                    case 1: {
                        String code = "KeyNotEnoughValues";
                        UniqueOrKey key = (UniqueOrKey)this.fIdentityConstraint;
                        String ename = this.fIdentityConstraint.getElementName();
                        String kname = key.getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename, kname});
                        break;
                    }
                    case 2: {
                        String code = "KeyRefNotEnoughValues";
                        KeyRef keyref = (KeyRef)this.fIdentityConstraint;
                        String ename = this.fIdentityConstraint.getElementName();
                        String kname = keyref.getKey().getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename, kname});
                        break;
                    }
                }
                return;
            }
        }

        public void endDocumentFragment() throws XNIException {
        }

        public void endDocument() throws XNIException {
        }

        public void reportError(String key, Object[] args) {
            XMLSchemaValidator.this.reportSchemaError(key, args);
        }

        public void addValue(Field field, IDValue value) {
            int index;
            if (!field.mayMatch()) {
                String code = "FieldMultipleMatch";
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{field.toString()});
            }
            if ((index = this.fValues.indexOf(field)) == -1) {
                String code = "UnknownField";
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{field.toString()});
                return;
            }
            IDValue storedValue = this.fValues.valueAt(index);
            if (storedValue.isDuplicateOf(this.NOT_AN_IDVALUE)) {
                ++this.fValuesCount;
            }
            this.fValues.put(field, value);
            if (this.fValuesCount == this.fValues.size()) {
                if (this.contains(this.fValues)) {
                    this.duplicateValue(this.fValues);
                }
                OrderedHashtable values = (OrderedHashtable)this.fValues.clone();
                this.fValueTuples.addElement(values);
            }
        }

        public boolean contains(OrderedHashtable tuple) {
            int tcount = tuple.size();
            int count = this.fValueTuples.size();
            int i = 0;
            while (i < count) {
                block3: {
                    OrderedHashtable vtuple = (OrderedHashtable)this.fValueTuples.elementAt(i);
                    int j = 0;
                    while (j < tcount) {
                        IDValue value2;
                        IDValue value1 = vtuple.valueAt(j);
                        if (value1.isDuplicateOf(value2 = tuple.valueAt(j))) {
                            ++j;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
        }

        protected String toString(OrderedHashtable tuple) {
            int size = tuple.size();
            if (size == 0) {
                return "";
            }
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(tuple.valueAt(i));
                ++i;
            }
            return str.toString();
        }

        public String toString() {
            int index2;
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                s = s.substring(index1 + 1);
            }
            if ((index2 = s.lastIndexOf(46)) != -1) {
                s = s.substring(index2 + 1);
            }
            return s + '[' + this.fIdentityConstraint + ']';
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            int i = 0;
            while (i < this.fMatchersCount) {
                this.fMatchers[i] = null;
                ++i;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher matcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = matcher;
        }

        public XPathMatcher getMatcherAt(int index) {
            return this.fMatchers[index];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] array = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, array, 0, this.fMatchers.length);
                this.fMatchers = array;
            }
        }
    }

    protected final class XSIErrorReporter {
        XMLErrorReporter fErrorReporter;
        Vector fErrors = new Vector(8, 8);
        int[] fContext = new int[8];
        int fContextCount;

        protected XSIErrorReporter() {
        }

        public void reset(XMLErrorReporter errorReporter) {
            this.fErrorReporter = errorReporter;
            this.fErrors.removeAllElements();
            this.fContextCount = 0;
        }

        public void pushContext() {
            if (!XMLSchemaValidator.this.fAugPSVI) {
                return;
            }
            if (this.fContextCount == this.fContext.length) {
                int newSize = this.fContextCount + 8;
                int[] newArray = new int[newSize];
                System.arraycopy(this.fContext, 0, newArray, 0, this.fContextCount);
                this.fContext = newArray;
            }
            this.fContext[this.fContextCount++] = this.fErrors.size();
        }

        public String[] popContext() {
            if (!XMLSchemaValidator.this.fAugPSVI) {
                return null;
            }
            int contextPos = this.fContext[--this.fContextCount];
            int size = this.fErrors.size() - contextPos;
            if (size == 0) {
                return null;
            }
            String[] errors = new String[size];
            int i = 0;
            while (i < size) {
                errors[i] = (String)this.fErrors.elementAt(contextPos + i);
                ++i;
            }
            this.fErrors.setSize(contextPos);
            return errors;
        }

        public String[] mergeContext() {
            if (!XMLSchemaValidator.this.fAugPSVI) {
                return null;
            }
            int contextPos = this.fContext[--this.fContextCount];
            int size = this.fErrors.size() - contextPos;
            if (size == 0) {
                return null;
            }
            String[] errors = new String[size];
            int i = 0;
            while (i < size) {
                errors[i] = (String)this.fErrors.elementAt(contextPos + i);
                ++i;
            }
            return errors;
        }

        public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
            this.fErrorReporter.reportError(domain, key, arguments, severity);
            this.fErrors.addElement(key);
        }

        public void reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity) throws XNIException {
            this.fErrorReporter.reportError(location, domain, key, arguments, severity);
            this.fErrors.addElement(key);
        }
    }
}

