/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLDTDScannerImpl;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class XML11DTDScannerImpl
extends XMLDTDScannerImpl {
    private String[] fStrings = new String[3];
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();

    public XML11DTDScannerImpl() {
    }

    public XML11DTDScannerImpl(SymbolTable symbolTable, XMLErrorReporter errorReporter, XMLEntityManager entityManager) {
        super(symbolTable, errorReporter, entityManager);
    }

    protected boolean scanPubidLiteral(XMLString literal) throws IOException, XNIException {
        int quote = this.fEntityScanner.scanChar();
        if (quote != 39 && quote != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean skipSpace = true;
        boolean dataok = true;
        while (true) {
            int c;
            if ((c = this.fEntityScanner.scanChar()) == 32 || c == 10 || c == 13 || c == 133 || c == 8232) {
                if (skipSpace) continue;
                this.fStringBuffer.append(' ');
                skipSpace = true;
                continue;
            }
            if (c == quote) {
                if (skipSpace) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(c)) {
                this.fStringBuffer.append((char)c);
                skipSpace = false;
                continue;
            }
            if (c == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            dataok = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(c)});
        }
        literal.setValues(this.fStringBuffer);
        return dataok;
    }

    protected void normalizeWhitespace(XMLString value) {
        int end = value.offset + value.length;
        int i = value.offset;
        while (i < end) {
            char c = value.ch[i];
            if (XMLChar.isXML11Space(c)) {
                value.ch[i] = 32;
            }
            ++i;
        }
    }
}

