/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.lib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ProbeClassLoader
extends ClassLoader {
    String dir = System.getProperty("user.dir") + "/probes";

    public ProbeClassLoader(String dir) {
        this.dir = dir;
    }

    public ProbeClassLoader() {
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            Class<?> c = this.findSystemClass(name);
            return c;
        }
        catch (ClassNotFoundException e) {
            File fil = new File(this.dir + name + ".class");
            if (!fil.exists()) {
                throw new ClassNotFoundException(this.dir + name + ".class not found");
            }
            byte[] data = this.getClassData(fil);
            if (data == null) {
                throw new ClassNotFoundException(this.dir + name + ".class not found");
            }
            Class<?> c = this.defineClass(name, data, 0, data.length);
            if (c == null) {
                System.out.println("Failed to defineClass() from " + this.dir + name + ".class");
            }
            return c;
        }
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    private byte[] getClassData(File f) {
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

