/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.gui.wizards;

import com.securitycentric.metacoretex.Init;
import com.securitycentric.metacoretex.gui.wizards.ProbeTemplate;
import com.securitycentric.metacoretex.lib.ProbeToolz;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ProbeWizard
extends JFrame {
    private JLayeredPane layeredPane;
    private JButton backButton;
    private JButton finishButton;
    private JButton fwdButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JButton helpButton;
    public Vector panVect;
    Properties allProp;
    int pageIndex;
    File templateFile;
    String crazy = "\\\\\\\\n";

    public ProbeWizard(File templateFile) {
        this.templateFile = templateFile;
        this.preInit();
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.helpButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton = new JButton();
        this.fwdButton = new JButton();
        this.finishButton = new JButton();
        this.layeredPane = new JLayeredPane();
        this.setTitle("Probe Wizard");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ProbeWizard.this.exitForm(evt);
            }
        });
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProbeWizard.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.helpButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProbeWizard.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.backButton.setText("Back");
        this.backButton.setPreferredSize(new Dimension(75, 25));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProbeWizard.this.backButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.backButton);
        this.fwdButton.setText("Forward");
        this.fwdButton.setIconTextGap(0);
        this.fwdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProbeWizard.this.fwdButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.fwdButton);
        this.finishButton.setText("Finish");
        this.finishButton.setPreferredSize(new Dimension(75, 25));
        this.finishButton.setEnabled(false);
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProbeWizard.this.finishButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.finishButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.layeredPane, "Center");
        this.pack();
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        String help = ((ProbeTemplate)this.panVect.get(this.pageIndex)).getHelp();
        JOptionPane.showMessageDialog(this, help, "Help", 1);
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        if (!((ProbeTemplate)this.panVect.get(this.pageIndex)).checkProperties()) {
            return;
        }
        this.fillProperties();
        Pattern pat = Pattern.compile("PROBE_[A-Z_]*");
        Pattern cpat = Pattern.compile("CONFIG_[A-Z_]*");
        String newFileName = Init.config.get("probe.dir") + "/" + this.allProp.getProperty("PROBE_JAVA_NAME") + ".java";
        try {
            String line;
            if (this.allProp.containsKey("CONFIG_NAME")) {
                File confFile = new File(Init.config.get("conf.dir") + this.allProp.getProperty("CONFIG_NAME"));
                confFile.createNewFile();
                BufferedWriter cbw = new BufferedWriter(new FileWriter(confFile));
                if (this.allProp.containsKey("CONFIG_FILE")) {
                    String cfline = new String();
                    BufferedReader cbr = new BufferedReader(new FileReader(this.allProp.getProperty("CONFIG_FILE")));
                    while ((cfline = cbr.readLine()) != null) {
                        cbw.write(cfline + "\n");
                    }
                    cbr.close();
                } else if (this.allProp.containsKey("CONFIG_VALUE")) {
                    cbw.write(this.allProp.getProperty("CONFIG_VALUE"));
                }
                cbw.close();
            }
            BufferedReader br = new BufferedReader(new FileReader(this.templateFile));
            BufferedWriter bw = new BufferedWriter(new FileWriter(newFileName));
            while ((line = br.readLine()) != null) {
                line = this.propReplace(pat, line);
                line = this.propReplace(cpat, line);
                bw.write(line + "\n");
            }
            bw.close();
            br.close();
            this.setVisible(false);
            int reply = JOptionPane.showConfirmDialog(this, "Creation Successful!\nWould you like to compile your new probe?", "Probe Generator", 0);
            if (reply == 0) {
                ProbeToolz.compileProbe(new File(newFileName));
            }
        }
        catch (FileNotFoundException fe) {
            Init.doError("Probe Generator Error", fe);
        }
        catch (IOException ie) {
            Init.doError("Probe Generator Error", ie);
        }
        this.dispose();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        --this.pageIndex;
        this.layeredPane.moveToFront((Component)this.panVect.get(this.pageIndex));
        if (this.pageIndex == 0) {
            this.backButton.setEnabled(false);
        }
        this.fwdButton.setEnabled(true);
        this.finishButton.setEnabled(false);
    }

    private void fwdButtonActionPerformed(ActionEvent evt) {
        if (!((ProbeTemplate)this.panVect.get(this.pageIndex)).checkProperties()) {
            return;
        }
        ++this.pageIndex;
        this.layeredPane.moveToFront((Component)this.panVect.get(this.pageIndex));
        if (this.pageIndex + 1 >= this.panVect.size()) {
            this.fwdButton.setEnabled(false);
            this.finishButton.setEnabled(true);
        }
        this.backButton.setEnabled(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void preInit() {
        this.panVect = new Vector();
        this.allProp = new Properties();
    }

    public void postInit() {
        this.layeredPane.setPreferredSize(new Dimension(500, 400));
        this.pack();
        Init.centerWindow(this);
    }

    private String propReplace(Pattern ptrn, String str) {
        String key;
        Matcher mat = ptrn.matcher(str);
        if (mat.find() && this.allProp.containsKey(key = mat.group())) {
            return str.replaceAll(key, this.allProp.getProperty(key));
        }
        return str;
    }

    public void addPanel(JPanel pan) {
        this.panVect.add(pan);
        this.layeredPane.add((Component)pan, new Integer(10));
        this.layeredPane.validate();
    }

    private void fillProperties() {
        Iterator i = this.panVect.iterator();
        while (i.hasNext()) {
            ProbeTemplate tmp = (ProbeTemplate)i.next();
            Properties tmpPrp = tmp.getProperties();
            Enumeration<?> e = tmpPrp.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String prop = key.startsWith("PROBE_") ? tmpPrp.getProperty(key).replaceAll("\n", this.crazy) : tmpPrp.getProperty(key);
                this.allProp.setProperty(key, prop);
            }
        }
    }
}

