/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex;

import com.securitycentric.metacoretex.Init;
import com.securitycentric.metacoretex.gui.UpdateStatus;
import com.securitycentric.metacoretex.lib.UpdateException;
import com.securitycentric.metacoretex.lib.UpdateToolz;
import com.securitycentric.metacoretex.xml.update.MCTXUpdate;

public class Updater
extends Thread {
    private int updateType = 0;
    private UpdateStatus upStat = null;
    public static final int UPDATE_PROBES = 1;
    public static final int UPDATE_CONFIG = 2;
    public static final int UPDATE_JARS = 3;
    public static final int UPDATE_ALL = 4;

    public Updater() {
        this.updateType = 4;
    }

    public Updater(int type) {
        this.updateType = type;
    }

    public void run() {
        MCTXUpdate upDate;
        int fileCount = 0;
        this.updateStatus("Getting Update XML", 20);
        try {
            upDate = UpdateToolz.getUpdate();
        }
        catch (UpdateException e) {
            Init.doError("Update Error while getting update XML", e);
            this.closeStatus();
            return;
        }
        this.updateStatus("Processing Local Options", 30);
        switch (this.updateType) {
            case 1: {
                UpdateToolz.onlyProbes(upDate);
                break;
            }
            case 2: {
                UpdateToolz.onlyConfigFiles(upDate);
                break;
            }
            case 3: {
                UpdateToolz.onlyJars(upDate);
                break;
            }
            case 4: {
                break;
            }
            default: {
                Init.doError("Updater Error", new Exception("Unknown Update Type"));
                this.closeStatus();
                return;
            }
        }
        this.updateStatus("Processing Current Versions", 50);
        UpdateToolz.removeDuplicates(upDate);
        this.updateStatus("Getting Update Files", 80);
        try {
            fileCount = UpdateToolz.doUpdate(upDate);
        }
        catch (UpdateException e) {
            Init.doError("Updater Error", e);
            this.closeStatus();
            return;
        }
        this.updateStatus("Complete", 100);
        Init.doMessage("Update Complete", "Update is complete. " + fileCount + " files updated.\n" + "If any updated files were JARs (not probes),\n" + "you should probably restart Metacoretex");
        this.closeStatus();
    }

    private void closeStatus() {
        if (this.upStat != null) {
            this.upStat.setVisible(false);
            this.upStat.dispose();
        }
    }

    private void updateStatus(String mess, int complete) {
        if (Init.console) {
            System.out.println(mess);
        } else {
            if (this.upStat == null) {
                this.upStat = new UpdateStatus();
                Init.centerWindow(this.upStat);
                this.upStat.show();
            }
            this.upStat.update(mess, complete);
        }
    }
}

