/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oci.OracleOCIConnection;

public class OracleDriver
implements Driver {
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    static final String oracle_string = "oracle";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    static final String server_string = "server";
    static final String access_string = "access";
    public static final String protocol_string = "protocol";
    public static final String dll_string = "dll";
    public static final String logon_as_internal_str = "internal_logon";
    static final String prefetch_string = "prefetch";
    static final String row_prefetch_string = "rowPrefetch";
    static final String default_row_prefetch_string = "defaultRowPrefetch";
    static final String batch_string = "batch";
    static final String execute_batch_string = "executeBatch";
    static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String dms_parent_name_string = "DMSName";
    public static final String dms_parent_type_string = "DMSType";
    public static final String dms_stmt_metrics_string = "oracle.jdbc.DMSStatementMetrics";
    static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "oracle.jdbc.V8Compatible";
    static final String remarks_string = "remarks";
    static final String report_remarks_string = "remarksReporting";
    private static final String synonyms_string = "synonyms";
    private static final String include_synonyms_string = "includeSynonyms";
    private static final String restrict_getTables_string = "restrictGetTables";
    private static final String fixed_string_string = "fixedString";
    private static final int ACCEPTS_URL_GEN_ERROR = 1;
    private static final int ACCEPTS_URL_ORACLE_ERROR = 2;
    private static final int ACCEPTS_URL_SUCCESS = 3;
    private static final String DRIVER_ULTRA = "ultra";
    private static Properties m_driverAccess = new Properties();
    protected static Connection m_defaultConn;
    private static OracleDriver m_defaultDriver;

    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        Object object;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        int n;
        if (string.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String string8 = "jdbc:oracle:kprb";
            int n2 = string.length();
            string = n2 > 23 ? string8.concat(string.substring(23, string.length())) : string8.concat(":");
            string8 = null;
        }
        if ((n = this.oracleAcceptsURL(string)) == 1) {
            return null;
        }
        if (n == 2) {
            DBError.throwSqlException(67);
            return null;
        }
        Hashtable hashtable = this.parseUrl(string);
        if (hashtable == null) {
            return null;
        }
        String string9 = properties.getProperty(user_string);
        String string10 = properties.getProperty(password_string);
        String string11 = properties.getProperty(database_string);
        if (string11 == null) {
            string11 = properties.getProperty(server_string);
        }
        if (string9 == null) {
            string9 = (String)hashtable.get(user_string);
        }
        string9 = this.parseLoginOption(string9, properties);
        if (string10 == null) {
            string10 = (String)hashtable.get(password_string);
        }
        if (string11 == null) {
            string11 = (String)hashtable.get(database_string);
        }
        String string12 = (String)hashtable.get(protocol_string);
        properties.put(protocol_string, string12);
        if (string12 == null) {
            DBError.throwSqlException(40, "Protocol is not specified in URL");
            return null;
        }
        String string13 = properties.getProperty(dll_string);
        if (string13 == null) {
            properties.put(dll_string, "ocijdbc9");
        }
        if ((string7 = properties.getProperty(prefetch_string)) == null) {
            string7 = properties.getProperty(row_prefetch_string);
        }
        if (string7 == null) {
            string7 = properties.getProperty(default_row_prefetch_string);
        }
        if (string7 != null && Integer.parseInt(string7) <= 0) {
            string7 = null;
        }
        if ((string6 = properties.getProperty(batch_string)) == null) {
            string6 = properties.getProperty(execute_batch_string);
        }
        if (string6 == null) {
            string6 = properties.getProperty(default_execute_batch_string);
        }
        if (string6 != null && Integer.parseInt(string6) <= 0) {
            string6 = null;
        }
        if ((string5 = properties.getProperty(remarks_string)) == null) {
            string5 = properties.getProperty(report_remarks_string);
        }
        if ((string4 = properties.getProperty(synonyms_string)) == null) {
            string4 = properties.getProperty(include_synonyms_string);
        }
        String string14 = properties.getProperty(restrict_getTables_string);
        String string15 = properties.getProperty(fixed_string_string);
        String string16 = properties.getProperty("dataSizeUnits");
        String string17 = properties.getProperty(accumulate_batch_result);
        if (string17 == null) {
            string17 = "true";
        }
        if ((string3 = properties.getProperty(v8compatible_string)) == null) {
            string3 = "false";
        }
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof OracleDriver) break;
        }
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof OracleDriver)) continue;
            DriverManager.deregisterDriver((Driver)object);
        }
        object = this.getConnectionInstance(string12, string, string9, string10, string11, properties);
        if (string7 != null) {
            ((OracleConnection)object).setDefaultRowPrefetch(Integer.parseInt(string7));
        }
        if (string6 != null) {
            ((OracleConnection)object).setDefaultExecuteBatch(Integer.parseInt(string6));
        }
        if (string5 != null) {
            ((OracleConnection)object).setRemarksReporting(string5.equalsIgnoreCase("true"));
        }
        if (string4 != null) {
            ((OracleConnection)object).setIncludeSynonyms(string4.equalsIgnoreCase("true"));
        }
        if (string14 != null) {
            ((OracleConnection)object).setRestrictGetTables(string14.equalsIgnoreCase("true"));
        }
        if (string15 != null) {
            ((OracleConnection)object).setDefaultFixedString(string15.equalsIgnoreCase("true"));
        }
        if (string16 != null) {
            ((OracleConnection)object).setDataSizeUnits(string16);
        }
        ((OracleConnection)object).setAccumulateBatchResult(string17.equalsIgnoreCase("true"));
        ((OracleConnection)object).m_v8compatible = string3.equalsIgnoreCase("true");
        String string18 = System.getProperty(j2ee_compliance);
        if (string18 == null) {
            string2 = properties.getProperty(j2ee_compliance);
            if (string2 == null) {
                string2 = "false";
            }
        } else {
            string2 = string18;
        }
        ((OracleConnection)object).setJ2EE13Compliant(string2.equalsIgnoreCase("true"));
        hashtable = null;
        return object;
    }

    private Connection getConnectionInstance(String string, String string2, String string3, String string4, String string5, Properties properties) throws SQLException {
        Connection connection = null;
        if (string.compareTo(DRIVER_ULTRA) == 0) {
            try {
                Class<?>[] classArray = null;
                Object[] objectArray = new Object[]{string, string2, string3, string4, string5, properties};
                Class<?> clazz = Class.forName("oracle.jdbc.ultra.client.Driver");
                Method[] methodArray = clazz.getMethods();
                int n = 0;
                while (n < methodArray.length) {
                    if (methodArray[n].getName().equals("getConnection")) {
                        classArray = methodArray[n].getParameterTypes();
                        break;
                    }
                    ++n;
                }
                Method method = clazz.getMethod("getConnection", classArray);
                connection = (Connection)method.invoke(clazz.newInstance(), objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DBError.throwSqlException(1);
            }
        } else {
            String string6 = null;
            string6 = string.equals("thin") && OracleDriver.getSystemProperty("oracle.jserver.version") != null ? "thin-server" : ((string.equals("oci8") || string.equals("oci")) && OracleDriver.getSystemProperty("oracle.jserver.version") != null ? "oci-server" : string);
            String string7 = (String)m_driverAccess.get(string6);
            if (string7 == null) {
                DBError.throwSqlException(67, "Invalid protocol " + string);
            }
            DBAccess dBAccess = null;
            try {
                dBAccess = (DBAccess)Class.forName(string7).newInstance();
            }
            catch (Exception exception) {
                return null;
            }
            if (properties.getProperty("is_connection_pooling") == "true") {
                properties.put(database_string, string5 == null ? "" : string5);
                connection = new OracleOCIConnection(dBAccess, string2, string3, string4, string5, properties);
            } else {
                connection = new OracleConnection(dBAccess, string2, string3, string4, string5, properties);
            }
        }
        return connection;
    }

    public Connection defaultConnection() throws SQLException {
        if (m_defaultConn == null || m_defaultConn.isClosed()) {
            m_defaultConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return m_defaultConn;
    }

    private int oracleAcceptsURL(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return 1;
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1) {
            return 1;
        }
        if (!string.regionMatches(true, n + 1, oracle_string, 0, n2 - (n + 1))) {
            return 1;
        }
        int n3 = string.indexOf(58, n2 + 1);
        if (n3 == -1) {
            return 2;
        }
        String string2 = string.substring(n2 + 1, n3);
        if (string2.equals("oci8") || string2.equals("oci") || string2.equals("thin") || string2.equals("kprb") || string2.equals(DRIVER_ULTRA)) {
            return 3;
        }
        return 2;
    }

    public boolean acceptsURL(String string) {
        int n = this.oracleAcceptsURL(string);
        return n == 3;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private String parseLoginOption(String string, Properties properties) {
        int n = 0;
        String string2 = null;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        String string3 = string.toLowerCase();
        n = string3.lastIndexOf(" as ");
        if (n == -1 || n < string3.lastIndexOf("\"")) {
            return string;
        }
        string2 = string.substring(0, n);
        n += 4;
        while (n < n2 && string3.charAt(n) == ' ') {
            ++n;
        }
        if (n == n2) {
            return string;
        }
        String string4 = string3.substring(n).trim();
        if (string4.length() > 0) {
            properties.put(logon_as_internal_str, string4);
        }
        return string2;
    }

    private Hashtable parseUrl(String string) throws SQLException {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        int n2 = string.indexOf(58, string.indexOf(58) + 1) + 1;
        if (n2 == (n = string.length())) {
            return hashtable;
        }
        int n3 = string.indexOf(58, n2);
        if (n3 == -1) {
            return hashtable;
        }
        hashtable.put(protocol_string, string.substring(n2, n3));
        int n4 = n3 + 1;
        int n5 = string.indexOf(47, n4);
        int n6 = string.indexOf(64, n4);
        if (n6 > n4 && n4 > n2 && n5 == -1) {
            return null;
        }
        if (n6 == -1) {
            n6 = n;
        }
        if (n5 == -1) {
            n5 = n6;
        }
        if (n5 < n6) {
            hashtable.put(user_string, string.substring(n4, n5));
            hashtable.put(password_string, string.substring(n5 + 1, n6));
        }
        if (n6 < n) {
            hashtable.put(database_string, string.substring(n6 + 1));
        }
        return hashtable;
    }

    public static String getCompileTime() {
        String string = "Wed_Feb_19_15:30:04_PST_2003-stint198-jpgint";
        return string;
    }

    public static String getSystemProperty(String string) {
        return OracleDriver.getSystemProperty(string, null);
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    static {
        m_driverAccess.put("thin-server", "oracle.jdbc.thinserver.ServerTTC7Protocol");
        m_driverAccess.put("oci-server", "oracle.jdbc.ociserver.ServerOCIDBAccess");
        m_driverAccess.put("thin", "oracle.jdbc.ttc7.TTC7Protocol");
        m_driverAccess.put("oci8", "oracle.jdbc.oci8.OCIDBAccess");
        m_driverAccess.put("oci", "oracle.jdbc.oci8.OCIDBAccess");
        m_driverAccess.put("kprb", "oracle.jdbc.kprb.KprbDBAccess");
        m_defaultConn = null;
        m_defaultDriver = null;
        Timestamp timestamp = Timestamp.valueOf("2000-01-01 00:00:00.0");
        try {
            if (m_defaultDriver == null) {
                m_defaultDriver = new OracleDriver();
                DriverManager.registerDriver(m_defaultDriver);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

