﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Removes the port number from the URL, if it is the default number for the protocol -->
<xsl:template name="zap_severity">
<xsl:param name="riskcode" />
  <xsl:choose>
    <xsl:when test="$riskcode=1">
	<severity status="new">low<numeric status="new">1</numeric></severity>
    </xsl:when>
    <xsl:when test="$riskcode=2">
        <severity status="new">medium<numeric status="new">2</numeric></severity>
    </xsl:when>
    <xsl:when test="$riskcode=3">
        <severity status="new">high<numeric status="new">3</numeric></severity>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

  <xsl:template match="/">
    <magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
      <testdata class="MtBranchObject">
 	<xsl:for-each select="OWASPZAPReport/site">
          <webapp status="new">
           <xsl:variable name="starturl">
		<xsl:value-of select="@name"/>
           </xsl:variable>
        <xsl:value-of select="$starturl" />
        <xsl:for-each select="alerts/alertitem">
            <xsl:variable name="affects">
		<xsl:value-of select="concat(uri, '[', param, ' parameter]')"/>
            </xsl:variable>
          <url status="new"><xsl:value-of select="uri" />
           <finding class="MtTextObject" status="new">
                <xsl:attribute name="title">
                    <xsl:value-of select="alert" />
                </xsl:attribute>
            <xsl:attribute name="mergeID" >
		<xsl:number value="position()" format="1"/>
            </xsl:attribute>
            <xsl:value-of select="desc" />
            <source status="new">zap</source>
            <affects status="new"><xsl:value-of select="$affects" /></affects>
            <xsl:call-template name="zap_severity">
		<xsl:with-param name="riskcode" select="riskcode"/>
            </xsl:call-template>
            <solution class="MtTextObject" title="Recommendation" status="new">
                <xsl:value-of select="solution" />
            </solution>
            <reference status="new"><xsl:value-of select="reference" /> 
                    <url status="new"><xsl:value-of select="reference" /></url>
            </reference>
            <id status="new"><xsl:value-of select="pluginid" /></id>
            </finding>
          </url>
        </xsl:for-each>
        </webapp>
	</xsl:for-each>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
