<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">
    <magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
      <testdata class="MtBranchObject">
            <host status="new">
		<xsl:variable name="host">
			<xsl:value-of select="assessment-results/db-config/host" />
		</xsl:variable>
		<xsl:value-of select="$host"/>
                <ipproto status="new">tcp
                    <port status="new">
			<xsl:variable name="port">
                        	<xsl:value-of select="assessment-results/db-config/port" />
			</xsl:variable>
			<xsl:value-of select="$port"/>
                        <service status="new">
                            <xsl:choose>
                                <xsl:when test="assessment-results/db-config/db-vendor='Oracle'">
                                oracle
                                </xsl:when>
                                <xsl:when test="assessment-results/db-config/db-vendor='Sybase'">
                                sybase
                                </xsl:when>
<xsl:when test="assessment-results/db-config/db-vendor='DB2'">
                                ibm-db2
                                </xsl:when>
<xsl:when test="assessment-results/db-config/db-vendor='MS SQL'">
                                ms-sql-s
                                </xsl:when>
                            </xsl:choose>
                            <xsl:for-each select="assessment-results/test[@failed='true']">
                                <finding class="MtTextObject" status="new">
                                <xsl:attribute name="title">
                                    <xsl:value-of select="@name" />
                                </xsl:attribute>
                                <xsl:value-of select="desc" />
				<affects><xsl:value-of select="concat($host, ':', $port , ' (tcp)')" /></affects>
                                <source-severity status="new">
				<xsl:choose>
					<xsl:when test="@severity='critical'">
					high<numeric>3</numeric>
                                        </xsl:when>
                                        <xsl:when test="@severity='high'">
                                        high<numeric>3</numeric>
                                        </xsl:when>
                                        <xsl:when test="@severity='medium'">
                                        medium<numeric>2</numeric>
                                        </xsl:when>
                                        <xsl:when test="@severity='low'">
                                        low<numeric>1</numeric>
                                        </xsl:when>
                                        <xsl:when test="@severity='info'">
                                        info<numeric>0</numeric>
                                        </xsl:when>
					<xsl:otherwise>
						unknown<numeric>-1</numeric>
					</xsl:otherwise>
                                </xsl:choose>
				</source-severity>
				<xsl:if test="remediation">
				<solution title="Solution" class="MtTextObject" status="new">
				<xsl:value-of select="remediation"/>
				</solution>
				</xsl:if>
                                <xsl:if test="vulnerability">
                                <synopsis title="Synopsis" class="MtTextObject" status="new">
                                <xsl:value-of select="vulnerability"/>
                                </synopsis>
                                </xsl:if>

                                <id><xsl:value-of select="@id" /></id>
                                <source status="new">scuba</source>
                                <xsl:if test="data">
                                <output class="MtTextObject" title="Data" status="new">
				<xsl:value-of select="string-join(data/titles/title,'&#x09;')"/>
				<xsl:text>&#10;</xsl:text>
				<xsl:for-each select="data/item/tuple">
				<xsl:value-of select="string-join(value,'&#x09;')"/>
				<xsl:text>&#10;</xsl:text>
				</xsl:for-each>
                                </output>
                                </xsl:if>
                                </finding>
                            </xsl:for-each>
                        </service>
                    </port>
                </ipproto>
            </host>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
