<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:key name="service-map" match="xlat/@to" use="../@from" />

<xsl:template name="qualys-cat">
<xsl:param name="cat" />
   <xsl:choose>
     <xsl:when test="string-length($cat/@port)>0 and string-length($cat/@protocol)>0">
        <ipproto><xsl:value-of select="@protocol"/>
           <port status="new"><xsl:value-of select="@port" />
                <xsl:for-each select="$cat/*">
                    <xsl:call-template name="qualys-finding">
                        <xsl:with-param name="finding" select="." />
                    </xsl:call-template>
                </xsl:for-each>
           </port>
        </ipproto>
     </xsl:when>
     <xsl:otherwise>
        <xsl:for-each select="$cat/*">
            <xsl:call-template name="qualys-finding">
                <xsl:with-param name="finding" select="." />
            </xsl:call-template>
        </xsl:for-each>
     </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="qualys-service">
<xsl:param name="cat" />
    <xsl:choose>
        <xsl:when test="$cat/@misc='over ssl'">
            <tunnel>ssl
                <xsl:call-template name="qualys-service-guess">
                    <xsl:with-param name="cat" select="$cat" />
                </xsl:call-template>
            </tunnel>
        </xsl:when>
        <xsl:otherwise>
            <xsl:call-template name="qualys-service-guess">
               <xsl:with-param name="cat" select="$cat" />
            </xsl:call-template>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="qualys-service-guess">
<xsl:param name="cat" />
    <xsl:choose>
        <xsl:when test="$cat/@value='Web server' or $cat/@value='CGI'">
            <service status="new">http
                <xsl:for-each select="$cat/*">
                    <xsl:call-template name="qualys-finding">
                        <xsl:with-param name="finding" select="." />
                    </xsl:call-template>
                </xsl:for-each>
            </service>
        </xsl:when>
        <xsl:otherwise>
            <xsl:for-each select="$cat/*">
                <xsl:call-template name="qualys-finding">
                    <xsl:with-param name="finding" select="." />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

  <xsl:template name="qualys-finding">
    <xsl:param name="finding"/>
        <finding class="MtTextObject" status="new">
            <xsl:attribute name="title">
                <xsl:value-of select="$finding/TITLE"/> (<xsl:value-of select="$finding/@number"/>)
            </xsl:attribute>
            <source>qualys</source>
            <id><xsl:value-of select="$finding/@number" /></id>
            <xsl:call-template name="qualys-severity">
                 <xsl:with-param name="severity" select="$finding/@severity"/>
            </xsl:call-template>
            <xsl:for-each select="$finding/CVE_ID_LIST/CVE_ID/ID">
                <cve><xsl:value-of select="text()" /></cve>
            </xsl:for-each>
            <xsl:for-each select="$finding/BUGTRAQ_ID_LIST/BUGTRAQ_ID/ID">
                <bid><xsl:value-of select="text()" /></bid>
            </xsl:for-each>
            <!-- No OSVDB IDs? -->
            <xsl:if test="string-length($finding/RESULT)>0">
                <output class="MtTextObject" title="Result">
                    <xsl:value-of select="$finding/RESULT" />
                </output>
            </xsl:if>
            <xsl:value-of select="$finding/DIAGNOSIS" />
            <xsl:if test="$finding/SOLUTION!='N/A'">
                <solution title="Solution" class="MtTextObject">
                    <xsl:value-of select="$finding/SOLUTION" />
                </solution>
            </xsl:if>
            <xsl:if test="$finding/CONSEQUENCE!='N/A'">
                <impact title="Impact" class="MtTextObject">
                    <xsl:value-of select="$finding/CONSEQUENCE" />
                </impact>
            </xsl:if>
            <xsl:if test="string-length($finding/CVSS_BASE)>0">
                <cvss_base_score><xsl:value-of select="$finding/CVSS_BASE" /></cvss_base_score>
            </xsl:if>
            <xsl:if test="string-length($finding/CVSS_TEMPORAL)>0">
                <cvss_temporal_score><xsl:value-of select="$finding/CVSS_TEMPORAL" /></cvss_temporal_score>
            </xsl:if>
        </finding>
  </xsl:template>


<xsl:template name="qualys-severity">
<xsl:param name="severity" />
<source-severity>
<xsl:choose>
 <xsl:when test="$severity=5">
high<numeric>3</numeric>
 </xsl:when>
 <xsl:when test="$severity=4">
high<numeric>3</numeric>
 </xsl:when>
 <xsl:when test="$severity=3">
medium<numeric>2</numeric>
 </xsl:when>
 <xsl:when test="$severity=2">
low<numeric>1</numeric>
 </xsl:when>
 <xsl:when test="$severity=1">
info<numeric>0</numeric>
 </xsl:when>
 <xsl:otherwise>
unknown<numeric>-1</numeric>
 </xsl:otherwise>
</xsl:choose>
</source-severity>
</xsl:template>

  <xsl:template match="/">
    <magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
      <testdata class="MtBranchObject">
        <xsl:for-each select="SCAN/IP">
          <host status="new">
            <xsl:value-of select="@value"/>
            <hostname status="new"><xsl:value-of select="@name"/></hostname>
            <os status="new"><xsl:value-of select="./OS"/></os>
            <nbname status="new"><xsl:value-of select="./NETBIOS_HOSTNAME"/></nbname>
            <xsl:for-each select="*/CAT">
                 <xsl:call-template name="qualys-cat">
                     <xsl:with-param name="cat" select="." />
                 </xsl:call-template>
            </xsl:for-each>
          </host>
        </xsl:for-each>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
