<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:key name="service-map" match="xlat/@to" use="../@from" />


<xsl:template name="openvas-finding">
<xsl:param name="result" />
<xsl:param name="affects" />
                    <finding class="MtTextObject" status="new">
                      <xsl:attribute name="title">
                      <xsl:value-of select="$result/nvt/name" />
                      </xsl:attribute>
                      <xsl:call-template name="openvas-whitespace">
                        <xsl:with-param name="string" select="$result/description/text()" />
                      </xsl:call-template>
                      <source status="new">openvas</source>
                      <xsl:call-template name="openvas-severity">
                           <xsl:with-param name="severity" select="$result/nvt/risk_factor" />
                      </xsl:call-template>
                      <id status="new"><xsl:value-of select="$result/nvt/@oid"/></id>
                      <xsl:if test="$result/nvt/cve!='NOCVE'">
                        <xsl:for-each select="$result/nvt/cve">
                        <cve status="new"><xsl:value-of select="text()"/></cve>
                        </xsl:for-each>
                      </xsl:if>
                      <xsl:if test="$result/nvt/bid!='NOBID'">
                        <xsl:for-each select="$result/nvt/bid">
                        <bid status="new"><xsl:value-of select="text()"/></bid>
                        </xsl:for-each>
                      </xsl:if>
                      <xsl:if test="$result/cvss_base>0">
                        <cvss_base_score status="new"><xsl:value-of select="$result/cvss_base"/></cvss_base_score>
                      </xsl:if>
                      <affects status="new"><xsl:value-of select="$affects"/></affects>
                    </finding>
</xsl:template>

<xsl:template name="openvas-whitespace">
<xsl:param name="string" />
  <xsl:choose>
    <xsl:when test="contains($string, '&#xa;')">
<xsl:value-of select="normalize-space(substring-before($string,'&#xa;'))" />
<xsl:text>
</xsl:text>
        <xsl:call-template name="openvas-whitespace">
            <xsl:with-param name="string" select="substring-after($string, '&#xa;')" />
        </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
<xsl:value-of select="normalize-space($string)" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="openvas-service">
<xsl:param name="service-name" />
<xsl:param name="result" />
<xsl:param name="affects" />
       <xsl:variable name="mapped-service">
        <xsl:for-each select="document('service-map.xml')">
          <xsl:value-of select="key('service-map', $service-name)" />
        </xsl:for-each>
       </xsl:variable>
        <xsl:choose>
        <xsl:when test="document('service-map.xml')/service-map/xlat[@from=$service-name]/@ssl">
          <tunnel status="new">ssl
            <service status="new">
              <xsl:choose>
                 <xsl:when test="string-length($mapped-service)>0">
                   <xsl:value-of select="$mapped-service"/>
                 </xsl:when>
                 <xsl:otherwise>
                   <xsl:value-of select="$service-name"/>
                 </xsl:otherwise>
              </xsl:choose>
              <xsl:call-template name="openvas-finding">
                <xsl:with-param name="result" select="$result"/>
                <xsl:with-param name="affects" select="$affects"/>
              </xsl:call-template>
            </service>
          </tunnel>
        </xsl:when>
        <xsl:otherwise>
            <service status="new">
              <xsl:choose>
                 <xsl:when test="string-length($mapped-service)>0">
                   <xsl:value-of select="$mapped-service"/>
                 </xsl:when>
                 <xsl:otherwise>
                   <xsl:value-of select="$service-name"/>
                 </xsl:otherwise>
              </xsl:choose>
              <xsl:call-template name="openvas-finding">
                <xsl:with-param name="result" select="$result"/>
                <xsl:with-param name="affects" select="$affects"/>
              </xsl:call-template>
            </service>
        </xsl:otherwise>
       </xsl:choose>
</xsl:template>

<xsl:template name="openvas-port">
    <xsl:param name="result" />

    <xsl:variable name="port">
        <xsl:value-of select="substring-before(substring-after($result/port,'('),'/')" />
    </xsl:variable>
    <xsl:variable name="ipproto">
        <xsl:value-of select="substring-before(substring-after($result/port,'/'),')')" />
    </xsl:variable>
    <xsl:variable name="service">
        <xsl:value-of select="substring-before($result/port,' ')" />
    </xsl:variable>

    <ipproto status="new"><xsl:value-of select='$ipproto'/>
        <port status="new"><xsl:value-of select='$port'/>
          <xsl:call-template name="openvas-service">
            <xsl:with-param name="service-name" select="$service" />
            <xsl:with-param name="result" select="$result" />
            <xsl:with-param name="affects" select="concat($result/host, ':', $port, ' (', $ipproto,')')" />
          </xsl:call-template>
        </port>
    </ipproto>
</xsl:template>

<xsl:template name="openvas-severity">
<xsl:param name="severity" />
<source-severity status="new">
<xsl:choose>
 <xsl:when test="$severity='High' or $severity='Critical'">
high<numeric status="new">3</numeric>
 </xsl:when>
 <xsl:when test="$severity='Medium'">
medium<numeric status="new">2</numeric>
 </xsl:when>
 <xsl:when test="$severity='Low'">
low<numeric status="new">1</numeric>
 </xsl:when>
 <xsl:when test="$severity='None'">
info<numeric status="new">0</numeric>
 </xsl:when>
 <xsl:otherwise>
unknown<numeric status="new">-1</numeric>
 </xsl:otherwise>
</xsl:choose>
</source-severity>
</xsl:template>

<xsl:template match="/">
<magictree xmlns:mt="http://www.gremwell.com/magictree" class="MtBranchObject">
   <testdata class="MtBranchObject">
    <xsl:for-each select="/report/report/results/result">
        <xsl:value-of select="./nvt/name" />
        <host status="new"><xsl:value-of select="host"/>
<!-- Ports can look like this: "general/tcp" or "ssh (22/tcp)" -->
            <xsl:choose>
                <xsl:when test="starts-with(port,'general/')">
                <xsl:variable name="ipproto">
                    <xsl:value-of select="substring-after(port,'\')" />
                </xsl:variable>
<!--OpenVAS 4 uses port definitions such as "general/CPE-T" or "general/HOST-T"  
    In this case we put the finding directly under host -->
                <xsl:choose>
                <xsl:when test="$ipproto='tcp' or $ipproto='udp' or $ipproto='icmp'">
                <ipproto status="new"><xsl:value-of select="$ipproto"/>
                    <xsl:call-template name="openvas-finding">
                        <xsl:with-param name="result" select="." />
                        <xsl:with-param name="affects" select="host" />
                    </xsl:call-template>
                </ipproto>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="openvas-finding">
                        <xsl:with-param name="result" select="." />
                        <xsl:with-param name="affects" select="host" />
                    </xsl:call-template>
                </xsl:otherwise>
                </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="openvas-port">
                        <xsl:with-param name="result" select="." />
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </host>
    </xsl:for-each>
    </testdata>
</magictree>
</xsl:template>
</xsl:stylesheet>
