<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:key name="service-map" match="xlat/@to" use="../@from" />


<xsl:template name="openvas-finding">
<xsl:param name="information" />
                    <finding class="MtTextObject" status="new">
                      <xsl:attribute name="title">
                      <xsl:value-of select="//nvt[@oid=$information/id]/name" />
                      </xsl:attribute>
                      <xsl:call-template name="openvas-whitespace">
                        <xsl:with-param name="string" select="$information/data/text()" />
                      </xsl:call-template>
                      <source>openvas</source>
                      <xsl:call-template name="openvas-severity">
                           <xsl:with-param name="severity" select="$information/severity" />
                      </xsl:call-template>
                      <id><xsl:value-of select="$information/id"/></id>
                      <xsl:call-template name="openvas-cve">
                          <xsl:with-param name="data" select="$information/data"/>
                      </xsl:call-template>
                    </finding>
</xsl:template>

<xsl:template name="openvas-whitespace">
<xsl:param name="string" />
  <xsl:choose>
    <xsl:when test="contains($string, '&#xa;')">
<xsl:value-of select="normalize-space(substring-before($string,'&#xa;'))" />
<xsl:text>
</xsl:text>
        <xsl:call-template name="openvas-whitespace">
            <xsl:with-param name="string" select="substring-after($string, '&#xa;')" />
        </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
<xsl:value-of select="normalize-space($string)" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="openvas-cve">
<xsl:param name="data" />
    <xsl:if test="contains($data/text(), 'CVE : ')">
       <cve><xsl:value-of select="substring-before(substring-after($data/text(),'CVE : '),'&#xa;')" /></cve>
    </xsl:if>
</xsl:template>

<xsl:template name="openvas-service">
<xsl:param name="service-name" />
<xsl:param name="service-data" />
       <service status="new">
       <xsl:variable name="mapped-service">
        <xsl:for-each select="document('service-map.xml')">
          <xsl:value-of select="key('service-map', $service-name)" />
        </xsl:for-each>
       </xsl:variable>

       <xsl:choose>
        <xsl:when test="string-length($mapped-service)>0">
         <xsl:value-of select="$mapped-service"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$service-name"/>
        </xsl:otherwise>
       </xsl:choose>

       <xsl:for-each select="$service-data/information">
            <xsl:call-template name="openvas-finding">
              <xsl:with-param name="information" select="."/>
            </xsl:call-template>
       </xsl:for-each>
       </service>
</xsl:template>

<xsl:template name="openvas-severity">
<xsl:param name="severity" />
<source-severity>
<xsl:choose>
 <xsl:when test="$severity='Security Hole'">
high<numeric>3</numeric>
 </xsl:when>
 <xsl:when test="$severity='Security Warning'">
medium<numeric>2</numeric>
 </xsl:when>
 <xsl:when test="$severity='Security Note'">
low<numeric>1</numeric>
 </xsl:when>
 <xsl:when test="$severity='Log Message'">
info<numeric>0</numeric>
 </xsl:when>
 <xsl:otherwise>
unknown<numeric>-1</numeric>
 </xsl:otherwise>
</xsl:choose>
</source-severity>
</xsl:template>

<xsl:template match="/">
<magictree xmlns:mt="http://www.gremwell.com/magictree" class="MtBranchObject">
   <testdata class="MtBranchObject">
    <xsl:for-each select="openvas-report/results/result">
        <xsl:for-each select="host">
        <host status="new"><xsl:value-of select="@ip"/>
            <xsl:for-each select="../ports/port">
            <xsl:choose> 
               <xsl:when test="string-length(./@protocol)>0"> 
                <ipproto><xsl:value-of select="./@protocol"/>
                <port status="new"><xsl:value-of select="@portid"/>
                <xsl:variable name="service-name" select="service/@name" />

                <xsl:choose>
                  <xsl:when test="document('service-map.xml')/service-map/xlat[@from=$service-name]/@ssl">
                    <tunnel>ssl
                        <xsl:call-template name="openvas-service">
                            <xsl:with-param name="service-name" select="$service-name"/>
                            <xsl:with-param name="service-data" select="current()"/>
                        </xsl:call-template>
                    </tunnel>
                   </xsl:when>
                   <xsl:otherwise>
                        <xsl:call-template name="openvas-service">
                            <xsl:with-param name="service-name" select="$service-name"/>
                            <xsl:with-param name="service-data" select="current()"/>
                        </xsl:call-template>
                   </xsl:otherwise>
                </xsl:choose>
                </port>
                </ipproto>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="information">
                       <xsl:call-template name="openvas-finding">
                           <xsl:with-param name="information" select="."/>
                       </xsl:call-template>
                    </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
            </xsl:for-each>
        </host>
    </xsl:for-each>
    </xsl:for-each>
    </testdata>
</magictree>
</xsl:template>
</xsl:stylesheet>
