<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:key name="service-map" match="xlat/@to" use="../@from" />

  <xsl:template name="nessus-service">
    <xsl:param name="service-name"/>
    <xsl:param name="service-data"/>
      <service status="new">
       <xsl:variable name="mapped-service">
        <xsl:for-each select="document('service-map.xml')">
          <xsl:value-of select="key('service-map', $service-name)" />
        </xsl:for-each>
       </xsl:variable>

       <xsl:choose>
        <xsl:when test="string-length($mapped-service)>0">
         <xsl:value-of select="$mapped-service"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$service-name"/>
        </xsl:otherwise>
       </xsl:choose>

       <xsl:call-template name="nessus-finding">
        <xsl:with-param name="item" select="$service-data"/>
       </xsl:call-template>
     </service>
  </xsl:template>

  <xsl:template name="nessus-finding">
    <xsl:param name="item"/>
    <xsl:if test="$item/data!= 'PORT'">
      <finding class="MtTextObject" status="new">
        <xsl:attribute name="title">
          <xsl:value-of select="$item/pluginName"/>
        </xsl:attribute>
<xsl:variable name="plugin-data">
<xsl:call-template name="replace-slash-n">
    <xsl:with-param name="string" select="$item/data/text()" />
</xsl:call-template>
</xsl:variable>
<xsl:call-template name="extract-plugin-output">
    <xsl:with-param name="text" select="$plugin-data" />
</xsl:call-template>

                      <source>nessus</source>
                      <xsl:call-template name="nessus-severity">
                           <xsl:with-param name="severity" select="$item/severity" />
                      </xsl:call-template>
        <xsl:if test="$item/pluginID">
          <id>
            <xsl:value-of select="$item/pluginID"/>
          </id>
        </xsl:if>
                      <xsl:call-template name="nessus-cve">
                          <xsl:with-param name="data" select="$item/data"/>
                      </xsl:call-template>
                    </finding>
    </xsl:if>
  </xsl:template>

  <xsl:template name="extract-plugin-output">
    <xsl:param name="text"/>
    <xsl:choose>
    <xsl:when test="contains($text, 'Plugin output :')">
        <xsl:value-of select="substring-before($text, 'Plugin output :')"/>
        <output class="MtTextObject" title="Plugin Output">
            <xsl:value-of select="substring-after($text, 'Plugin output :')"/>
        </output>
    </xsl:when>
    <xsl:otherwise>
    <xsl:value-of select="$text" />
    </xsl:otherwise> 
    </xsl:choose>
  </xsl:template>

  <xsl:template name="replace-slash-n">
    <xsl:param name="string"/>
    <xsl:choose>
      <xsl:when test="contains($string, '\n')">
<xsl:value-of select="substring-before($string,'\n')"/>
<xsl:text>
</xsl:text>
<xsl:call-template name="replace-slash-n">
          <xsl:with-param name="string" select="substring-after($string, '\n')"/>
</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
<xsl:value-of select="$string"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="nessus-cve">
    <xsl:param name="data"/>
    <xsl:if test="contains($data/text(), 'CVE : ')">
      <xsl:call-template name="split-cve">
        <xsl:with-param name="string" select="substring-before(substring-after($data/text(),'CVE : '),'\n')"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="split-cve">
    <xsl:param name="string"/>
    <xsl:choose>
      <xsl:when test="contains($string, ', ')">
        <cve>
          <xsl:value-of select="substring-before($string,', ')"/>
        </cve>
        <xsl:call-template name="split-cve">
          <xsl:with-param name="string" select="substring-after($string, ', ')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <cve>
          <xsl:value-of select="$string"/>
        </cve>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="nessus-dns-name">
    <xsl:param name="dnsname"/>
    <xsl:if test="$dnsname!='(unknown)' and string-length($dnsname)>0">
<hostname status="new">
    <xsl:value-of select="substring-before($dnsname, '.\n')"/>
</hostname>
    </xsl:if>
  </xsl:template>

<xsl:template name="nessus-severity">
<xsl:param name="severity" />
<source-severity>
<xsl:choose>
 <xsl:when test="$severity=3">
high<numeric>3</numeric>
 </xsl:when>
 <xsl:when test="$severity=2">
medium<numeric>2</numeric>
 </xsl:when>
 <xsl:when test="$severity=1">
low<numeric>1</numeric>
 </xsl:when>
 <xsl:when test="$severity=0">
info<numeric>0</numeric>
 </xsl:when>
 <xsl:otherwise>
unknown<numeric>-1</numeric>
 </xsl:otherwise>
</xsl:choose>
</source-severity>
</xsl:template>

  <xsl:template match="/">
    <magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
      <testdata class="MtBranchObject">
        <xsl:for-each select="NessusClientData/Report/ReportHost">
          <host status="new">
            <xsl:value-of select="HostName"/>
              <xsl:call-template name="nessus-dns-name">
                <xsl:with-param name="dnsname" select="dns_name"/>
              </xsl:call-template>
            <xsl:if test="netbios_name != '(unknown)' and string-length(netbios_name) > 0">
              <nbname status="new">
                <xsl:value-of select="netbios_name"/>
              </nbname>
            </xsl:if>
            <xsl:if test="os_name != '(unknown)' and string-length(os_name)>0">
              <os status="new">
                <xsl:value-of select="os_name"/>
              </os>
            </xsl:if>
            <xsl:if test="mac_addr != '(unknown)' and string-length(mac_addr)>0">
              <mac status="new">
                <xsl:value-of select="mac_addr"/>
              </mac>
            </xsl:if>
            <xsl:for-each select="ReportItem">
              <xsl:choose>
                <xsl:when test="starts-with(port, 'general/')">
                  <xsl:call-template name="nessus-finding">
                    <xsl:with-param name="item" select="current()"/>
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                  <ipproto>
                    <xsl:value-of select="substring-before(substring-after(port,'/'), ')')"/>
                    <port status="new">
                      <xsl:value-of select="substring-after(substring-before(port,'/'), '(')"/>
                      <state>open</state>
                      <xsl:variable name="service-name" select="substring-before(port,' (')"/>
                      <xsl:choose>
                        <xsl:when test="document('service-map.xml')/service-map/xlat[@from=$service-name]/@ssl">
                          <tunnel>ssl
                            <xsl:call-template name="nessus-service">
                               <xsl:with-param name="service-name" select="$service-name"/>
                               <xsl:with-param name="service-data" select="current()"/>
                            </xsl:call-template>
                          </tunnel>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:call-template name="nessus-service">
                            <xsl:with-param name="service-name" select="$service-name"/>
                            <xsl:with-param name="service-data" select="current()"/>
                          </xsl:call-template>
                        </xsl:otherwise>
                      </xsl:choose>
                    </port>
                  </ipproto>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:for-each>
          </host>
        </xsl:for-each>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
