<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:key name="service-map" match="xlat/@to" use="../@from" />

<!-- Nessus adds a question mark to service names when it is unsure about service detection. Here we strip it -->
  <xsl:template name="strip-question-mark">
    <xsl:param name="service-name"/>
            <xsl:choose>
         <xsl:when test="ends-with($service-name, '?')"> <!--Chop trailing question mark-->
            <xsl:value-of select="substring-before($service-name,'?')"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$service-name"/>
         </xsl:otherwise>
        </xsl:choose>
  </xsl:template>

  <xsl:template name="mapped-service">
    <xsl:param name="service-name"/>
      <xsl:variable name="mapped-service">
         <xsl:for-each select="document('service-map.xml')">
           <xsl:value-of select="key('service-map', $service-name)" />
         </xsl:for-each>
      </xsl:variable>
       <xsl:choose>
        <xsl:when test="string-length($mapped-service)>0">
         <xsl:value-of select="$mapped-service"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$service-name"/>
        </xsl:otherwise>
       </xsl:choose>

  </xsl:template>

  <xsl:template name="nessus-service">
    <xsl:param name="service-name"/>
    <xsl:param name="service-data"/>
    <xsl:param name="affects" />
       <xsl:variable name="stripped-service">
        <xsl:call-template name="strip-question-mark">
          <xsl:with-param name="service-name" select="$service-name"/>
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="mapped-service">
        <xsl:call-template name="mapped-service">
          <xsl:with-param name="service-name" select="$stripped-service"/>
        </xsl:call-template>
       </xsl:variable>
       <xsl:choose>
        <xsl:when test="document('service-map.xml')/service-map/xlat[@from=$stripped-service]/@ssl">
<tunnel>ssl
    <service status="new">
        <xsl:value-of select="$mapped-service"/>
         <xsl:call-template name="nessus-finding">
           <xsl:with-param name="item" select="$service-data"/>
           <xsl:with-param name="affects" select="$affects"/>
         </xsl:call-template>
    </service>
</tunnel>
        </xsl:when>
        <xsl:otherwise>
    <service status="new">
        <xsl:value-of select="$mapped-service"/>
         <xsl:call-template name="nessus-finding">
           <xsl:with-param name="item" select="$service-data"/>
            <xsl:with-param name="affects" select="$affects"/>
         </xsl:call-template>
    </service>
        </xsl:otherwise>
       </xsl:choose>
  </xsl:template>

  <xsl:template name="nessus-reference">
    <xsl:param name="xref" />
    <xsl:variable name="id">
        <xsl:value-of select="substring-after($xref, ':')"/>
    </xsl:variable>
    <xsl:choose>
        <xsl:when test="starts-with($xref, 'OSVDB')">
            <osvdb status="new"><xsl:value-of select="$id"/>
                <url status="new">http://osvdb.org/show/osvdb/<xsl:value-of select="$id"/></url>
            </osvdb>
        </xsl:when>
        <xsl:when test="starts-with($xref, 'CERT')">
            <reference status="new">Vulnerability Note VU#<xsl:value-of select="$id"/>
                <url status="new">http://www.kb.cert.org/vuls/id/<xsl:value-of select="$id"/></url>
            </reference>
        </xsl:when>
        <xsl:when test="starts-with($xref, 'Secunia')">
            <reference status="new">Secunia Advisory SA<xsl:value-of select="$id"/>
                <url status="new">http://secunia.com/advisories/<xsl:value-of select="$id"/></url>
            </reference>
        </xsl:when>
        <xsl:when test="starts-with($xref, 'CWE')">
            <reference status="new">CWE-<xsl:value-of select="$id"/>
                <url status="new">http://cwe.mitre.org/data/definitions/<xsl:value-of select="$id"/>.html</url>
            </reference>
        </xsl:when>
        <xsl:when test="starts-with($xref, 'EDB')">
            <reference status="new">EDB-ID <xsl:value-of select="$id"/>
                <url status="new">http://www.exploit-db.com/exploits/<xsl:value-of select="$id"/>/</url>
            </reference>
        </xsl:when>
        <xsl:when test="starts-with($xref, 'MSFT')">
            <reference status="new">Microsoft Security Bulletin <xsl:value-of select="$id"/>
                <url status="new">http://technet.microsoft.com/en-us/security/bulletin/<xsl:value-of select="$id"/>/</url>
            </reference>
        </xsl:when>
        <xsl:otherwise>
            <reference status="new"><xsl:value-of select="$xref"/></reference>
        </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="nessus-finding">
    <xsl:param name="item"/>
    <xsl:param name="affects" />
        <xsl:if test="$item/@pluginID!=0">
        <finding class="MtTextObject" status="new">
            <xsl:attribute name="title">
                <xsl:value-of select="$item/@pluginName" />
            </xsl:attribute>
            <source status="new">nessus</source>
            <id status="new"><xsl:value-of select="$item/@pluginID" /></id>
            <xsl:call-template name="nessus-severity">
                 <xsl:with-param name="severity" select="$item/@severity"/>
            </xsl:call-template>
            <xsl:if test="$item/exploit_available">
            <exploit_available status="new">true
	    <xsl:if test="$item/exploit_framework_canvas">
              <exploit status="new">canvas</exploit>
            </xsl:if>
            <xsl:if test="$item/exploit_framework_core">
              <exploit status="new">core</exploit>
            </xsl:if>
            <xsl:if test="$item/exploit_framework_metasploit">
              <exploit status="new">metasploit</exploit>
            </xsl:if>
            </exploit_available>
            </xsl:if>
            <affects status="new"><xsl:value-of select="$affects" /></affects>
            <xsl:for-each select="$item/cve">
            <cve status="new"><xsl:value-of select="."/>
              <url status="new">http://cve.mitre.org/cgi-bin/cvename.cgi?name=<xsl:value-of select="."/></url>
            </cve>
            </xsl:for-each>
            <xsl:for-each select="$item/bid">
            <bid status="new"><xsl:value-of select="."/>
              <url status="new">http://www.securityfocus.com/bid/<xsl:value-of select="."/></url>
            </bid>
	    </xsl:for-each>
            <xsl:for-each select="$item/xref">
                <xsl:call-template name="nessus-reference">
                    <xsl:with-param name="xref" select="." />
                </xsl:call-template>
            </xsl:for-each>
            <xsl:if test="string-length($item/plugin_output)>0">
                <output class="MtTextObject" title="Details" status="new">
                    <xsl:value-of select="$item/plugin_output" />
                </output>
            </xsl:if>
            <xsl:value-of select="$item/description" />
            <xsl:if test="string-length($item/synopsis)>0">
                <synopsis title="Synopsis" class="MtTextObject" status="new">
                    <xsl:value-of select="$item/synopsis" />
                </synopsis>
            </xsl:if>
            <xsl:if test="string-length($item/solution)>0">
                <solution title="Solution" class="MtTextObject" status="new">
                    <xsl:value-of select="$item/solution" />
                </solution>
            </xsl:if>
            <xsl:copy-of select="$item/cvss_vector" />
            <xsl:copy-of select="$item/cvss_base_score" />
            <xsl:for-each select="$item/see_also">
                 <reference status="new"><xsl:value-of select="text()" /></reference>
            </xsl:for-each>
        </finding>
        </xsl:if>
  </xsl:template>


  <xsl:template name="nessus-dns-name">
    <xsl:param name="dnsname"/>
    <xsl:if test="$dnsname!='(unknown)' and string-length($dnsname)>0">
<hostname status="new">
    <xsl:value-of select="substring-before($dnsname, '.\n')"/>
</hostname>
    </xsl:if>
  </xsl:template>

<xsl:template name="nessus-severity">
<xsl:param name="severity" />
<source-severity status="new">
<xsl:choose>
 <xsl:when test="$severity=3 or $severity=4">
high<numeric status="new">3</numeric>
 </xsl:when>
 <xsl:when test="$severity=2">
medium<numeric status="new">2</numeric>
 </xsl:when>
 <xsl:when test="$severity=1">
low<numeric status="new">1</numeric>
 </xsl:when>
 <xsl:when test="$severity=0">
info<numeric status="new">0</numeric>
 </xsl:when>
 <xsl:otherwise>
unknown<numeric status="new">-1</numeric>
 </xsl:otherwise>
</xsl:choose>
</source-severity>
</xsl:template>

  <xsl:template match="/">
    <magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
      <testdata class="MtBranchObject">
        <xsl:for-each select="NessusClientData_v2/Report/ReportHost">
          <host status="new">
            <xsl:variable name="host">
            <xsl:choose>
                <xsl:when test="HostProperties/tag[@name='host-ip']">
                    <xsl:value-of select="HostProperties/tag[@name='host-ip']"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@name"/>
                </xsl:otherwise>
            </xsl:choose>
            </xsl:variable>
            <xsl:value-of select="$host" />
            <xsl:if test="HostProperties/tag[@name='host-fqdn']">
            <hostname status="new"><xsl:value-of select="HostProperties/tag[@name='host-fqdn']"/></hostname>
            </xsl:if>
            <xsl:if test="HostProperties/tag[@name='operating-system']">
            <os status="new"><xsl:value-of select="HostProperties/tag[@name='operating-system']"/></os>
            </xsl:if>
            <xsl:if test="HostProperties/tag[@name='mac-address']">
            <mac status="new"><xsl:value-of select="HostProperties/tag[@name='mac-address']"/></mac>
            </xsl:if>
            <xsl:if test="HostProperties/tag[@name='netbios-name']">
            <nbname status="new"><xsl:value-of select="HostProperties/tag[@name='netbios-name']"/></nbname>
            </xsl:if>
            <xsl:for-each select="ReportItem">
                <ipproto status="new"><xsl:value-of select="@protocol" />
                    <xsl:choose>
                        <xsl:when test="@port!=0">
                            <port status="new"><xsl:value-of select="@port" />
                            <xsl:call-template name="nessus-service">
                                <xsl:with-param name="service-name" select="@svc_name" />
                                <xsl:with-param name="service-data" select="." />
                                <xsl:with-param name="affects" select="concat($host, ':', @port, ' (', @protocol,')')" />
                            </xsl:call-template>
                            </port>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="nessus-finding">
                                <xsl:with-param name="item" select="." />
                                <xsl:with-param name="affects" select="$host" />
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </ipproto>
            </xsl:for-each>
          </host>
        </xsl:for-each>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
