<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:key name="service-map" match="xlat/@to" use="../@from" />

<xsl:template name="metasploit-service">
<xsl:param name="host"/>
<xsl:param name="service-name" />
<xsl:param name="service-data" />
<xsl:param name="affects" />
       <service status="new">
       <xsl:variable name="mapped-service">
        <xsl:for-each select="document('service-map.xml')">
          <xsl:value-of select="key('service-map', $service-name)" />
        </xsl:for-each>
       </xsl:variable>

       <xsl:choose>
        <xsl:when test="string-length($mapped-service)>0">
         <xsl:value-of select="$mapped-service"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$service-name"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:variable name="vulns" select="$host/vulns/vuln[service-id=$service-data/id]"/>
       <xsl:if test="count($vulns)>0">
       <xsl:call-template name="finding">
         <xsl:with-param name="host" select="$host"/>
         <xsl:with-param name="vulns" select="$vulns"/>
         <xsl:with-param name="affects" select="$affects"/>
       </xsl:call-template>
       </xsl:if>
       <xsl:if test="string-length($service-data/info) >0 ">
       <software status="new"><xsl:value-of select="$service-data/info"/></software>
       </xsl:if>
       </service>
</xsl:template>

<xsl:template name="finding">
 <xsl:param name="host"/>
 <xsl:param name="vulns" />
 <xsl:param name="affects" />
 <xsl:for-each select="$vulns">
    <finding class="MtTextObject" status="new">
      <xsl:choose>
        <xsl:when test="string-length(info)>0">
          <xsl:attribute name="title">
            <xsl:value-of select="info"/>
          </xsl:attribute>
         </xsl:when>
         <xsl:otherwise>
           <xsl:attribute name="title">
             <xsl:value-of select="name"/>
           </xsl:attribute>
         </xsl:otherwise>
      </xsl:choose>
      <source status="new">metasploit</source>
      <id status="new"><xsl:value-of select="name"/></id>
      <affects status="new"><xsl:value-of select="$affects"/></affects>
      <xsl:call-template name="references">
        <xsl:with-param name="refs" select="./refs"/>
      </xsl:call-template>
    </finding>
 </xsl:for-each>
</xsl:template>

<xsl:template name="references">
 <xsl:param name="refs" />
 <xsl:for-each select="$refs/ref">
   <xsl:variable name="type">
     <xsl:value-of select="substring-before(., '-')"/>
   </xsl:variable>
   <xsl:variable name="id">
     <xsl:value-of select="substring-after(., '-')"/>
   </xsl:variable>
    <xsl:choose>
      <xsl:when test="$type='OSVDB'">
      <osvdb status="new"><xsl:value-of select="$id"/>
         <url status="new">http://osvdb.org/show/osvdb/<xsl:value-of select="$id"/></url>
      </osvdb>
      </xsl:when>
      <xsl:when test="$type='CVE'">
      <cve status="new"><xsl:value-of select="$id"/>
         <url status="new">http://cwe.mitre.org/data/definitions/<xsl:value-of select="$id"/>.html</url>
      </cve>
      </xsl:when>
      <xsl:when test="$type='BID'">
      <bid status="new"><xsl:value-of select="$id"/>
         <url status="new">http://cwe.mitre.org/data/definitions/<xsl:value-of select="$id"/>.html</url>
      </bid>
      </xsl:when>
      <xsl:when test="$type='APPLE'">
      <reference status="new"><xsl:value-of select="$id"/>
<!-- Can't find a URL where Apple keeps its security advisories. Strange, eh? -->
      </reference>
      </xsl:when>
      <xsl:when test="$type='MSB'">
      <reference status="new">
         Microsoft Security Bulletin <xsl:value-of select="substring-after($id, 'MS-')"/>
         <url status="new">http://technet.microsoft.com/en-us/security/bulletin/<xsl:value-of select="lower-case(substring-after($id, 'MS-'))"/></url>
      </reference>
      </xsl:when>
      <xsl:when test="$type='MSKB'">
      <reference status="new">
         Microsoft Knowledge Base Article <xsl:value-of select="$id"/>
         <url status="new">http://support.microsoft.com/kb/<xsl:value-of select="$id"/></url>
      </reference>
      </xsl:when>
      <xsl:otherwise>
      <reference><xsl:value-of select="."/></reference>
      </xsl:otherwise>
    </xsl:choose>  
 </xsl:for-each>
</xsl:template>


<xsl:template match="/">
<magictree xmlns:mt="http://www.gremwell.com/magictree" class="MtBranchObject">
    <testdata class="MtBranchObject">
    <xsl:for-each select="MetasploitV4/hosts/host">
        <host status="new"><xsl:value-of select="address" />
        <xsl:variable name="host" select="."/>
        <xsl:if test="state='alive'">
        <state status="new">up</state> <!-- To make it same as nmap -->
        </xsl:if>
        <xsl:if test="string-length(name)>0">
        <hostname status="new"><xsl:value-of select="name" /></hostname>
        </xsl:if>
        <xsl:if test="string-length(os-flavor)>0 or string-length(os-name)>0 or string-length(os-sp)>0">
         <os status="new"><xsl:value-of select="concat(os-name, ' ', os-flavor, ' ', os-sp)" />
          <xsl:if test="string-length(os-lang)>0">
           <language status="new"><xsl:value-of select="os-lang" /></language>
          </xsl:if>
         </os>
        </xsl:if>
        <xsl:if test="string-length(mac)>0">
         <mac status="new"><xsl:value-of select="lower-case(mac)" /></mac>
        </xsl:if>
        <xsl:if test="string-length(arch)>0">
         <arch status="new"><xsl:value-of select="arch" /></arch>
        </xsl:if>
        <xsl:for-each select="services/service">
            <ipproto status="new"><xsl:value-of select="proto"/>
              <port status="new"><xsl:value-of select="port"/>
                <state status="new"><xsl:value-of select="state"/></state>
                <xsl:choose>
                  <xsl:when test="document('service-map.xml')/service-map/xlat[@from=name]/@ssl">
                    <tunnel status="new">ssl
                        <xsl:call-template name="metasploit-service">
                            <xsl:with-param name="host" select="$host"/>
                            <xsl:with-param name="service-name" select="name"/>
                            <xsl:with-param name="service-data" select="current()"/>
                            <xsl:with-param name="affects" select="concat($host/address, ':', port, ' (', proto,')')"/>
                        </xsl:call-template>
                    </tunnel>
                   </xsl:when>
                   <xsl:otherwise>
                        <xsl:call-template name="metasploit-service">
                            <xsl:with-param name="host" select="$host"/>
                            <xsl:with-param name="service-name" select="name"/>
                            <xsl:with-param name="service-data" select="current()"/>
                            <xsl:with-param name="affects" select="concat($host/address, ':', port, ' (', proto,')')"/>
                        </xsl:call-template>
                   </xsl:otherwise>
                </xsl:choose>
              </port>
            </ipproto>
        </xsl:for-each>
        <xsl:call-template name="finding">
          <xsl:with-param name="host" select="$host"/>
          <xsl:with-param name="vulns" select="$host/vulns/vuln[string-length(service-id)=0]"/>
          <xsl:with-param name="affects" select="$host/address"/>
        </xsl:call-template>
	</host>
    </xsl:for-each>
    <xsl:for-each select="/MetasploitV4/credentials/credential">
        <xsl:variable name="service-id" select="./service-id"/>
        <xsl:variable name="service" select="/MetasploitV4/hosts/host/services/service[id=$service-id]"/>
        <xsl:variable name="host" select="/MetasploitV4/hosts/host[id=$service/host-id]"/>
        <host status="new"><xsl:value-of select="$host/address"/>
          <ipproto status="new"><xsl:value-of select="$service/proto"/>
             <port status="new"><xsl:value-of select="$service/port"/>
               <user status="new"><xsl:value-of select="user"/>
               <password status="new"><xsl:value-of select="pass"/>
               <type status="new"><xsl:value-of select="ptype"/></type>  
               </password>
               </user>
             </port>
          </ipproto>
        </host>
    </xsl:for-each>
    </testdata>
</magictree>
</xsl:template>
</xsl:stylesheet>
