<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
  <magictree class="MtBranchObject">
    <testdata class="MtBranchObject">
       <webapp status="new"><xsl:value-of select="arachni_report/system/url"/>
          <xsl:for-each select="arachni_report/issues/issue">
             <finding status="new" class="MtTextObject">
		<xsl:attribute name="title">
                    <xsl:value-of select="name"/>
                </xsl:attribute>
                <xsl:attribute name="mergeID">
                    <xsl:value-of select="_hash"/>
                </xsl:attribute>
                <xsl:value-of select="description"/>
                <source status="new">arachni</source>
                <location status="new"><xsl:value-of select="url"/></location>
                <affects status="new">
                  <xsl:value-of select="url"/>
                  <xsl:if test="string-length(var)>0">
                    <xsl:value-of select="concat(' [',var, ' parameter]')"/>
                  </xsl:if>
                </affects>
                <httpmethod status="new"><xsl:value-of select="method"/></httpmethod>
                <xsl:if test="string-length(cwe)>0">
                <cwe status="new"><xsl:value-of select="cwe"/>
                  <url status="new"><xsl:value-of select="cwe_url"/></url>
                </cwe>
                </xsl:if>
                <xsl:for-each select="references/reference">
                   <reference status="new"><xsl:value-of select="@name"/>
                      <url styatus="new"><xsl:value-of select="@url"/></url>
                   </reference>
                </xsl:for-each>
                <xsl:call-template name="convert-severity">
                   <xsl:with-param name="severity" select="severity"/>
                </xsl:call-template>
                <xsl:if test="string-length(remedy_guidance)>0">
                  <solution title="Solution" class="MtTextObject" status="new">
                    <xsl:value-of select="remedy_guidance"/>
                  </solution>
                </xsl:if>
                <xsl:if test="string-length(cvss_v2)>0">
                   <cvss_score status="new"><xsl:value-of select="cvss_v2"/></cvss_score>
                </xsl:if>
             </finding>
          </xsl:for-each>
       </webapp>
    </testdata> <!-- The end of the testdata -->
  </magictree> <!-- The end of the output MagicTree report -->    
</xsl:template>

    <xsl:template name="convert-severity">
        <xsl:param name="severity" />
        <source-severity status="new">
            <xsl:choose>
                <xsl:when test="lower-case($severity)='high'">
                    high<numeric>3</numeric>
                </xsl:when>
                <xsl:when test="lower-case($severity)='medium'">
                    medium<numeric>2</numeric>
                </xsl:when>
                <xsl:when test="lower-case($severity)='low'">
                    low<numeric>1</numeric>
                </xsl:when>
                <xsl:when test="lower-case($severity)='informational'">
                    info<numeric>0</numeric>
                </xsl:when>
                <xsl:otherwise>
                    unknown<numeric>-1</numeric>
                </xsl:otherwise>
            </xsl:choose>
        </source-severity>
    </xsl:template>

</xsl:stylesheet>
