﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- 
	Contributed by VienHa Tran
-->
<xsl:template name="appscan_severity">
	<xsl:param name="riskcode" />
  	<xsl:choose>
    		<xsl:when test="$riskcode='Low'">
			<source-severity status="new">low<numeric status="new">1</numeric></source-severity>
    		</xsl:when>
    		<xsl:when test="$riskcode='Medium'">
        		<source-severity status="new">medium<numeric status="new">2</numeric></source-severity>
    		</xsl:when>
    		<xsl:when test="$riskcode='High'">
        		<source-severity status="new">high<numeric status="new">3</numeric></source-severity>
    		</xsl:when>
    		<xsl:otherwise/>
  	</xsl:choose>
</xsl:template>

<xsl:template match="/">
	<!-- magictree root element -->
	<magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
	<!-- testdata element -->
	<testdata class="MtBranchObject">
	<!-- webapp element -->
	<xsl:for-each select="/XmlReport/Summary/Hosts/Host">>
	<webapp status="new"><xsl:value-of select="@Name"/>
		<xsl:variable name="host">
                        <xsl:value-of select="@Name"/>
                </xsl:variable>
 	<xsl:for-each select="/XmlReport/Results/Issues/Issue">
		<xsl:variable name="issueTypeId">
			<xsl:value-of select="@IssueTypeID"/>
           	</xsl:variable>
	<xsl:if test="starts-with(Url, $host)">
	<!-- url element -->
	<url status="new"><xsl:value-of select="Url" />
		<!-- finding element -->
		<finding class="MtTextObject" status="new">
			<!-- finding element title attribute -->
		        <xsl:attribute name="title">
				<xsl:value-of select="/XmlReport/Results/IssueTypes/IssueType[@ID=$issueTypeId]/advisory/name"/>
		        </xsl:attribute>
			<!-- finding element mergeID attribute -->
			<xsl:attribute name="mergeID" >
				<xsl:number value="position()" format="1"/>
			</xsl:attribute>
			<!-- finding element text -->
		    	<xsl:value-of select="/XmlReport/Results/IssueTypes/IssueType[@ID=$issueTypeId]/advisory/testTechnicalDescription" />
			<!-- source element -->
		    	<source status="new">appscan</source>
			<!-- affects element -->
		    	<xsl:variable name="affects">
				<xsl:value-of select="concat(Url, ' [', Entity/@Name, ' ', Entity/@Type,']')"/>
		    	</xsl:variable>
		    	<affects status="new"><xsl:value-of select="$affects" /></affects>
			<!-- severity element -->
			<xsl:call-template name="appscan_severity">
				<xsl:with-param name="riskcode" select="Severity"/>
			</xsl:call-template>
			<!-- solution element : only general solution-->
		    	<solution class="MtTextObject" title="Recommendation" status="new">
		        	<xsl:value-of select="/XmlReport/Results/IssueTypes/IssueType[@ID=$issueTypeId]/advisory/fixRecommendations/fixRecommendation[@type='General']" />
		    	</solution>
			<!-- reference element -->
		    	<xsl:for-each select="/XmlReport/Results/IssueTypes/IssueType[@ID=$issueTypeId]/advisory/references/link">
		    	<reference status="new"><xsl:value-of select="." /> 
		            <url status="new"><xsl:value-of select="@target" /></url>
		    	</reference>
		    	</xsl:for-each>
                        <xsl:for-each select="/XmlReport/Results/IssueTypes/IssueType[@ID=$issueTypeId]/advisory/cwe/link">
                        <reference status="new">CWE-<xsl:value-of select="." />
                            <url status="new"><xsl:value-of select="@target" /></url>
                        </reference>
                        </xsl:for-each>
		    	<id status="new"><xsl:value-of select="$issueTypeId" /></id>
		</finding>
	</url>
	</xsl:if>
	</xsl:for-each>
        </webapp>
        </xsl:for-each>
	</testdata>
    	</magictree>
</xsl:template>
</xsl:stylesheet>
