if [ -z "$id" ] ; then
        echo "UUID environment variable '\$id' is empty" >&2
        exit 1
fi

if [ -z "$prefix" ] ; then
        echo "Spool files environment variable '\$prefix' is empty" >&2
        exit 1
fi


## Check if the script has died already
if [ -r "$prefix..EXITCODE" ] ; then
	## exited already, do nothing
	exit 0
fi

## Check if the script was killed once already
if [ -r "$prefix..SCRIPT.KILLED" ] ; then
	## killed once already, don't do it again
	exit 0
fi

npidfilemisses=0
## Look for a pidfile
pidfile="$prefix..SCRIPT.PID"
while [ $npidfilemisses -lt 3 ] ; do
	if [ -r "$pidfile" ] ; then
		## Pidfile exists, kill the process
		kill `cat $pidfile`
		touch "$prefix..SCRIPT.KILLED"
		exit 0
	else
		##  Pidfile is missing, wait
		npidfilemisses=`expr $npidfilemisses + 1`
		sleep 1
	fi
done

## No pidfile
if [ -r "$prefix..SCRIPT" ] ; then
	## No scriptfile too
	## Probably we have got a bad UUID
	exit 100
else
	## Script exists, but perhaps it was never launched
	exit 101
fi

