/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.MainWindow;
import us.deathmarine.luyten.WindowPosition;

public class FindBox
extends JDialog {
    private static final long serialVersionUID = -4125409760166690462L;
    JCheckBox mcase;
    JCheckBox regex;
    JCheckBox wholew;
    JCheckBox reverse;
    JCheckBox wrap;
    private JButton findButton;
    JTextField textField;
    private MainWindow mainWindow;

    public void showFindBox() {
        this.setVisible(true);
        this.textField.requestFocus();
        this.textField.selectAll();
    }

    public void hideFindBox() {
        this.setVisible(false);
    }

    public FindBox(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.setDefaultCloseOperation(1);
        this.setHideOnEscapeButton();
        JLabel label = new JLabel("Find What:");
        this.textField = new JTextField();
        RSyntaxTextArea pane = mainWindow.getModel().getCurrentTextArea();
        if (pane != null) {
            this.textField.setText(pane.getSelectedText());
        }
        this.mcase = new JCheckBox("Match Case");
        this.regex = new JCheckBox("Regex");
        this.wholew = new JCheckBox("Whole Words");
        this.reverse = new JCheckBox("Search Backwards");
        this.wrap = new JCheckBox("Wrap");
        this.findButton = new JButton("Find");
        this.findButton.addActionListener(new FindButton());
        this.getRootPane().setDefaultButton(this.findButton);
        KeyStroke funcF3 = KeyStroke.getKeyStroke(114, 0, false);
        this.getRootPane().getInputMap(2).put(funcF3, "FindNext");
        this.getRootPane().getActionMap().put("FindNext", new FindExploreAction(true));
        KeyStroke sfuncF3 = KeyStroke.getKeyStroke(114, 64, false);
        this.getRootPane().getInputMap(2).put(sfuncF3, "FindPrevious");
        this.getRootPane().getActionMap().put("FindPrevious", new FindExploreAction(false));
        this.mcase.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.regex.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.wholew.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reverse.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.wrap.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension center = new Dimension((int)((double)screenSize.width * 0.35), Math.min((int)((double)screenSize.height * 0.2), 200));
        int x = (int)((double)center.width * 0.2);
        int y = (int)((double)center.height * 0.2);
        this.setBounds(x, y, center.width, center.height);
        this.setResizable(false);
        GroupLayout layout = new GroupLayout(this.getRootPane());
        this.getRootPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(label).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mcase).addComponent(this.wholew).addComponent(this.wrap)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.regex).addComponent(this.reverse)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.findButton)));
        layout.linkSize(0, this.findButton);
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.textField).addComponent(this.findButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mcase).addComponent(this.regex)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wholew).addComponent(this.reverse)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wrap)))));
        this.adjustWindowPositionBySavedState();
        this.setSaveWindowPositionOnClosing();
        this.setName("Find");
        this.setTitle("Find");
        this.setVisible(true);
    }

    private void setHideOnEscapeButton() {
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 5572504000935312338L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FindBox.this.setVisible(false);
            }
        };
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private void adjustWindowPositionBySavedState() {
        WindowPosition windowPosition = ConfigSaver.getLoadedInstance().getFindWindowPosition();
        if (windowPosition.isSavedWindowPositionValid()) {
            this.setLocation(windowPosition.getWindowX(), windowPosition.getWindowY());
        }
    }

    private void setSaveWindowPositionOnClosing() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                WindowPosition windowPosition = ConfigSaver.getLoadedInstance().getFindWindowPosition();
                windowPosition.readPositionFromDialog(FindBox.this);
            }
        });
    }

    public void fireExploreAction(boolean direction) {
        new FindExploreAction(direction).actionPerformed(null);
    }

    class FindExploreAction
    extends AbstractAction {
        private static final long serialVersionUID = -4391670062679240573L;
        boolean direction;

        public FindExploreAction(boolean forward) {
            this.direction = forward;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FindBox.this.textField.getText().length() == 0) {
                return;
            }
            RSyntaxTextArea pane = FindBox.this.mainWindow.getModel().getCurrentTextArea();
            if (pane == null) {
                return;
            }
            SearchContext context = new SearchContext();
            context.setSearchFor(FindBox.this.textField.getText());
            context.setMatchCase(FindBox.this.mcase.isSelected());
            context.setRegularExpression(FindBox.this.regex.isSelected());
            context.setSearchForward(this.direction);
            context.setWholeWord(FindBox.this.wholew.isSelected());
            if (!SearchEngine.find(pane, context).wasFound()) {
                if (FindBox.this.wrap.isSelected()) {
                    pane.setSelectionStart(0);
                    pane.setSelectionEnd(0);
                } else {
                    FindBox.this.mainWindow.getLabel().setText("Search Complete");
                }
            }
        }
    }

    private class FindButton
    extends AbstractAction {
        private static final long serialVersionUID = 75954129199541874L;

        private FindButton() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (FindBox.this.textField.getText().length() == 0) {
                return;
            }
            RSyntaxTextArea pane = FindBox.this.mainWindow.getModel().getCurrentTextArea();
            if (pane == null) {
                return;
            }
            SearchContext context = new SearchContext();
            context.setSearchFor(FindBox.this.textField.getText());
            context.setMatchCase(FindBox.this.mcase.isSelected());
            context.setRegularExpression(FindBox.this.regex.isSelected());
            context.setSearchForward(!FindBox.this.reverse.isSelected());
            context.setWholeWord(FindBox.this.wholew.isSelected());
            if (!SearchEngine.find(pane, context).wasFound()) {
                if (FindBox.this.wrap.isSelected()) {
                    pane.setSelectionStart(0);
                    pane.setSelectionEnd(0);
                } else {
                    FindBox.this.mainWindow.getLabel().setText("Search Complete");
                }
            }
        }
    }
}

