/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

final class ErasedMethod
extends MethodInfo {
    private final MethodInfo _baseMethod;
    private final Type<?> _declaringType;
    private final ParameterList _parameters;
    private final SignatureType _signatureType;
    private final TypeList _thrownTypes;
    private final TypeBindings _typeBindings;

    ErasedMethod(MethodInfo baseMethod, Type<?> declaringType, ParameterList parameters, Type<?> returnType, TypeList thrownTypes, TypeBindings typeBindings) {
        this._baseMethod = VerifyArgument.notNull(baseMethod, "baseMethod");
        this._declaringType = VerifyArgument.notNull(declaringType, "declaringType");
        this._parameters = VerifyArgument.notNull(parameters, "parameters");
        this._signatureType = new SignatureType(VerifyArgument.notNull(returnType, "returnType"), this._parameters.getParameterTypes());
        this._thrownTypes = VerifyArgument.notNull(thrownTypes, "thrownTypes");
        this._typeBindings = VerifyArgument.notNull(typeBindings, "typeBindings");
    }

    @Override
    public ParameterList getParameters() {
        return this._parameters;
    }

    @Override
    public Type<?> getReturnType() {
        return this._signatureType.getReturnType();
    }

    @Override
    public SignatureType getSignatureType() {
        return this._signatureType;
    }

    @Override
    public Method getRawMethod() {
        return this._baseMethod.getRawMethod();
    }

    @Override
    public String getName() {
        return this._baseMethod.getName();
    }

    @Override
    public Type getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public Type getReflectedType() {
        return this._baseMethod.getReflectedType();
    }

    @Override
    public TypeList getThrownTypes() {
        return this._thrownTypes;
    }

    @Override
    protected TypeBindings getTypeBindings() {
        return this._typeBindings;
    }

    @Override
    public int getModifiers() {
        return this._baseMethod.getModifiers();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._baseMethod.isAnnotationPresent(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._baseMethod.getDeclaredAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._baseMethod.getAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._baseMethod.getAnnotation(annotationClass);
    }

    @Override
    public boolean isEquivalentTo(MemberInfo m) {
        if (m == this) {
            return true;
        }
        if (m instanceof ErasedMethod) {
            ErasedMethod other = (ErasedMethod)m;
            if (other._declaringType == this._declaringType && other._baseMethod == this._baseMethod) {
                return true;
            }
        }
        return super.isEquivalentTo(m);
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return this._baseMethod.appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this._baseMethod.appendErasedSignature(sb);
    }
}

