/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.reflection.Error;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class ConstructorInfo
extends MethodBase {
    @Override
    public final MemberType getMemberType() {
        return MemberType.Constructor;
    }

    @Override
    public final String getName() {
        return "<init>";
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.getRawConstructor().getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this.getRawConstructor().getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this.getRawConstructor().getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getRawConstructor().isAnnotationPresent(annotationClass);
    }

    public abstract Constructor<?> getRawConstructor();

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        Constructor<?> rawConstructor = this.getRawConstructor();
        TypeList parameterTypes = Type.list(rawConstructor.getParameterTypes());
        StringBuilder s = sb;
        s.append('(');
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            s = ((Type)parameterTypes.get(i)).appendErasedSignature(s);
        }
        s.append(')');
        s = PrimitiveTypes.Void.appendErasedSignature(s);
        return s;
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        ParameterList parameters = this.getParameters();
        StringBuilder s = sb;
        s.append('(');
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            s = p.getParameterType().appendSignature(s);
        }
        s.append(')');
        s = PrimitiveTypes.Void.appendErasedSignature(s);
        return s;
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        Constructor<?> rawConstructor = this.getRawConstructor();
        TypeList parameterTypes = Type.list(rawConstructor.getParameterTypes());
        StringBuilder s = PrimitiveTypes.Void.appendBriefDescription(sb);
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s = ((Type)parameterTypes.get(i)).appendErasedDescription(s);
        }
        s.append(')');
        return s;
    }

    public Object invoke(Object ... args) {
        Constructor<?> rawConstructor = this.getRawConstructor();
        if (rawConstructor == null) {
            throw Error.rawMethodBindingFailure(this);
        }
        try {
            return rawConstructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw Error.targetInvocationException(e);
        }
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        StringBuilder s = PrimitiveTypes.Void.appendBriefDescription(sb);
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterList parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            if (i != 0) {
                s.append(", ");
            }
            s = p.getParameterType().appendBriefDescription(s);
        }
        s.append(')');
        TypeList thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                Type t = (Type)thrownTypes.get(i);
                if (i != 0) {
                    s.append(", ");
                }
                s = t.appendBriefDescription(s);
            }
        }
        return s;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        StringBuilder s = PrimitiveTypes.Void.appendSimpleDescription(sb);
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterList parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            if (i != 0) {
                s.append(", ");
            }
            s = p.getParameterType().appendSimpleDescription(s);
        }
        s.append(')');
        TypeList thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                Type t = (Type)thrownTypes.get(i);
                if (i != 0) {
                    s.append(", ");
                }
                s = t.appendSimpleDescription(s);
            }
        }
        return s;
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        StringBuilder s = PrimitiveTypes.Void.appendBriefDescription(sb);
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterList parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            Type<?> parameterType;
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            if (i != 0) {
                s.append(", ");
            }
            if ((parameterType = p.getParameterType()).isGenericParameter()) {
                s.append(parameterType.getName());
                continue;
            }
            s = parameterType.appendSimpleDescription(s);
        }
        s.append(')');
        return s;
    }

    @Override
    public boolean containsGenericParameter(Type<?> genericParameter) {
        return false;
    }
}

