/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.MemberExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.Type;

public final class UnaryExpression
extends Expression {
    private final Expression _operand;
    private final MethodInfo _method;
    private final ExpressionType _nodeType;
    private final Type _type;

    UnaryExpression(ExpressionType nodeType, Expression operand, Type type, MethodInfo method) {
        this._nodeType = nodeType;
        this._operand = operand;
        this._type = type;
        this._method = method;
    }

    public final Expression getOperand() {
        return this._operand;
    }

    public final MethodInfo getMethod() {
        return this._method;
    }

    @Override
    public final Type<?> getType() {
        return this._type;
    }

    @Override
    public final ExpressionType getNodeType() {
        return this._nodeType;
    }

    @Override
    protected final Expression accept(ExpressionVisitor visitor) {
        return visitor.visitUnary(this);
    }

    @Override
    public final boolean canReduce() {
        switch (this._nodeType) {
            case UnaryPlus: {
                return this._method == null;
            }
            case PreIncrementAssign: 
            case PreDecrementAssign: 
            case PostIncrementAssign: 
            case PostDecrementAssign: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final Expression reduce() {
        if (this.canReduce()) {
            if (this._nodeType == ExpressionType.UnaryPlus) {
                return this._operand;
            }
            switch (this._operand.getNodeType()) {
                case MemberAccess: {
                    return this.reduceMember();
                }
            }
            return this.reduceVariable();
        }
        return this;
    }

    private Expression reduceVariable() {
        if (this.isPrefix()) {
            return UnaryExpression.assign(this._operand, this.functionalOp(this._operand));
        }
        ParameterExpression temp = UnaryExpression.parameter(this._operand.getType());
        return UnaryExpression.block(this._type, new ParameterExpression[]{temp}, new Expression[]{UnaryExpression.assign(temp, this._operand), UnaryExpression.assign(this._operand, this.functionalOp(temp)), temp});
    }

    private Expression reduceMember() {
        MemberExpression member = (MemberExpression)this._operand;
        if (member.getTarget() == null) {
            return this.reduceVariable();
        }
        ParameterExpression temp1 = UnaryExpression.parameter(member.getTarget().getType(), null);
        BinaryExpression initTemp1 = UnaryExpression.assign(temp1, member.getTarget());
        member = UnaryExpression.makeMemberAccess(temp1, member.getMember());
        if (this.isPrefix()) {
            return UnaryExpression.block(new ParameterExpression[]{temp1}, new Expression[]{initTemp1, UnaryExpression.assign(member, this.functionalOp(member))});
        }
        ParameterExpression temp2 = UnaryExpression.parameter(member.getType(), null);
        return UnaryExpression.block(new ParameterExpression[]{temp1, temp2}, new Expression[]{initTemp1, UnaryExpression.assign(temp2, member), UnaryExpression.assign(member, this.functionalOp(temp2)), temp2});
    }

    private boolean isPrefix() {
        return this._nodeType == ExpressionType.PreIncrementAssign || this._nodeType == ExpressionType.PreDecrementAssign;
    }

    private UnaryExpression functionalOp(Expression operand) {
        ExpressionType functional = this._nodeType == ExpressionType.PreIncrementAssign || this._nodeType == ExpressionType.PostIncrementAssign ? ExpressionType.Increment : ExpressionType.Decrement;
        return new UnaryExpression(functional, operand, operand.getType(), this._method);
    }

    public final UnaryExpression update(Expression operand) {
        if (operand == this._operand) {
            return this;
        }
        return UnaryExpression.makeUnary(this._nodeType, operand, this._type, this._method);
    }
}

