/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.PrimitiveParameterExpression;
import com.strobel.expressions.TypedParameterExpression;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import java.util.Date;

public class ParameterExpression
extends Expression {
    private final String _name;

    ParameterExpression(String name) {
        this._name = name;
    }

    public final String getName() {
        return this._name;
    }

    @Override
    public Type<?> getType() {
        return Types.Object;
    }

    @Override
    public final ExpressionType getNodeType() {
        return ExpressionType.Parameter;
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitParameter(this);
    }

    static ParameterExpression make(Type type, String name) {
        if (!type.isEnum()) {
            if (type.isPrimitive()) {
                if (type == PrimitiveTypes.Boolean) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Boolean, name);
                }
                if (type == PrimitiveTypes.Byte) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Byte, name);
                }
                if (type == PrimitiveTypes.Character) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Character, name);
                }
                if (type == PrimitiveTypes.Float) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Float, name);
                }
                if (type == PrimitiveTypes.Double) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Double, name);
                }
                if (type == PrimitiveTypes.Short) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Short, name);
                }
                if (type == PrimitiveTypes.Integer) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Integer, name);
                }
                if (type == PrimitiveTypes.Long) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Long, name);
                }
                if (type == PrimitiveTypes.Float) {
                    return new PrimitiveParameterExpression(PrimitiveTypes.Float, name);
                }
            } else {
                if (type == Types.String) {
                    return new PrimitiveParameterExpression(Type.of(String.class), name);
                }
                if (type == Types.Date) {
                    return new PrimitiveParameterExpression(Type.of(Date.class), name);
                }
                if (type == Types.Object) {
                    return new PrimitiveParameterExpression(Types.Object, name);
                }
                if (type.isArray() && type.getElementType() == Types.Object) {
                    return new PrimitiveParameterExpression(type, name);
                }
                if (Type.of(Throwable.class).isAssignableFrom(type)) {
                    return new PrimitiveParameterExpression(type, name);
                }
            }
        }
        return new TypedParameterExpression(type, name);
    }
}

