/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.IArgumentProvider;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.Type;
import com.strobel.util.ContractUtils;

public class MethodCallExpression
extends Expression
implements IArgumentProvider {
    private final MethodInfo _method;

    MethodCallExpression(MethodInfo method) {
        this._method = method;
    }

    public final MethodInfo getMethod() {
        return this._method;
    }

    public Expression getTarget() {
        return null;
    }

    @Override
    public ExpressionType getNodeType() {
        return ExpressionType.Call;
    }

    @Override
    public Type<?> getType() {
        return this._method.getReturnType();
    }

    public final ExpressionList<? extends Expression> getArguments() {
        return this.getOrMakeArguments();
    }

    ExpressionList<? extends Expression> getOrMakeArguments() {
        throw ContractUtils.unreachable();
    }

    @Override
    public int getArgumentCount() {
        throw ContractUtils.unreachable();
    }

    @Override
    public Expression getArgument(int index) {
        throw ContractUtils.unreachable();
    }

    MethodCallExpression rewrite(Expression target, ExpressionList<? extends Expression> arguments) {
        throw ContractUtils.unreachable();
    }

    public MethodCallExpression update(Expression target, ExpressionList<? extends Expression> arguments) {
        if (target == this.getTarget() && arguments == this.getArguments()) {
            return this;
        }
        return MethodCallExpression.call(target, this.getMethod(), this.getArguments());
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitMethodCall(this);
    }
}

