/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.LabelInfo;
import com.strobel.expressions.LabelScopeKind;
import com.strobel.expressions.LabelTarget;
import java.util.HashMap;

final class LabelScopeInfo {
    private HashMap<LabelTarget, LabelInfo> labels;
    final LabelScopeKind kind;
    final LabelScopeInfo parent;

    LabelScopeInfo(LabelScopeInfo parent, LabelScopeKind kind) {
        this.parent = parent;
        this.kind = kind;
    }

    boolean canJumpInto() {
        switch (this.kind) {
            case Block: 
            case Statement: 
            case Switch: 
            case Lambda: {
                return true;
            }
        }
        return false;
    }

    boolean containsTarget(LabelTarget target) {
        return this.labels != null && this.labels.containsKey(target);
    }

    LabelInfo tryGetLabelInfo(LabelTarget target) {
        if (this.labels == null) {
            return null;
        }
        return this.labels.get(target);
    }

    void addLabelInfo(LabelTarget target, LabelInfo info) {
        assert (this.canJumpInto());
        if (this.labels == null) {
            this.labels = new HashMap();
        }
        this.labels.put(target, info);
    }
}

