/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler;

import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.ITextOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;

public class PlainTextOutput
implements ITextOutput {
    private static final String NULL_TEXT = String.valueOf((Object)null);
    private final Writer _writer;
    private String _indentToken = "    ";
    private int _indent;
    private boolean _needsIndent;
    private boolean _isUnicodeOutputEnabled;
    protected int line = 1;
    protected int column = 1;

    public PlainTextOutput() {
        this._writer = new StringWriter();
    }

    public PlainTextOutput(Writer writer) {
        this._writer = VerifyArgument.notNull(writer, "writer");
    }

    @Override
    public final String getIndentToken() {
        String indentToken = this._indentToken;
        return indentToken != null ? indentToken : "";
    }

    @Override
    public final void setIndentToken(String indentToken) {
        this._indentToken = indentToken;
    }

    public final boolean isUnicodeOutputEnabled() {
        return this._isUnicodeOutputEnabled;
    }

    public final void setUnicodeOutputEnabled(boolean unicodeOutputEnabled) {
        this._isUnicodeOutputEnabled = unicodeOutputEnabled;
    }

    protected void writeIndent() {
        if (this._needsIndent) {
            this._needsIndent = false;
            String indentToken = this.getIndentToken();
            for (int i = 0; i < this._indent; ++i) {
                try {
                    this._writer.write(indentToken);
                    continue;
                }
                catch (IOException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            this.column += indentToken.length() * this._indent;
        }
    }

    @Override
    public int getRow() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this._needsIndent ? this.column + this._indent * this.getIndentToken().length() : this.column;
    }

    @Override
    public void indent() {
        ++this._indent;
    }

    @Override
    public void unindent() {
        --this._indent;
    }

    @Override
    public void write(char ch) {
        this.writeIndent();
        try {
            if (this.isUnicodeOutputEnabled()) {
                this._writer.write(ch);
            } else {
                this._writer.write(StringUtilities.escape(ch));
            }
            ++this.column;
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(String text) {
        this.writeRaw(this.isUnicodeOutputEnabled() ? text : StringUtilities.escape(text));
    }

    protected void writeRaw(String text) {
        this.writeIndent();
        try {
            int length = text != null ? text.length() : NULL_TEXT.length();
            this._writer.write(text);
            this.column += length;
            if (text == null) {
                return;
            }
            boolean newLineSeen = false;
            for (int i = 0; i < length; ++i) {
                if (text.charAt(i) == '\n') {
                    ++this.line;
                    this.column = 0;
                    newLineSeen = true;
                    continue;
                }
                if (!newLineSeen) continue;
                ++this.column;
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void writeError(String value) {
        this.write(value);
    }

    @Override
    public void writeLabel(String value) {
        this.write(value);
    }

    @Override
    public void writeLiteral(Object value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void writeTextLiteral(Object value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void writeComment(String value) {
        this.write(value);
    }

    @Override
    public void writeComment(String format, Object ... args) {
        this.write(format, args);
    }

    @Override
    public void write(String format, Object ... args) {
        this.write(String.format(format, args));
    }

    @Override
    public void writeLine(String text) {
        this.write(text);
        this.writeLine();
    }

    @Override
    public void writeLine(String format, Object ... args) {
        this.write(String.format(format, args));
        this.writeLine();
    }

    @Override
    public void writeLine() {
        this.writeIndent();
        try {
            this._writer.write("\n");
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        this._needsIndent = true;
        ++this.line;
        this.column = 1;
    }

    @Override
    public void writeDelimiter(String text) {
        this.write(text);
    }

    @Override
    public void writeOperator(String text) {
        this.write(text);
    }

    @Override
    public void writeKeyword(String text) {
        this.write(text);
    }

    @Override
    public void writeAttribute(String text) {
        this.write(text);
    }

    @Override
    public void writeDefinition(String text, Object definition) {
        this.writeDefinition(text, definition, true);
    }

    @Override
    public void writeDefinition(String text, Object definition, boolean isLocal) {
        this.write(text);
    }

    @Override
    public void writeReference(String text, Object reference) {
        this.writeReference(text, reference, false);
    }

    @Override
    public void writeReference(String text, Object reference, boolean isLocal) {
        this.write(text);
    }

    @Override
    public boolean isFoldingSupported() {
        return false;
    }

    @Override
    public void markFoldStart(String collapsedText, boolean defaultCollapsed) {
    }

    @Override
    public void markFoldEnd() {
    }

    public String toString() {
        return this._writer.toString();
    }
}

