"use strict";
var chalk = require('chalk');
var escodegen = require('escodegen');
var _ = require('underscore');
var Leena = require('../../../src/back-end/leena');
var ChromeClient = require('../../../src/back-end/tester/chrome-tester-client');
var u = require('../../test-utils');
var leena = new Leena({
    hostname: 'localhost',
    port: 4004
});
var chromeClient = new ChromeClient({
    hostname: 'localhost',
    port: 4004
});
function testFunction(indexFunction, functionsToTest, leenaResponseObject, cb) {
    if (indexFunction < functionsToTest.length) {
        var fName = functionsToTest[indexFunction].functionName;
        var pFunc = functionsToTest[indexFunction].parameters;
        var nTestCases = functionsToTest[indexFunction].nTestCases;
        u.desc('    Testing ' + chalk.bgWhite.black(fName), function () {
            leena.inspect(fName, pFunc, function (res) {
                u.assert(res.hasOwnProperty('errors'), 'res must have property "errors"');
                u.assert(res.hasOwnProperty('testCases'), 'res must have property "testCases"');
                u.assert(res.hasOwnProperty('results'), 'res must have property "results"');
                u.assert(_.isArray(res.errors), '"res.errors" must be an array');
                u.assert(_.isArray(res.testCases), '"res.testCases" must be an array');
                u.assert(_.isArray(res.results), '"res.results" must be an array');
                if (res.errors.length !== 0) {
                    u.printError('"res.errors" must be an array with length equals to 0');
                    console.log(res.errors);
                    process.exit(1);
                }
                if (nTestCases !== undefined) {
                    u.assert(nTestCases === res.testCases.length, 'nTestCases !== res.testCases.length, (' + nTestCases + ' !== ' +
                        res.testCases.length + ')');
                }
                else {
                    console.log(res.testCases.length);
                }
                leenaResponseObject.push(JSON.stringify(res, null, 2));
                if (indexFunction < (functionsToTest.length - 1)) {
                    testFunction(++indexFunction, functionsToTest, leenaResponseObject, cb);
                }
                else {
                    cb();
                }
            });
        });
    }
}
exports.testFunction = testFunction;
function getSourceFunction(indexFunction, functions, fSources, cb) {
    if (indexFunction < functions.length) {
        var fName = functions[indexFunction].functionName;
        u.desc('    Get source of function ' + chalk.bgWhite.black(fName), function () {
            chromeClient.getFunctionInstance(fName, function (err, res) {
                if (err) {
                    u.printError(err.message);
                    cb();
                }
                else {
                    fSources.push(escodegen.generate(res.functionAST));
                    if (indexFunction < (functions.length - 1)) {
                        getSourceFunction(++indexFunction, functions, fSources, cb);
                    }
                    else {
                        cb();
                    }
                }
            });
        });
    }
}
exports.getSourceFunction = getSourceFunction;
