"use strict";
var CQ = require('coffeequate');
var esprima = require('esprima');
var Promise = require('bluebird');
var _ = require('underscore');
var mathOperations = {
    '<': function (a, b) { return a < b; },
    '<=': function (a, b) { return a <= b; },
    '>': function (a, b) { return a > b; },
    '>=': function (a, b) { return a >= b; },
    '+': function (a, b) { return a + b; },
    '-': function (a, b) { return a - b; },
    '*': function (a, b) { return a * b; },
    '/': function (a, b) { return a / b; }
};
function guessPreconditions(pc, gt, pathConstraint, stackBranch, executedConditions, M, S, cb) {
    var ctr;
    var indexPathConstraint;
    var g1;
    var pos;
    var indexesToRemove;
    var i;
    var promisesListMinFunction;
    var nPrePostConditions;
    nPrePostConditions = 0;
    for (var k = j; k >= 0; k--) {
        if (stackBranch[k].preOrPostCondition) {
            nPrePostConditions++;
        }
    }
    ctr = [];
    if (gt.entries.length >= 1) {
        g1 = gt.entries[0];
    }
    for (var k = 0; k < gt.entries.length; k++) {
        indexesToRemove = [];
        for (var j = 0; j < gt.entries[k].attr.pclocs.length; j++) {
            pos = gt.entries[k].attr.pclocs[j];
            if (pos !== g1.attr.loc) {
                indexesToRemove.push(pos);
            }
        }
        i = indexesToRemove.length;
        while (i--) {
            if (i >= pathConstraint.length || i >= stackBranch.length) {
                cb(new Error('Unable to guess preconditions. Index of path constraint to remove is out of range'), null);
            }
            stackBranch[indexesToRemove[i]].ignore = true;
        }
        ctr.push(gt.entries[k].attr.Dcond_S, gt.entries[k].attr.dDcond_S);
    }
    promisesListMinFunction = [];
    for (var k = 0; k < gt.entries.length; k++) {
        if (gt.entries[k].pc !== pc) {
            promisesListMinFunction.push(Promise.promisify(minPredicate)(k, false, gt, M, S));
        }
        else {
            promisesListMinFunction.push(Promise.promisify(minPredicate)(k, true, gt, M, S));
            break;
        }
    }
    Promise.all(promisesListMinFunction).then(function (results) {
        var minPred_k;
        for (var k = 0; k < results.length; k++) {
            minPred_k = results[k];
            if (minPred_k.length > 0) {
                process.exit();
                Array.prototype.push.apply(ctr, minPred_k);
            }
        }
        if (g1 === undefined || g1.attr.loc >= pathConstraint.length) {
            var errorMessageSuffix = (g1 === undefined)
                ? ' undefined'
                : ' out of range';
            cb(new Error('Unable to guess preconditions. Location of guard "G1"' + errorMessageSuffix), null);
        }
        else {
            var index;
            var nElementsToRemove;
            for (var k = 0; k < ctr.length; k++) {
                index = g1.attr.loc + k;
                nElementsToRemove = ~~(k === 0);
                if (k === 0) {
                    stackBranch[index].ignore = true;
                }
                pathConstraint.splice(++index, 0, ctr[k]);
                stackBranch.splice(++index, 0, {
                    branch: 0,
                    done: false,
                    M: _.clone(M),
                    S: _.clone(S),
                    preOrPostCondition: true,
                    ignore: false
                });
            }
            cb(null, executedConditions + ctr.length - 1);
        }
    }).catch(function (error) {
        cb(error, null);
    });
}
exports.guessPreconditions = guessPreconditions;
function minPredicate(indexEntry, valueCondition, gt, M, S, cb) {
    var minEntries;
    var minCandidates;
    var pcG_toInt;
    var pcGPrime_toInt;
    var opComparison;
    var astCondition;
    var condition;
    var promisesList;
    minEntries = [];
    minCandidates = [];
    promisesList = [];
    for (var k = 0; k < gt.entries.length; k++) {
        if (indexEntry !== k) {
            pcG_toInt = parseInt(gt[indexEntry].pc);
            pcGPrime_toInt = parseInt(gt[k].pc);
            opComparison = (pcG_toInt < pcGPrime_toInt)
                ? '<='
                : '<';
            try {
                condition = [
                    gt[indexEntry].attr.EC_S,
                    gt[k].attr.EC_S
                ].join(opComparison);
                astCondition = esprima.parse(condition);
                promisesList.push(Promise.promisify(evaluateConcrete)(astCondition, M, S));
                minCandidates.push(condition);
            }
            catch (e) {
                cb(new Error('Unable to get the AST for EC and EC_2'), null);
            }
        }
    }
    Promise.all(promisesList).then(function (results) {
        if (results.length !== gt.entries.length - 1) {
            cb(new Error('Unable to calculate "Min" predicate: different lengths between entries and executions'), null);
        }
        for (var k = 0; k < results.length; k++) {
            if (indexEntry !== k && results[k] === true) {
                minEntries.push(minCandidates[k]);
            }
        }
        cb(null, minEntries);
    }).catch(function (error) {
        cb(new Error('Unable to calculate "Min" predicate: ' + error.message), null);
    });
}
function guessPostconditions(iteration, ivt, gt, S) {
    for (var k = 0; k < gt.entries.length; k++) {
        if (gt.entries[k].attr.pending) {
            return;
        }
    }
    for (var k = 0; k < gt.entries.length; k++) {
        if (gt.entries[k].attr.EC === iteration) {
            for (var j = 0; j < ivt.entries.length; j++) {
                try {
                    symbolicUpdate(ivt.entries[j].name, ivt.entries[j].attr.V_S, ivt.entries[j].attr.dV_S, gt.entries[k].attr.EC_S, S);
                }
                catch (e) {
                    throw e;
                }
            }
            gt.entries[k].attr.pending = true;
            break;
        }
    }
}
exports.guessPostconditions = guessPostconditions;
function symbolicUpdate(v, V_0_S, dV_S, EC_S, S) {
    var V_S;
    var hasProperty_;
    var simplifiedExpressions;
    var simplifiedExpression;
    simplifiedExpressions = [V_0_S, dV_S, EC_S];
    for (var k = 0; k < simplifiedExpressions.length; k++) {
        try {
            simplifiedExpression = CQ(simplifiedExpressions[k]).simplify().toString();
            simplifiedExpressions[k] = simplifiedExpression;
        }
        catch (e) { }
    }
    V_S = '(' + simplifiedExpressions[0] + ') + (' + simplifiedExpressions[1] +
        ') * (' + '((' + simplifiedExpressions[2] + ') - 1))';
    hasProperty_ = S.hasProperty(v);
    if (!hasProperty_.hasProperty) {
        throw new Error('Unable to guess postconditions. Unable to find property "' + v + '" in the symbolic memory');
    }
    try {
        V_S = CQ(V_S).simplify().toString();
    }
    catch (e) {
    }
    finally {
        S.add(v, V_S);
    }
}
function evaluateConcrete(nodeAST, M, S, cb) {
    switch (nodeAST.type) {
        case 'ExpressionStatement':
            evaluateConcrete(nodeAST.expression, M, S, cb);
            break;
        case 'AssignmentExpression':
            var leftNode = nodeAST.left;
            var rightNode = nodeAST.right;
            if (leftNode.type === 'Identifier') {
                var varName = leftNode.name;
                var operator = nodeAST.operator;
                if (operator === '=') {
                    evaluateConcrete(rightNode, M, S, function (err, res) {
                        if (err) {
                            cb(err, null);
                        }
                        else {
                            cb(null, res);
                        }
                    });
                }
                else {
                    var realOperator = operator.substring(0, operator.length - 1);
                    evaluateConcrete(leftNode, M, S, function (errL, resL) {
                        if (errL) {
                            cb(errL, null);
                        }
                        else {
                            evaluateConcrete(rightNode, M, S, function (errR, resR) {
                                if (errR) {
                                    cb(errR, null);
                                }
                                else {
                                }
                            });
                        }
                    });
                }
            }
            break;
        case 'UnaryExpression':
            evaluateConcrete(nodeAST.argument, M, S, function (err, res) {
                if (err) {
                    cb(err, null);
                }
                else {
                    cb(null, nodeAST.operator + res);
                }
            });
            break;
        case 'BinaryExpression':
        case 'LogicalExpression':
            evaluateConcrete(nodeAST.left, M, S, function (errL, resL) {
                if (errL) {
                    cb(errL, null);
                }
                else {
                    evaluateConcrete(nodeAST.right, M, S, function (errR, resR) {
                        if (errR) {
                            cb(errR, null);
                        }
                        else {
                            try {
                                var resultExpression = op(resL, nodeAST.operator, resR);
                                cb(null, resultExpression);
                            }
                            catch (e) {
                                cb(e, null);
                            }
                        }
                    });
                }
            });
            break;
        case 'Identifier':
            var hasProperty_ = M.hasProperty(nodeAST.name);
            if (hasProperty_.hasProperty) {
                cb(null, hasProperty_.content);
            }
            else {
                cb(new Error('Unknown identifier in GT' + nodeAST.name), null);
            }
            break;
        case 'Literal':
            var value = (typeof nodeAST.value === 'string')
                ? '"' + nodeAST.value + '"'
                : nodeAST.value;
            cb(null, value);
            break;
        default:
            cb(new Error('Unknown in GT => "' + nodeAST + '"'), null);
    }
}
exports.evaluateConcrete = evaluateConcrete;
function op(leftOperand, operator, rightOperand) {
    if (mathOperations[operator] === undefined) {
        throw new Error('unable to apply the operator "' + operator + '" to solve the expression');
    }
    return mathOperations[operator](leftOperand, rightOperand);
}
exports.op = op;
