import unittest
from src.kernelpop import *

from exploits.linux.CVE20177308 import CVE20177308
from exploits.linux.CVE20171000379 import CVE20171000379
from exploits.linux.CVE20165195_32 import CVE20165195_32

class TestGetKernelVersion(unittest.TestCase):

	# def potentially_vulnerable(kernel_version, exploit_module):
	def test_new_kernel_not_vulnerable(self):
		test_uname = "Linux atlantic 4.9.0-4-amd64 #1 SMP Debian 4.9.65-3+deb9u1 (2017-12-23) x86_64 GNU/Linux"
		test_kernel = get_kernel_version(uname=test_uname)
		test_exploit = CVE20177308()
		exploit_results = potentially_vulnerable(test_kernel, test_exploit)
		self.assertEqual(NOT_VULNERABLE, exploit_results)

	# this is isn't returning any results, aha...right, because we have kernel version specificity, but we
	# 	don't have the distro type, so it's not matching.. we have to have that to match
	# (UPDATE: ) fixed by adding generic windows in 'vulnerable_kernels' that match a generic version kernel
	# 	with a version lower than the lowest fix version. The match identifier is BASE_VULNERABLE, so even though we
	# 	match with a specific kernel version, we get base-level vulnerability
	def test_dirty_cow(self):
		test_uname = "Linux debian 3.2.0-4-686-pae #1 SMP Debian 3.2.41-2 i686 GNU/Linux"
		test_kernel = get_kernel_version(uname=test_uname)
		test_exploit = CVE20165195_32(playground_path="/tmp/test")
		exploit_results = potentially_vulnerable(test_kernel, test_exploit)
		self.assertEqual(BASE_VULNERABLE, exploit_results)


	def test_should_be_vulnerable(self):
		test_uname = "Linux atlantic 4.11.16-4-amd64 #1 SMP Debian 4.11.65-3+deb9u1 (2017-12-23) x86_64 GNU/Linux"
		test_kernel = get_kernel_version(uname=test_uname)
		test_exploit = CVE20171000379()
		exploit_results = potentially_vulnerable(test_kernel, test_exploit)
		self.assertEqual(EXPLOIT_AVAILABLE, exploit_results)

	def test_new_kernel_no_found_exploits(self):
		test_uname = "Linux atlantic 4.9.0-4-amd64 #1 SMP Debian 4.9.65-3+deb9u1 (2017-12-23) x86_64 GNU/Linux"
		test_kernel = get_kernel_version(uname=test_uname)
		all_initialized_exploits = initialize_all_exploits("/tmp")
		exploit_results = find_exploit_locally(test_kernel, all_initialized_exploits)
		self.assertTrue(total_exploits(exploit_results) == 0)


if __name__ == "__main__":
	unittest.main()
