import unittest
from src.kernels import KernelWindow
from src.kernelpop import get_kernel_version
from constants import *


class TestGetKernelVersion(unittest.TestCase):

	# def potentially_vulnerable(kernel_version, exploit_module):
	def test_low_fail(self):
		test_uname = "Linux ubuntuexploit 4.10.0-37-generic #41~16.04.1-Ubuntu SMP Fri Oct 6 22:42:59 UTC 2017 " \
			"x86_64 x86_64 x86_64 GNU/Linux"
		test_kernel = get_kernel_version(uname=test_uname)
		test_window_low_fail = KernelWindow(UBUNTU_GENERIC, BASE_VULNERABLE, 4, 10, 1, 4, 99, 99)
		low_fail_status = test_window_low_fail.kernel_in_window(test_kernel.distro, test_kernel.base)
		self.assertEqual(low_fail_status, None)

	def test_high_fail(self):
		test_uname = "Linux ubuntuexploit 4.10.0-37-generic #41~16.04.1-Ubuntu SMP Fri Oct 6 22:42:59 UTC 2017 " \
					 "x86_64 x86_64 x86_64 GNU/Linux"
		test_kernel = get_kernel_version(uname=test_uname)
		test_window_high_fail = KernelWindow(UBUNTU_GENERIC, BASE_VULNERABLE, 4, 9, 0, 4, 9, 99)
		high_fail_status = test_window_high_fail.kernel_in_window(test_kernel.distro, test_kernel.base)
		self.assertEqual(high_fail_status, None)

	def test_base_vulnerable(self):
		test_uname = "Linux ubuntuexploit 4.10.0-37-generic #41~16.04.1-Ubuntu SMP Fri Oct 6 22:42:59 UTC 2017 " \
					 "x86_64 x86_64 x86_64 GNU/Linux"
		test_kernel = get_kernel_version(uname=test_uname)
		test_exact_window_pass = KernelWindow(UBUNTU_GENERIC, BASE_VULNERABLE, 4, 10, 0, 4, 10, 0)
		exact_pass_status = test_exact_window_pass.kernel_in_window(test_kernel.distro, test_kernel.base)
		self.assertEqual(exact_pass_status, BASE_VULNERABLE)


if __name__ == "__main__":
	unittest.main()
