// -*- c-basic-offset: 4; c-backslash-column: 79; indent-tabs-mode: nil -*-
// vim:sw=4 ts=4 sts=4 expandtab
#ifndef SKINNY_H_130515
#define SKINNY_H_130515
#include <junkie/proto/proto.h>

/** @file
 * @brief Skinny informations
 */

extern struct proto *proto_skinny;

enum skinny_header_version {
    SKINNY_BASIC,
    SKINNY_CM7_TYPE_A = 0x12,   // Names according to Wireshark
    SKINNY_CM7_TYPE_B = 0x11,
    SKINNY_CM7_TYPE_C = 0x14,
};

enum skinny_msgid {
    SKINNY_STATION_KEEPALIVE,
    SKINNY_STATION_REGISTER,
    SKINNY_STATION_IP_PORT,
    SKINNY_STATION_KEY_PAD_BUTTON,
    SKINNY_STATION_ENBLOC_CALL,
    SKINNY_STATION_STIMULUS,
    SKINNY_STATION_OFF_HOOK,
    SKINNY_STATION_ON_HOOK,
    SKINNY_STATION_HOOK_FLASH,
    SKINNY_STATION_FORWARD_STATUS_REQ,
    SKINNY_STATION_SPEED_DIAL_STATUS_REQ,
    SKINNY_STATION_LINE_STATUS_REQ,
    SKINNY_STATION_CONFIGURATION_STATUS_REQ,
    SKINNY_STATION_TIME_DATE_REQ,
    SKINNY_STATION_BUTTON_TEMPLATE_REQ,
    SKINNY_STATION_VERSION_REQ,
    SKINNY_STATION_CAPABILITIES_RESP = 0x0010,
    SKINNY_STATION_MEDIA_PORT_LIST = 0x0011,
    SKINNY_STATION_SERVER_REQ = 0x0012,
    SKINNY_STATION_ALARM = 0x0020,
    SKINNY_STATION_MULTICAST_MEDIA_RECEPT_ACK = 0x0021,
    SKINNY_STATION_OFF_HOOK_WITH_CALLING_PARTY_NUMBER = 0x0024,
    SKINNY_STATION_OPEN_RECV_CHANNEL_ACK = 0x0022,
    SKINNY_STATION_CONNECTION_STATISTICS_RESP = 0x0023,
    SKINNY_STATION_SOFT_KEY_TEMPLATE_REQ = 0x0025,
    SKINNY_STATION_SOFT_KEY_SET_REQ = 0x0026,
    SKINNY_STATION_SOFT_KEY_EVENT = 0x0027,
    SKINNY_STATION_UNREGISTER = 0x0028,
    SKINNY_STATION_REGISTER_TOKEN_REQ = 0x0029,
    SKINNY_STATION_MEDIA_TRANSMIT_FAILURE = 0x002A,
    SKINNY_STATION_HEADSET_STATUS = 0x002B,
    SKINNY_STATION_MEDIA_RESOURCE_NOTIF = 0x002C,
    SKINNY_STATION_REGISTER_AVAILABLE_LINES = 0x002D,
    SKINNY_STATION_DEVICE_TO_USER_DATA = 0x002E,
    SKINNY_STATION_DEVICE_TO_USER_DATA_RESP = 0x002F,
    SKINNY_STATION_UPDATE_CAPABILITIES = 0x0030,
    SKINNY_STATION_OPEN_MULTIMEDIA_RECV_CHANNEL_ACK = 0x0031,
    SKINNY_STATION_CLEAR_CONFERENCE = 0x0032,
    SKINNY_STATION_SERVICE_URLSTAT_REQ = 0x0033,
    SKINNY_STATION_FEATURE_STAT_REQ = 0x0034,
    SKINNY_STATION_CREATE_CONFERENCE_RES = 0x0035,
    SKINNY_STATION_DELETE_CONFERENCE_RES = 0x0036,
    SKINNY_STATION_MODIFY_CONFERENCE_RES = 0x0037,
    SKINNY_STATION_ADD_PARTICIPANT_RES = 0x0038,
    SKINNY_STATION_AUDIT_CONFERENCE_RES = 0x0039,
    SKINNY_STATION_AUDIT_PARTICIPANT_RES = 0x0040,
    SKINNY_STATION_DEVICE_TO_USER_DATA_VERSION1 = 0x0041,
    SKINNY_STATION_DEVICE_TO_USER_DATA_RESP_VERSION1 = 0x0042,
    SKINNY_STATION_DIALED_PHONE_BOOK = 0x0048,
    SKINNY_MGR_KEEPALIVE = 0x0081,
    SKINNY_MGR_START_TONE = 0x0082,
    SKINNY_MGR_STOP_TONE = 0x0083,
    SKINNY_MGR_SET_RINGER = 0x0085,
    SKINNY_MGR_SET_LAMP = 0x0086,
    SKINNY_MGR_SET_HOOK_FLASH_DETECT = 0x0087,
    SKINNY_MGR_SET_SPEAKER_MODE = 0x0088,
    SKINNY_MGR_SET_MICROPHONE_MODE = 0x0089,
    SKINNY_MGR_START_MEDIA_TRANSMIT = 0x008A,
    SKINNY_MGR_STOP_MEDIA_TRANSMIT = 0x008B,
    SKINNY_MGR_START_MEDIA_RECEPTION = 0x008C,
    SKINNY_MGR_STOP_MEDIA_RECEPTION = 0x008D,
    SKINNY_MGR_CALL_INFORMATION = 0x008F,
    SKINNY_MGR_FORWARD_STATUS = 0x0090,
    SKINNY_MGR_SPEED_DIAL_STATUS = 0x0091,
    SKINNY_MGR_LINE_STATUS = 0x0092,
    SKINNY_MGR_CONFIGURATION_STATUS = 0x0093,
    SKINNY_MGR_DEFINE_TIME_N_DATE = 0x0094,
    SKINNY_MGR_START_SESSION_TRANSMIT = 0x0095,
    SKINNY_MGR_STOP_SESSION_TRANSMIT = 0x0096,
    SKINNY_MGR_BUTTON_TEMPLATE = 0x0097,
    SKINNY_MGR_VERSION = 0x0098,
    SKINNY_MGR_DISPLAY_TEXT = 0x0099,
    SKINNY_MGR_CLEAR_DISPLAY = 0x009A,
    SKINNY_MGR_CAPABILITIES_REQ = 0x009B,
    SKINNY_MGR_ENUNCIATOR_COMMAND = 0x009C,
    SKINNY_MGR_REGISTER_REJECT = 0x009D,
    SKINNY_MGR_SERVER_RESP = 0x009E,
    SKINNY_MGR_RESET = 0x009F,
    SKINNY_MGR_KEEPALIVE_ACK = 0x0100,
    SKINNY_MGR_START_MULTICAST_MEDIA_RECEPT = 0x0101,
    SKINNY_MGR_START_MULTICAST_MEDIA_TRANSMIT = 0x0102,
    SKINNY_MGR_STOP_MULTICAST_MEDIA_RECEPT = 0x0103,
    SKINNY_MGR_STOP_MULTICAST_MEDIA_TRANSMIT = 0x0104,
    SKINNY_MGR_OPEN_RECV_CHANNEL = 0x0105,
    SKINNY_MGR_CLOSE_RECV_CHANNEL = 0x0106,
    SKINNY_MGR_CONNECTION_STATISTICS_REQ = 0x0107,
    SKINNY_MGR_SOFT_KEY_TEMPLATE_RESP = 0x0108,
    SKINNY_MGR_SOFT_KEY_SET_RESP = 0x0109,
    SKINNY_MGR_SELECT_SOFT_KEYS = 0x0110,
    SKINNY_MGR_CALL_STATE = 0x0111,
    SKINNY_MGR_DISPLAY_PROMPT = 0x0112,
    SKINNY_MGR_CLEAR_PROMPT = 0x0113,
    SKINNY_MGR_DISPLAY_NOTIFY = 0x0114,
    SKINNY_MGR_CLEAR_NOTIFY = 0x0115,
    SKINNY_MGR_ACTIVATE_CALL_PLANE = 0x0116,
    SKINNY_MGR_DEACTIVATE_CALL_PLANE = 0x0117,
    SKINNY_MGR_UNREGISTER_ACK = 0x0118,
    SKINNY_MGR_BACK_SPACE_REQ = 0x0119,
    SKINNY_MGR_REGISTER_TOKEN_ACK = 0x011A,
    SKINNY_MGR_REGISTER_TOKEN_REJECT = 0x011B,
    SKINNY_MGR_START_MEDIA_FAILURE_DETECTION = 0x011C,
    SKINNY_MGR_DIALED_NUMBER = 0x011D,
    SKINNY_MGR_USER_TO_DEVICE_DATA = 0x011E,
    SKINNY_MGR_FEATURE_STAT = 0x011F,
    SKINNY_MGR_DISPLAY_PRI_NOTIFY = 0x0120,
    SKINNY_MGR_CLEAR_PRI_NOTIFY = 0x0121,
    SKINNY_MGR_START_ANNOUNCE = 0x0122,
    SKINNY_MGR_STOP_ANNOUNCE = 0x0123,
    SKINNY_MGR_ANNOUNCE_FINISH = 0x0124,
    SKINNY_MGR_NOTIFY_DTMF_TONE = 0x0127,
    SKINNY_MGR_SEND_DTMF_TONE = 0x0128,
    SKINNY_MGR_SUBSCRIBE_DTMF_PAYLOAD_REQ = 0x0129,
    SKINNY_MGR_SUBSCRIBE_DTMF_PAYLOAD_RES = 0x012A,
    SKINNY_MGR_SUBSCRIBE_DTMF_PAYLOAD_ERR = 0x012B,
    SKINNY_MGR_UNSUBSCRIBE_DTMF_PAYLOAD_REQ = 0x012C,
    SKINNY_MGR_UNSUBSCRIBE_DTMF_PAYLOAD_RES = 0x012D,
    SKINNY_MGR_UNSUBSCRIBE_DTMF_PAYLOAD_ERR = 0x012E,
    SKINNY_MGR_SERVICE_URLSTAT = 0x012F,
    SKINNY_MGR_CALL_SELECT_STAT = 0x0130,
    SKINNY_MGR_OPEN_MULTIMEDIA_CHANNEL = 0x0131,
    SKINNY_MGR_START_MULTIMEDIA_TRANSMIT = 0x0132,
    SKINNY_MGR_STOP_MULTIMEDIA_TRANSMIT = 0x0133,
    SKINNY_MGR_MISCELLANEOUS_COMMAND = 0x0134,
    SKINNY_MGR_FLOW_CONTROL_COMMAND = 0x0135,
    SKINNY_MGR_CLOSE_MULTIMEDIA_RECV_CHANNEL = 0x0136,
    SKINNY_MGR_CREATE_CONFERENCE_REQ = 0x0137,
    SKINNY_MGR_DELETE_CONFERENCE_REQ = 0x0138,
    SKINNY_MGR_MODIFY_CONFERENCE_REQ = 0x0139,
    SKINNY_MGR_ADD_PARTICIPANT_REQ = 0x013A,
    SKINNY_MGR_DROP_PARTICIPANT_REQ = 0x013B,
    SKINNY_MGR_AUDIT_CONFERENCE_REQ = 0x013C,
    SKINNY_MGR_AUDIT_PARTICIPANT_REQ = 0x013D,
    SKINNY_MGR_USER_TO_DEVICE_DATA_VERSION1 = 0x013F,
    SKINNY_MGR_CALL_INFO = 0x014A,
    SKINNY_MGR_DIALED_PHONE_BOOK_ACK = 0x0152,
    SKINNY_MGR_XMLALARM = 0x015A,
};

enum skinny_call_state {
    SKINNY_OFF_HOOK = 1,
    SKINNY_ON_HOOK,
    SKINNY_RING_OUT,
    SKINNY_RING_IN,
    SKINNY_CONNECTED,
    SKINNY_BUSY,
    SKINNY_CONGESTION,
    SKINNY_HOLD,
    SKINNY_CALL_WAITING,
    SKINNY_CALL_TRANSFER,
    SKINNY_CALL_PARK,
    SKINNY_PROCEED,
    SKINNY_REMOTE_MULTILINE,
    SKINNY_INVALID_NUMBER,
};

/// SKINNY message
struct skinny_proto_info {
    struct proto_info info;
    enum skinny_msgid msgid;
    enum skinny_header_version header_ver;
#   define SKINNY_NEW_KEY_PAD   0x0001
#   define SKINNY_LINE_INSTANCE 0x0002
#   define SKINNY_CALL_ID       0x0004
#   define SKINNY_CALL_STATE    0x0008
#   define SKINNY_CONFERENCE_ID 0x0010
#   define SKINNY_PASS_THRU_ID  0x0020
#   define SKINNY_MEDIA_CNX     0x0040
#   define SKINNY_CALLED_PARTY  0x0080
#   define SKINNY_CALLING_PARTY 0x0100
    unsigned set_values;
    uint32_t new_key_pad;
    uint32_t line_instance;
    uint32_t call_id;
    uint32_t conf_id;
    uint32_t pass_thru_id;
    struct ip_addr media_ip;    // if SKINNY_MEDIA_CNX
    uint16_t media_port;        // if SKINNY_MEDIA_CNX
    enum skinny_call_state call_state;
#   define DIALED_NUMBER_SIZE 24
    char called_party[DIALED_NUMBER_SIZE+1];
    char calling_party[DIALED_NUMBER_SIZE+1];
};

void skinny_init(void);
void skinny_fini(void);

#endif
