/*
  Copyright (C) 2012 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*global module:true*/
(function () {
    'use strict';

    var Map;

    if (typeof global.Map !== 'undefined') {
        // ES6 Map
        Map = global.Map;
    } else {
        Map = function Map() {
            this.__data = {};
        };

        Map.prototype.get = function MapGet(key) {
            key = '$' + key;
            if (this.__data.hasOwnProperty(key)) {
                return this.__data[key];
            }
        };

        Map.prototype.has = function MapHas(key) {
            key = '$' + key;
            return this.__data.hasOwnProperty(key);
        };

        Map.prototype.set = function MapSet(key, val) {
            key = '$' + key;
            this.__data[key] = val;
        };

        Map.prototype['delete'] = function MapDelete(key) {
            key = '$' + key;
            return delete this.__data[key];
        };

        Map.prototype.clear = function MapClear() {
            this.__data = {};
        };

        Map.prototype.forEach = function MapForEach(callback, thisArg) {
            var real, key;
            for (real in this.__data) {
                if (this.__data.hasOwnProperty(real)) {
                    key = real.substring(1);
                    callback.call(thisArg, this.__data[real], key, this);
                }
            }
        };

        Map.prototype.keys = function MapKeys() {
            var real, result;
            result = [];
            for (real in this.__data) {
                if (this.__data.hasOwnProperty(real)) {
                    result.push(real.substring(1));
                }
            }
            return result;
        };

        Map.prototype.values = function MapValues() {
            var real, result;
            result = [];
            for (real in this.__data) {
                if (this.__data.hasOwnProperty(real)) {
                    result.push(this.__data[real]);
                }
            }
            return result;
        };

        Map.prototype.items = function MapItems() {
            var real, result;
            result = [];
            for (real in this.__data) {
                if (this.__data.hasOwnProperty(real)) {
                    result.push([real.substring(1), this.__data[real]]);
                }
            }
            return result;
        };
    }

    module.exports = Map;
}());
/* vim: set sw=4 ts=4 et tw=80 : */
