/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.image.SunVolatileImage;

public abstract class GraphicsConfiguration {
    private static BufferCapabilities defaultBufferCaps;
    private static ImageCapabilities defaultImageCaps;

    protected GraphicsConfiguration() {
    }

    public abstract GraphicsDevice getDevice();

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        if (this.getColorModel().getTransparency() == n3) {
            return this.createCompatibleImage(n, n2);
        }
        ColorModel colorModel = this.getColorModel(n3);
        if (colorModel == null) {
            throw new IllegalArgumentException("Unknown transparency: " + n3);
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2) {
        VolatileImage volatileImage;
        block2: {
            volatileImage = null;
            try {
                volatileImage = this.createCompatibleVolatileImage(n, n2, null, 1);
            }
            catch (AWTException aWTException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return volatileImage;
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3) {
        VolatileImage volatileImage;
        block2: {
            volatileImage = null;
            try {
                volatileImage = this.createCompatibleVolatileImage(n, n2, null, n3);
            }
            catch (AWTException aWTException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return volatileImage;
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, ImageCapabilities imageCapabilities) throws AWTException {
        return this.createCompatibleVolatileImage(n, n2, imageCapabilities, 1);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, ImageCapabilities imageCapabilities, int n3) throws AWTException {
        SunVolatileImage sunVolatileImage = new SunVolatileImage(this, n, n2, n3, imageCapabilities);
        if (imageCapabilities != null && imageCapabilities.isAccelerated() && !((VolatileImage)sunVolatileImage).getCapabilities().isAccelerated()) {
            throw new AWTException("Supplied image capabilities could not be met by this graphics configuration.");
        }
        return sunVolatileImage;
    }

    public abstract ColorModel getColorModel();

    public abstract ColorModel getColorModel(int var1);

    public abstract AffineTransform getDefaultTransform();

    public abstract AffineTransform getNormalizingTransform();

    public abstract Rectangle getBounds();

    public BufferCapabilities getBufferCapabilities() {
        if (defaultBufferCaps == null) {
            defaultBufferCaps = new DefaultBufferCapabilities(this.getImageCapabilities());
        }
        return defaultBufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        if (defaultImageCaps == null) {
            defaultImageCaps = new ImageCapabilities(false);
        }
        return defaultImageCaps;
    }

    public boolean isTranslucencyCapable() {
        return false;
    }

    private static class DefaultBufferCapabilities
    extends BufferCapabilities {
        public DefaultBufferCapabilities(ImageCapabilities imageCapabilities) {
            super(imageCapabilities, imageCapabilities, null);
        }
    }
}

