/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.SpecialAlgorithm;

public class MSSQL2000
implements SpecialAlgorithm {
    private MessageDigest m = null;

    public MSSQL2000() {
        try {
            this.m = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toHash(byte[] b) {
        return "0x" + DatatypeConverter.printHexBinary((byte[])b);
    }

    @Override
    public String crypt(String password, String salt) {
        byte[] salt1 = null;
        if (salt == null) {
            salt1 = new byte[4];
            new Random().nextBytes(salt1);
        }
        return this.toHash(this.cryptPerf(password.getBytes(), salt1));
    }

    public byte[] crypt(byte[] password, byte[] salt) {
        return this.cryptPerf(password, salt);
    }

    @Override
    public byte[] cryptPerf(byte[] password, byte[] salt) {
        byte[] bhash = null;
        byte[] bpasswordLower = ByteArray.toUTF16LE(password);
        byte[] bpasswordUpper = ByteArray.toUTF16LE(ByteArray.toUpperCase(password));
        bpasswordLower = ByteArray.concat(bpasswordLower, salt);
        bpasswordUpper = ByteArray.concat(bpasswordUpper, salt);
        this.m.update(bpasswordLower);
        byte[] bhashIntermediate = this.m.digest();
        this.m.update(bpasswordUpper);
        bhashIntermediate = ByteArray.concat(bhashIntermediate, this.m.digest());
        bhash = new byte[]{1, 0};
        bhash = ByteArray.concat(bhash, salt);
        bhash = ByteArray.concat(bhash, bhashIntermediate);
        return bhash;
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        byte[] salt = new byte[4];
        int auxIndex = 0;
        int i = 2;
        while (i < 6) {
            salt[auxIndex] = hash[i];
            ++auxIndex;
            ++i;
        }
        return salt;
    }

    @Override
    public byte[] appendSaltToWord(byte[] word, byte[] salt) {
        return ByteArray.concat(word, salt);
    }

    @Override
    public byte[] toByteArray(String hash) {
        int separatorPos = hash.indexOf(120);
        String hexHash = hash.substring(separatorPos + 1, hash.length());
        return DatatypeConverter.parseHexBinary((String)hexHash);
    }
}

