/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;

public class Cisco5 {
    private MessageDigest m = null;

    public Cisco5() {
        try {
            this.m = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static final String crypt(String password) {
        byte[] b = new byte[10];
        new Random().nextBytes(b);
        String salt = DatatypeConverter.printHexBinary((byte[])b);
        return Cisco5.crypt(password, salt);
    }

    private static final String bytes2Utf8(byte[] ba) {
        try {
            return new String(ba, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String toHash(byte[] b) {
        return DatatypeConverter.printHexBinary((byte[])b).toLowerCase();
    }

    public static final String crypt(String password, String salt) {
        return Cisco5.toHash(Cisco5.crypt(password.getBytes(), DatatypeConverter.parseHexBinary((String)salt)));
    }

    private static byte[] prepare(byte[] password) {
        byte[] result = null;
        int fixedSize = 510;
        try {
            result = Cisco5.bytes2Utf8(password).getBytes("UTF-16BE");
            if (result.length < fixedSize) {
                byte[] bpadding = new byte[fixedSize - result.length];
                result = ByteArray.concat(result, bpadding);
            } else if (result.length > fixedSize) {
                result = ByteArray.truncate(result, 510);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static final byte[] crypt(byte[] password, byte[] salt) {
        byte[] bpassword = Cisco5.prepare(password);
        bpassword = ByteArray.concat(bpassword, salt);
        byte[] output = null;
        try {
            MessageDigest m1 = MessageDigest.getInstance("SHA-256");
            if (bpassword.length < 518) {
                System.err.println("[Sysbase1502.crypt]prepared password has length < 518 bytes");
            }
            m1.update(bpassword);
            output = new byte[]{-64, 7};
            output = ByteArray.concat(output, salt);
            output = ByteArray.concat(output, m1.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return output;
    }

    public byte[] cryptPerf(byte[] password, byte[] salt) {
        byte[] bpassword = Cisco5.prepare(password);
        if ((bpassword = ByteArray.concat(bpassword, salt)).length < 518) {
            System.err.println("[Sysbase1502.crypt]prepared password has length < 518 bytes");
        }
        this.m.update(bpassword);
        byte[] output = new byte[]{-64, 7};
        output = ByteArray.concat(output, salt);
        output = ByteArray.concat(output, this.m.digest());
        return output;
    }

    public static final byte[] toByteArray(String hash) {
        return DatatypeConverter.parseHexBinary((String)hash);
    }

    private static byte[] getSaltFromHash(byte[] hash) {
        return ByteArray.getSubArray(hash, 2, 9);
    }

    public static byte[] appendSaltToWord(byte[] word, byte[] hash) {
        return ByteArray.concat(Cisco5.getSaltFromHash(hash), word);
    }
}

