/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.AuxiliaryForDecryptThreads;
import entities.AvailableAlgorithms;
import entities.AvailableCharsets;
import entities.HashEntry;
import entities.JBruteThread;
import entities.ProcessResult;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.MyMessageDigest;

public class MyBruteDecryptThread
extends JBruteThread {
    private String mensaje;
    private int longDesde;
    private int longHasta;
    private String firstCombination;
    private String lastCombination;
    private String alphabet;
    private ProcessResult resultado;
    private boolean testMode = false;
    private int numberOfHashes = 1;
    private boolean withSalt = false;

    public MyBruteDecryptThread(String msg, String alphabet, int desde, int hasta, ProcessResult pr) {
        this.mensaje = msg;
        this.longDesde = desde;
        this.longHasta = hasta;
        this.alphabet = alphabet;
        this.resultado = pr;
    }

    public MyBruteDecryptThread(String msg, String alphabet, ProcessResult pr) {
        this.mensaje = msg;
        this.resultado = pr;
        this.alphabet = alphabet;
    }

    public MyBruteDecryptThread(String msg, String alphabet, String firstCombination2, String lastCombination2, ProcessResult pr) {
        this.mensaje = msg;
        this.firstCombination = firstCombination2;
        this.lastCombination = lastCombination2;
        this.resultado = pr;
        this.alphabet = alphabet;
    }

    public MyBruteDecryptThread(boolean testMode, ProcessResult pr, int numberOfHashes, boolean withSalt) {
        this.testMode = testMode;
        this.resultado = pr;
        this.numberOfHashes = numberOfHashes;
        this.withSalt = withSalt;
    }

    public String getMensaje() {
        return this.mensaje;
    }

    public void setMensaje(String msj) {
        this.mensaje = msj;
    }

    public int getLongDesde() {
        return this.longDesde;
    }

    public void setLongDesde(int longDesde) {
        this.longDesde = longDesde;
    }

    public int getLongHasta() {
        return this.longHasta;
    }

    public void setLongHasta(int longHasta) {
        this.longHasta = longHasta;
    }

    public String getFirstCombination() {
        return this.firstCombination;
    }

    public void setFirstCombination(String firstCombination) {
        this.firstCombination = firstCombination;
    }

    public String getLastCombination() {
        return this.lastCombination;
    }

    public void setLastCombination(String lastCombination) {
        this.lastCombination = lastCombination;
    }

    @Override
    public void run() {
        if (this.testMode) {
            if (this.resultado.isChainedHash()) {
                this.testBruteForceChained();
            } else {
                int algorithm = AvailableAlgorithms.getAlgorithmCodeFromInput(this.resultado.getAlgorithmCodes());
                if (AvailableAlgorithms.isHashedSpecialAlgorithm(algorithm)) {
                    this.testBruteForceSpecial();
                } else {
                    this.testBruteForce();
                }
            }
        } else {
            this.resultado.validateEncryptedHashes();
            if (this.resultado.getPendingEncryptedHashes().size() == 0) {
                System.err.println();
                System.err.println("There are no valid hashes to decrypt!!!");
                System.err.println();
                return;
            }
            if (this.resultado.isChainedHash()) {
                this.decryptBruteForceChained();
            } else {
                int algorithm = AvailableAlgorithms.getAlgorithmCodeFromInput(this.resultado.getAlgorithmCodes());
                if (AvailableAlgorithms.isHashedSpecialAlgorithm(algorithm)) {
                    this.decryptBruteForceSpecialAlgorithm();
                } else {
                    this.decryptBruteForce();
                }
            }
        }
    }

    private void testBruteForce() {
        this.firstCombination = "aaaaaaaa";
        this.lastCombination = "99999999";
        boolean useSalt = this.withSalt;
        byte[] lastCombinationByte = this.lastCombination.getBytes();
        byte[] result = this.firstCombination.getBytes();
        this.alphabet = AvailableCharsets.getCharsetByName("loweralpha-numeric");
        int algorithmCode = AvailableAlgorithms.getAlgorithmCodeFromInput(this.resultado.getAlgorithmCodes());
        MessageDigest m = null;
        m = AvailableAlgorithms.getMessageDigest(algorithmCode);
        String auxHashToDecrypt = new String("alagrandelepusecuca");
        byte[] hashToDecrypt = auxHashToDecrypt.getBytes();
        m.update(hashToDecrypt, 0, hashToDecrypt.length);
        hashToDecrypt = m.digest();
        String hashPrintable = AvailableAlgorithms.getLowerCaseHash(hashToDecrypt);
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        boolean[] preSaltList = new boolean[this.numberOfHashes];
        byte[] aux = null;
        byte[] resultSalt = null;
        int i = 0;
        while (i < this.numberOfHashes) {
            HashEntry he = new HashEntry();
            he.setHash(hashPrintable);
            if (this.withSalt) {
                he.setPreSalt(AuxiliaryForDecryptThreads.getRandomString(8));
            } else {
                he.setPreSalt(null);
            }
            byteList.add(DatatypeConverter.parseHexBinary((String)he.getHash()));
            saltList.add(AvailableAlgorithms.getSaltByteArray(he.getSalt(), he.getSaltType()));
            preSaltList[i] = true;
            ++i;
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int auxIndex = 0;
        int myEndTime = this.resultado.getTestTime() * 1000;
        int cantEntrys = byteList.size();
        while (!Arrays.equals(result, lastCombinationByte)) {
            byte[] elem;
            int i2;
            if (this.isSomethingDifferent()) {
                useSalt = false;
                byteList.clear();
                saltList.clear();
                preSaltList = new boolean[this.resultado.getPendingEncryptedHashes().size()];
                auxIndex = 0;
                for (HashEntry entry : this.resultado.getPendingEncryptedHashes()) {
                    byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
                    byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
                    if (auxSalt != null) {
                        useSalt = true;
                    }
                    saltList.add(auxSalt);
                    preSaltList[auxIndex] = entry.isPreSalt();
                    ++auxIndex;
                }
                cantEntrys = byteList.size();
                this.setSomethingDifferent(false);
                if (this.resultado.isResolved()) break;
            }
            if (useSalt) {
                i2 = 0;
                while (i2 < cantEntrys) {
                    elem = (byte[])byteList.get(i2);
                    resultSalt = AuxiliaryForDecryptThreads.processSalt(result, (byte[])saltList.get(i2), preSaltList[i2]);
                    m.update(resultSalt);
                    aux = m.digest();
                    if (Arrays.equals(elem, aux)) {
                        this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.byteArray2String(result));
                    }
                    ++i2;
                }
            } else {
                m.update(result);
                aux = m.digest();
                i2 = 0;
                while (i2 < cantEntrys) {
                    elem = (byte[])byteList.get(i2);
                    if (Arrays.equals(elem, aux)) {
                        this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.byteArray2String(result));
                    }
                    ++i2;
                }
            }
            result = this.nextCombinationCustomBytes(result);
            ++count;
            if (System.currentTimeMillis() - start >= (long)myEndTime) break;
        }
        this.resultado.incrementTestCount(count);
    }

    private void testBruteForceSpecial() {
        this.firstCombination = "aaaaaaaa";
        this.lastCombination = "99999999";
        byte[] lastCombinationByte = this.lastCombination.getBytes();
        byte[] result = this.firstCombination.getBytes();
        this.alphabet = AvailableCharsets.getCharsetByName("loweralpha-numeric");
        String saltStr = null;
        Object salt = null;
        int algorithmCode = AvailableAlgorithms.getAlgorithmCodeFromInput(this.resultado.getAlgorithmCodes());
        MyMessageDigest m = null;
        m = AvailableAlgorithms.getMyMessageDigest(algorithmCode);
        String auxHashToDecrypt = new String("alagrandelepusecuca");
        if (algorithmCode == AvailableAlgorithms.getAlgorithmTypeCode("ORACLE-10G") || algorithmCode == AvailableAlgorithms.getAlgorithmTypeCode("POSTGRESQL")) {
            saltStr = "SYSTEM/";
        } else if (algorithmCode == AvailableAlgorithms.getAlgorithmTypeCode("ORACLE-11G")) {
            saltStr = "AAAAAAAAAA";
            auxHashToDecrypt = String.valueOf(auxHashToDecrypt) + saltStr;
        } else if (algorithmCode == AvailableAlgorithms.getAlgorithmTypeCode("MD5CRYPT")) {
            saltStr = "AAAAAAAA";
            auxHashToDecrypt = String.valueOf(auxHashToDecrypt) + saltStr;
        } else if (algorithmCode == AvailableAlgorithms.getAlgorithmTypeCode("INFORMIX-1170")) {
            saltStr = "3561468224442120539";
            auxHashToDecrypt = String.valueOf(auxHashToDecrypt) + saltStr;
        } else {
            salt = null;
        }
        String aux2 = null;
        if (salt == null || algorithmCode == AvailableAlgorithms.getAlgorithmTypeCode("POSTGRESQL") || algorithmCode == AvailableAlgorithms.getAlgorithmTypeCode("MD5CRYPT")) {
            aux2 = m.crypt(auxHashToDecrypt, saltStr);
        } else if (algorithmCode == AvailableAlgorithms.getAlgorithmTypeCode("ORACLE-11G")) {
            saltStr = null;
        }
        aux2 = m.crypt(auxHashToDecrypt, saltStr);
        byte[] hashToDecrypt = m.hashToByteArray(aux2);
        byte[] aux = null;
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        int i = 0;
        while (i < this.numberOfHashes) {
            byteList.add(hashToDecrypt);
            saltList.add(m.getSaltFromHash(hashToDecrypt));
            ++i;
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int myEndTime = this.resultado.getTestTime() * 1000;
        int cantEntrys = byteList.size();
        while (!Arrays.equals(result, lastCombinationByte)) {
            if (this.isSomethingDifferent()) {
                byteList.clear();
                saltList.clear();
                for (HashEntry entry : this.resultado.getPendingEncryptedHashes()) {
                    byte[] auxHash = m.hashToByteArray(entry.getHash());
                    byteList.add(auxHash);
                    saltList.add(m.getSaltFromHash(auxHash));
                }
                cantEntrys = byteList.size();
                this.setSomethingDifferent(false);
                if (this.resultado.isResolved()) break;
            }
            int i2 = 0;
            while (i2 < cantEntrys) {
                m.update(result);
                aux = m.digest((byte[])saltList.get(i2));
                if (Arrays.equals((byte[])byteList.get(i2), aux)) {
                    this.resultado.addDecryption(m.toHash((byte[])byteList.get(i2)), this.byteArray2String(result));
                }
                ++i2;
            }
            result = this.nextCombinationCustomBytes(result);
            ++count;
            if (System.currentTimeMillis() - start >= (long)myEndTime) break;
        }
        this.resultado.incrementTestCount(count);
    }

    private void testBruteForceChained() {
        this.firstCombination = "aaaaaaaa";
        this.lastCombination = "99999999";
        boolean useSalt = this.withSalt;
        byte[] lastCombinationByte = this.lastCombination.getBytes();
        this.alphabet = AvailableCharsets.getCharsetByName("loweralpha-numeric");
        MessageDigest[] ma = AvailableAlgorithms.getMessageDigestArray(this.resultado.getAlgorithmCodes());
        byte[] aux = new String("alagrandelepusecuca").getBytes();
        int i = 0;
        while (i < ma.length) {
            ma[i].update(aux, 0, aux.length);
            aux = ma[i].digest();
            if (ma.length - 1 != i) {
                aux = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, this.resultado.getChainedAlgorithmCase(), i);
            }
            ++i;
        }
        byte[] result = this.firstCombination.getBytes();
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        boolean[] preSaltList = new boolean[this.numberOfHashes];
        int auxIndex = 0;
        int i2 = 0;
        while (i2 < this.numberOfHashes) {
            byteList.add(aux);
            if (this.withSalt) {
                saltList.add(AuxiliaryForDecryptThreads.getRandom(8));
            } else {
                saltList.add(null);
            }
            preSaltList[i2] = true;
            ++i2;
        }
        aux = null;
        byte[] resultSalt = null;
        long start = System.currentTimeMillis();
        int count = 0;
        int myEndTime = this.resultado.getTestTime() * 1000;
        int cantEntrys = byteList.size();
        while (!Arrays.equals(result, lastCombinationByte)) {
            byte[] elem;
            int i3;
            if (this.isSomethingDifferent()) {
                useSalt = false;
                byteList.clear();
                saltList.clear();
                preSaltList = new boolean[this.resultado.getPendingEncryptedHashes().size()];
                auxIndex = 0;
                for (HashEntry entry : this.resultado.getPendingEncryptedHashes()) {
                    byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
                    byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
                    if (auxSalt != null) {
                        useSalt = true;
                    }
                    saltList.add(auxSalt);
                    preSaltList[auxIndex] = entry.isPreSalt();
                    ++auxIndex;
                }
                cantEntrys = byteList.size();
                this.setSomethingDifferent(false);
                if (this.resultado.isResolved()) break;
            }
            if (useSalt) {
                i3 = 0;
                while (i3 < cantEntrys) {
                    elem = (byte[])byteList.get(0);
                    resultSalt = AuxiliaryForDecryptThreads.processSalt(result, (byte[])saltList.get(i3), preSaltList[i3]);
                    int j = 0;
                    while (j < ma.length) {
                        ma[j].update(resultSalt);
                        aux = ma[j].digest();
                        if (ma.length - 1 != j) {
                            resultSalt = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, this.resultado.getChainedAlgorithmCase(), j);
                        }
                        ++j;
                    }
                    resultSalt = aux;
                    if (Arrays.equals(elem, resultSalt)) {
                        this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.byteArray2String(result));
                    }
                    ++i3;
                }
            } else {
                int j = 0;
                while (j < ma.length) {
                    ma[j].update(result);
                    aux = ma[j].digest();
                    if (ma.length - 1 != j) {
                        resultSalt = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, this.resultado.getChainedAlgorithmCase(), j);
                    }
                    ++j;
                }
                result = aux;
                i3 = 0;
                while (i3 < cantEntrys) {
                    elem = (byte[])byteList.get(i3);
                    if (Arrays.equals(elem, result)) {
                        this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.byteArray2String(result));
                    }
                    ++i3;
                }
            }
            result = this.nextCombinationCustomBytes(result);
            ++count;
            if (System.currentTimeMillis() - start >= (long)myEndTime) break;
        }
        this.resultado.incrementTestCount(count);
    }

    public byte[] nextCombinationCustomBytes(byte[] input) {
        int inputLength = input.length;
        int alphabetLength = this.alphabet.length();
        byte[] returnValue = null;
        char c = (char)input[inputLength - 1];
        char nextChar = '\u0000';
        if (c == this.alphabet.charAt(alphabetLength - 1)) {
            char firstAlphabetCharacter = this.alphabet.charAt(0);
            if (inputLength == 1) {
                returnValue = new byte[]{(byte)firstAlphabetCharacter, (byte)firstAlphabetCharacter};
            } else {
                byte[] aux1 = new byte[inputLength - 1];
                int i = 0;
                while (i < inputLength - 1) {
                    aux1[i] = input[i];
                    ++i;
                }
                byte[] aux2 = this.nextCombinationCustomBytes(aux1);
                returnValue = new byte[aux2.length + 1];
                int i2 = 0;
                while (i2 < aux2.length) {
                    returnValue[i2] = aux2[i2];
                    ++i2;
                }
                returnValue[aux2.length] = (byte)firstAlphabetCharacter;
            }
        } else {
            int i = 0;
            while (i < alphabetLength) {
                if (this.alphabet.charAt(i) == c) {
                    nextChar = this.alphabet.charAt(i + 1);
                    break;
                }
                ++i;
            }
            returnValue = new byte[inputLength];
            i = 0;
            while (i < inputLength - 1) {
                returnValue[i] = input[i];
                ++i;
            }
            returnValue[inputLength - 1] = (byte)nextChar;
        }
        return returnValue;
    }

    private void decryptBruteForce() {
        Object elem;
        byte[] result = this.firstCombination.getBytes();
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        boolean[] preSaltList = new boolean[this.resultado.getPendingEncryptedHashes().size()];
        int auxIndex = 0;
        boolean useSalt = false;
        for (HashEntry entry : this.resultado.getPendingEncryptedHashes()) {
            byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
            byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
            if (auxSalt != null) {
                useSalt = true;
            }
            saltList.add(auxSalt);
            preSaltList[auxIndex] = entry.isPreSalt();
            ++auxIndex;
        }
        byte[] lastCombinationByte = this.lastCombination.getBytes();
        int algorithmCode = AvailableAlgorithms.getAlgorithmCodeFromInput(this.resultado.getAlgorithmCodes());
        MessageDigest m = AvailableAlgorithms.getMessageDigest(algorithmCode);
        byte[] resultSalt = null;
        byte[] aux = null;
        int cantEntrys = byteList.size();
        int i = 0;
        while (i < cantEntrys) {
            elem = (byte[])byteList.get(i);
            resultSalt = AuxiliaryForDecryptThreads.processSalt(result, (byte[])saltList.get(i), preSaltList[i]);
            m.update(resultSalt);
            aux = m.digest();
            if (Arrays.equals(elem, aux)) {
                this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.lastCombination);
            }
            ++i;
        }
        while (!Arrays.equals(result, lastCombinationByte)) {
            if (this.isSomethingDifferent()) {
                useSalt = false;
                byteList.clear();
                saltList.clear();
                preSaltList = new boolean[this.resultado.getPendingEncryptedHashes().size()];
                auxIndex = 0;
                elem = this.resultado.getPendingEncryptedHashes().iterator();
                while (elem.hasNext()) {
                    HashEntry entry = (HashEntry)elem.next();
                    byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
                    byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
                    if (auxSalt != null) {
                        useSalt = true;
                    }
                    saltList.add(auxSalt);
                    preSaltList[auxIndex] = entry.isPreSalt();
                    ++auxIndex;
                }
                cantEntrys = byteList.size();
                this.setSomethingDifferent(false);
                if (this.resultado.isResolved()) break;
            }
            if (useSalt) {
                i = 0;
                while (i < cantEntrys) {
                    elem = (byte[])byteList.get(i);
                    resultSalt = AuxiliaryForDecryptThreads.processSalt(result, (byte[])saltList.get(i), preSaltList[i]);
                    m.update(resultSalt);
                    aux = m.digest();
                    if (Arrays.equals(elem, aux)) {
                        this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.byteArray2String(result));
                    }
                    ++i;
                }
            } else {
                m.update(result);
                aux = m.digest();
                i = 0;
                while (i < cantEntrys) {
                    elem = (byte[])byteList.get(i);
                    if (Arrays.equals(elem, aux)) {
                        this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.byteArray2String(result));
                    }
                    ++i;
                }
            }
            result = this.nextCombinationCustomBytes(result);
        }
    }

    private void decryptBruteForceSpecialAlgorithm() {
        byte[] result = this.firstCombination.getBytes();
        int algorithmCode = AvailableAlgorithms.getAlgorithmCodeFromInput(this.resultado.getAlgorithmCodes());
        MyMessageDigest m = AvailableAlgorithms.getMyMessageDigest(algorithmCode);
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        for (HashEntry entry : this.resultado.getEncryptedHashes()) {
            byte[] auxHash = m.hashToByteArray(entry.getHash());
            byteList.add(auxHash);
            saltList.add(m.getSaltFromHash(auxHash));
        }
        byte[] lastCombinationByte = this.lastCombination.getBytes();
        byte[] aux = null;
        int cantEntrys = byteList.size();
        int i = 0;
        while (i < cantEntrys) {
            m.update(lastCombinationByte);
            aux = m.digest((byte[])saltList.get(i));
            if (Arrays.equals((byte[])byteList.get(i), aux)) {
                this.resultado.addDecryption(m.toHash((byte[])byteList.get(i)), this.lastCombination);
            }
            ++i;
        }
        while (!Arrays.equals(result, lastCombinationByte)) {
            if (this.isSomethingDifferent()) {
                byteList.clear();
                saltList.clear();
                for (HashEntry entry : this.resultado.getPendingEncryptedHashes()) {
                    byte[] auxHash = m.hashToByteArray(entry.getHash());
                    byteList.add(auxHash);
                    saltList.add(m.getSaltFromHash(auxHash));
                }
                cantEntrys = byteList.size();
                this.setSomethingDifferent(false);
                if (this.resultado.isResolved()) break;
            }
            i = 0;
            while (i < cantEntrys) {
                m.update(result);
                aux = m.digest((byte[])saltList.get(i));
                if (Arrays.equals((byte[])byteList.get(i), aux)) {
                    this.resultado.addDecryption(m.toHash((byte[])byteList.get(i)), this.byteArray2String(result));
                }
                ++i;
            }
            result = this.nextCombinationCustomBytes(result);
        }
    }

    private void decryptBruteForceChained() {
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        boolean[] preSaltList = new boolean[this.resultado.getPendingEncryptedHashes().size()];
        int auxIndex = 0;
        boolean useSalt = false;
        for (HashEntry entry : this.resultado.getEncryptedHashes()) {
            byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
            byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
            if (auxSalt != null) {
                useSalt = true;
            }
            saltList.add(auxSalt);
            preSaltList[auxIndex] = entry.isPreSalt();
            ++auxIndex;
        }
        MessageDigest[] ma = AvailableAlgorithms.getMessageDigestArray(this.resultado.getAlgorithmCodes());
        byte[] lastCombinationByte = this.lastCombination.getBytes();
        int cantEntrys = byteList.size();
        byte[] resultSalt = lastCombinationByte;
        byte[] aux = null;
        int i = 0;
        while (i < cantEntrys) {
            byte[] elem = (byte[])byteList.get(0);
            if (useSalt) {
                resultSalt = AuxiliaryForDecryptThreads.processSalt(resultSalt, (byte[])saltList.get(i), preSaltList[i]);
            }
            int j = 0;
            while (j < ma.length) {
                ma[j].update(resultSalt);
                aux = ma[j].digest();
                if (ma.length - 1 != j) {
                    resultSalt = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, this.resultado.getChainedAlgorithmCase(), j);
                }
                ++j;
            }
            resultSalt = aux;
            if (Arrays.equals(elem, resultSalt)) {
                this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.lastCombination);
            }
            ++i;
        }
        byte[] result = this.firstCombination.getBytes();
        while (!Arrays.equals(result, lastCombinationByte)) {
            int i2;
            if (this.isSomethingDifferent()) {
                useSalt = false;
                byteList.clear();
                saltList.clear();
                preSaltList = new boolean[this.resultado.getPendingEncryptedHashes().size()];
                auxIndex = 0;
                for (HashEntry entry : this.resultado.getPendingEncryptedHashes()) {
                    byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
                    byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
                    if (auxSalt != null) {
                        useSalt = true;
                    }
                    saltList.add(auxSalt);
                    preSaltList[auxIndex] = entry.isPreSalt();
                    ++auxIndex;
                }
                cantEntrys = byteList.size();
                this.setSomethingDifferent(false);
                if (this.resultado.isResolved()) break;
            }
            if (useSalt) {
                i2 = 0;
                while (i2 < cantEntrys) {
                    byte[] elem = (byte[])byteList.get(0);
                    resultSalt = AuxiliaryForDecryptThreads.processSalt(result, (byte[])saltList.get(i2), preSaltList[i2]);
                    int j = 0;
                    while (j < ma.length) {
                        ma[j].update(resultSalt);
                        aux = ma[j].digest();
                        if (ma.length - 1 != j) {
                            resultSalt = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, this.resultado.getChainedAlgorithmCase(), j);
                        }
                        ++j;
                    }
                    resultSalt = aux;
                    if (Arrays.equals(elem, resultSalt)) {
                        this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.byteArray2String(result));
                    }
                    ++i2;
                }
            } else {
                resultSalt = result;
                int j = 0;
                while (j < ma.length) {
                    ma[j].update(resultSalt);
                    aux = ma[j].digest();
                    if (ma.length - 1 != j) {
                        resultSalt = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, this.resultado.getChainedAlgorithmCase(), j);
                    }
                    ++j;
                }
                resultSalt = aux;
                i2 = 0;
                while (i2 < cantEntrys) {
                    byte[] elem = (byte[])byteList.get(i2);
                    if (Arrays.equals(elem, resultSalt)) {
                        this.resultado.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), this.byteArray2String(result));
                    }
                    ++i2;
                }
            }
            result = this.nextCombinationCustomBytes(result);
        }
    }

    public String byteArray2String(byte[] b) {
        StringBuilder s = new StringBuilder("");
        char c = '\u0000';
        int i = 0;
        while (i < b.length) {
            c = (char)b[i];
            int j = 0;
            while (j < this.alphabet.length()) {
                if (c == this.alphabet.charAt(j)) {
                    s.append(this.alphabet.charAt(j));
                    break;
                }
                ++j;
            }
            ++i;
        }
        return s.toString();
    }
}

