/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.util;

import com.aspect.snoop.SnoopSession;
import com.aspect.snoop.agent.AgentCommunicationException;
import com.aspect.snoop.agent.AgentJarCreator;
import com.aspect.snoop.util.JadUtil;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class AttachUtil {
    private static Logger logger = Logger.getLogger(AttachUtil.class);

    public static void attachToVM() throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException, AgentCommunicationException {
        String agentJarPath = AgentJarCreator.createAgentJar(false);
        AttachUtil.loadAgentInOtherVM(agentJarPath, ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static void loadAgentInOtherVM(String agentJarPath, String pid) throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException, AgentCommunicationException {
        VirtualMachine vm = VirtualMachine.attach(pid);
        vm.loadAgent(agentJarPath, new File(".").getAbsolutePath() + "|0|");
        vm.detach();
    }

    public static void launchInNewVM(String agentJarPath, SnoopSession session) throws AttachNotSupportedException, ClassNotFoundException, NoSuchMethodException, IOException, AttachNotSupportedException, AgentCommunicationException {
        String cp;
        boolean isJar = session.getMainClass().trim().length() == 0 && session.getClasspathString().trim().length() > 0 && session.getClasspathString().trim().endsWith(".jar");
        String javaHome = System.getProperty("java.home") + File.separator + "bin";
        ArrayList<String> arguments = new ArrayList<String>();
        String command = javaHome + File.separator + "java";
        arguments.add(command);
        String agent = "-javaagent:" + agentJarPath + "=" + new File(".").getAbsolutePath() + "|" + session.getGuiDelay() + "|" + session.getLookAndFeel();
        arguments.add(agent);
        String javaArgs = session.getJavaArguments().trim();
        if (javaArgs.length() > 0) {
            String[] args = AttachUtil.parseArguments(javaArgs);
            arguments.addAll(Arrays.asList(args));
        }
        if ((cp = session.getClasspathString()).trim().length() > 0) {
            if (isJar) {
                arguments.add("-jar");
            } else {
                arguments.add("-cp");
            }
            arguments.add(cp);
        }
        if (!isJar) {
            arguments.add(session.getMainClass());
        }
        if (session.getArguments().length() > 0) {
            String[] args = AttachUtil.parseArguments(session.getArguments());
            arguments.addAll(Arrays.asList(args));
        }
        String[] commandArgs = arguments.toArray(new String[0]);
        StringBuilder sb = new StringBuilder();
        for (String s : commandArgs) {
            sb.append(s).append(" ");
        }
        String workingDir = new File(".").getPath();
        if (session.getWorkingDir().trim().length() > 0) {
            workingDir = session.getWorkingDir().trim();
        }
        sb = new StringBuilder();
        for (String arg : commandArgs) {
            sb.append(arg);
            sb.append(" ");
        }
        logger.debug((Object)sb.toString());
        final String fWorkingDir = workingDir;
        final String[] fCommandArgs = commandArgs;
        new Thread("Executing "){

            @Override
            public void run() {
                try {
                    Process p = Runtime.getRuntime().exec(fCommandArgs, null, new File(fWorkingDir));
                    JadUtil.doWaitFor(p);
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                }
            }
        }.start();
    }

    private static String[] parseArguments(String args) {
        ArrayList<String> arguments = new ArrayList<String>();
        boolean quoted = false;
        String currentArg = "";
        for (int i = 0; i < args.length(); ++i) {
            char c = args.charAt(i);
            if (!quoted && c == ' ') {
                arguments.add(currentArg);
                currentArg = "";
            } else if (quoted && c == '\"') {
                arguments.add(currentArg);
                currentArg = "";
                quoted = false;
                ++i;
            } else if (c == '\"') {
                quoted = true;
            } else {
                currentArg = currentArg + c;
            }
            if (i != args.length() - 1) continue;
            arguments.add(currentArg);
        }
        String[] toReturn = new String[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            toReturn[i] = (String)arguments.get(i);
        }
        return toReturn;
    }
}

