/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper.array;

import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.ui.tamper.array.ArrayTableModel;
import com.aspect.snoop.ui.tamper.common.AddItemView;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class EditArrayView
extends JDialog {
    private Object[] array;
    private JButton btnAccept;
    private JButton btnAddItem;
    private JButton btnDeleteItem;
    private JButton btnMoveDown;
    private JButton btnMoveUp;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JScrollPane jScrollPane2;
    private JLabel lblClassName;
    private JTable tblListItems;

    public EditArrayView(Frame parent, boolean modal, Object[] array) {
        super(parent, modal);
        this.initComponents();
        this.array = array;
        this.tblListItems.setModel(new ArrayTableModel(array));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.lblClassName = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tblListItems = new JTable();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.btnDeleteItem = new JButton();
        this.btnAddItem = new JButton();
        this.btnAccept = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(EditArrayView.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.lblClassName.setText(resourceMap.getString("lblClassName.text", new Object[0]));
        this.lblClassName.setName("lblClassName");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jScrollPane2.setName("jScrollPane2");
        this.tblListItems.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Title 2"}));
        this.tblListItems.setName("tblListItems");
        this.jScrollPane2.setViewportView(this.tblListItems);
        this.btnMoveUp.setText(resourceMap.getString("btnMoveUp.text", new Object[0]));
        this.btnMoveUp.setName("btnMoveUp");
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditArrayView.this.btnMoveUpActionPerformed(evt);
            }
        });
        this.btnMoveDown.setText(resourceMap.getString("btnMoveDown.text", new Object[0]));
        this.btnMoveDown.setName("btnMoveDown");
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditArrayView.this.btnMoveDownActionPerformed(evt);
            }
        });
        this.btnDeleteItem.setText(resourceMap.getString("btnDeleteItem.text", new Object[0]));
        this.btnDeleteItem.setName("btnDeleteItem");
        this.btnDeleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditArrayView.this.btnDeleteItemActionPerformed(evt);
            }
        });
        this.btnAddItem.setText(resourceMap.getString("btnAddItem.text", new Object[0]));
        this.btnAddItem.setName("btnAddItem");
        this.btnAddItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditArrayView.this.btnAddItemActionPerformed(evt);
            }
        });
        this.btnAccept.setText(resourceMap.getString("btnAccept.text", new Object[0]));
        this.btnAccept.setName("btnAccept");
        this.btnAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditArrayView.this.btnAcceptActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 400, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.lblClassName)).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnMoveUp, -1, 87, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAddItem, -2, 87, -2)).addGroup(layout.createSequentialGroup().addComponent(this.btnMoveDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDeleteItem))).addGap(117, 117, 117).addComponent(this.btnAccept))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lblClassName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 229, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddItem).addComponent(this.btnMoveUp)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnMoveDown).addComponent(this.btnDeleteItem))).addComponent(this.btnAccept)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnMoveUpActionPerformed(ActionEvent evt) {
        Object current;
        int idx = this.tblListItems.getSelectedRow();
        if (idx == -1) {
            return;
        }
        if (idx == 0) {
            return;
        }
        Object above = this.array[idx - 1];
        this.array[idx - 1] = current = this.array[idx];
        this.array[idx] = above;
        this.tblListItems.changeSelection(idx - 1, 0, false, false);
        this.tblListItems.updateUI();
    }

    private void btnMoveDownActionPerformed(ActionEvent evt) {
        Object current;
        int idx = this.tblListItems.getSelectedRow();
        if (idx == -1) {
            return;
        }
        if (idx == this.array.length - 1) {
            return;
        }
        Object below = this.array[idx + 1];
        this.array[idx + 1] = current = this.array[idx];
        this.array[idx] = below;
        this.tblListItems.changeSelection(idx + 1, 0, false, false);
        this.tblListItems.updateUI();
    }

    private void btnDeleteItemActionPerformed(ActionEvent evt) {
        try {
            int i;
            int idx = this.tblListItems.getSelectedRow();
            if (idx == -1) {
                return;
            }
            Object[] newArray = new Object[this.array.length - 1];
            int j = 0;
            for (i = 0; i < idx; ++i) {
                newArray[j++] = this.array[i];
            }
            for (i = idx + 1; i < this.array.length; ++i) {
                newArray[j++] = this.array[i];
            }
            this.array = newArray;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tblListItems.updateUI();
    }

    private void btnAddItemActionPerformed(ActionEvent evt) {
        Class c = null;
        AddItemView view = null;
        if (this.array.getClass().equals(new String[0].getClass())) {
            c = String.class;
        } else if (this.array.getClass().equals(new Byte[0].getClass())) {
            c = Byte.class;
        } else if (this.array.getClass().equals(new Boolean[0].getClass())) {
            c = Boolean.class;
        } else if (this.array.getClass().equals(new Character[0].getClass())) {
            c = Character.class;
        } else if (this.array.getClass().equals(new Short[0].getClass())) {
            c = Short.class;
        } else if (this.array.getClass().equals(new Integer[0].getClass())) {
            c = Integer.class;
        } else if (this.array.getClass().equals(new Long[0].getClass())) {
            c = Long.class;
        } else if (this.array.getClass().equals(new Float[0].getClass())) {
            c = Float.class;
        } else if (this.array.getClass().equals(new Double[0].getClass())) {
            c = Double.class;
        } else if (this.array.getClass().equals(new Object[0].getClass())) {
            c = Object.class;
        }
        if (c != null) {
            view = new AddItemView(this, true, c);
            view.setVisible(true);
            while (view.isShowing()) {
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException ex) {}
            }
            if (view.getNewItem() != null) {
                Object[] newArray = Arrays.copyOf(this.array, this.array.length + 1);
                newArray[this.array.length] = view.getNewItem();
                this.array = newArray;
                this.tblListItems.updateUI();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't add custom item class: " + this.array.getClass(), "Error adding new item", 0);
        }
    }

    private void btnAcceptActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditArrayView dialog = new EditArrayView((Frame)new JFrame(), true, new String[]{"foo", "bar"});
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

