/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.hook;

import com.aspect.snoop.Condition;
import com.aspect.snoop.FunctionHook;
import com.aspect.snoop.ui.condition.ConditionTableModel;
import com.aspect.snoop.ui.hook.FunctionsHookedTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FunctionHookTableSelectionListener
implements ListSelectionListener {
    JTable functionHookTable;
    JTable conditionTable;
    JButton btnAddNewCondition;
    JRadioButton rdoAlwaysHook;
    JRadioButton rdoDontHookIf;
    JRadioButton rdoHookIf;
    JCheckBox chkTamperParameters;
    JCheckBox chkTamperReturnValue;
    JCheckBox chkRunScript;
    JButton btnBrowseForScript;
    JCheckBox chkPause;
    JCheckBox chkPrintParameters;
    JCheckBox chkPrintStackTrace;
    JCheckBox chkOutputToFile;
    JCheckBox chkOutputToConsole;
    JTextField txtOutputFile;
    JButton btnBrowseForOutputFile;
    ButtonGroup btnGrpCondition;
    List<Component> stuffToEnable;

    public FunctionHookTableSelectionListener(JTable functionHookTable, JTable conditionTable, JButton btnAddNewCondition, JRadioButton rdoAlwaysHook, JRadioButton rdoDontHookIf, JRadioButton rdoHookIf, JCheckBox chkTamperParameters, JCheckBox chkTamperReturnValue, JCheckBox chkRunScript, JButton btnBrowseForScript, JCheckBox chkPause, JCheckBox chkPrintParameters, JCheckBox chkPrintStackTrace, JCheckBox chkOutputToFile, JCheckBox chkOutputToConsole, JTextField txtOutputFile, JButton btnBrowseForOutputFile, ButtonGroup btnGrpCondition) {
        this.functionHookTable = functionHookTable;
        this.conditionTable = conditionTable;
        this.btnAddNewCondition = btnAddNewCondition;
        this.rdoAlwaysHook = rdoAlwaysHook;
        this.rdoDontHookIf = rdoDontHookIf;
        this.rdoHookIf = rdoHookIf;
        this.chkTamperParameters = chkTamperParameters;
        this.chkTamperReturnValue = chkTamperReturnValue;
        this.chkRunScript = chkRunScript;
        this.btnBrowseForScript = btnBrowseForScript;
        this.chkPause = chkPause;
        this.chkPrintParameters = chkPrintParameters;
        this.chkPrintStackTrace = chkPrintStackTrace;
        this.chkOutputToConsole = chkOutputToConsole;
        this.chkOutputToFile = chkOutputToFile;
        this.txtOutputFile = txtOutputFile;
        this.btnBrowseForOutputFile = btnBrowseForOutputFile;
        this.btnGrpCondition = btnGrpCondition;
        this.stuffToEnable = new ArrayList<Component>();
        this.stuffToEnable.add(rdoAlwaysHook);
        this.stuffToEnable.add(rdoDontHookIf);
        this.stuffToEnable.add(rdoHookIf);
        this.stuffToEnable.add(chkTamperParameters);
        this.stuffToEnable.add(chkTamperReturnValue);
        this.stuffToEnable.add(chkRunScript);
        this.stuffToEnable.add(btnBrowseForScript);
        this.stuffToEnable.add(chkPause);
        this.stuffToEnable.add(chkPrintParameters);
        this.stuffToEnable.add(chkPrintStackTrace);
        this.stuffToEnable.add(chkOutputToFile);
        this.stuffToEnable.add(chkOutputToConsole);
        this.stuffToEnable.add(txtOutputFile);
        this.stuffToEnable.add(btnBrowseForOutputFile);
        this.stuffToEnable.add(conditionTable);
        this.disableAll();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            FunctionsHookedTableModel model = (FunctionsHookedTableModel)this.functionHookTable.getModel();
            int selectedRow = this.functionHookTable.getSelectedRow();
            if (selectedRow != -1) {
                this.btnAddNewCondition.setEnabled(true);
                FunctionHook hook = model.getHookFromRow(selectedRow);
                List<Condition> conditions = hook.getConditions();
                ((ConditionTableModel)this.conditionTable.getModel()).setConditions(conditions);
                this.conditionTable.updateUI();
                this.enableAll();
                this.chkTamperParameters.setSelected(hook.shouldTamperParameters());
                if (hook.getParameterTypes().length == 0) {
                    this.chkTamperParameters.setEnabled(false);
                    this.chkPrintParameters.setEnabled(false);
                }
                this.chkTamperReturnValue.setSelected(hook.shouldTamperReturnValue());
                if (hook.getReturnType().getName().equals("void")) {
                    this.chkTamperReturnValue.setEnabled(false);
                }
                this.chkRunScript.setSelected(hook.shouldRunScript());
                this.chkPause.setSelected(hook.shouldPause());
                this.chkPrintParameters.setSelected(hook.shouldPrintParameters());
                this.chkPrintStackTrace.setSelected(hook.shouldPrintStackTrace());
                this.chkOutputToConsole.setSelected(hook.isOutputToConsole());
                this.chkOutputToFile.setSelected(hook.isOutputToFile());
                this.txtOutputFile.setText(hook.getOutputFile());
                this.rdoAlwaysHook.setSelected(hook.getMode().equals((Object)FunctionHook.Mode.AlwaysIntercept));
                this.rdoHookIf.setSelected(hook.getMode().equals((Object)FunctionHook.Mode.InterceptIf));
                this.rdoDontHookIf.setSelected(hook.getMode().equals((Object)FunctionHook.Mode.DontInterceptIf));
            } else {
                this.btnAddNewCondition.setEnabled(false);
                this.disableAll();
                this.clearAll();
            }
        }
    }

    private void clearAll() {
        for (Component c : this.stuffToEnable) {
            if (c instanceof JTextField) {
                ((JTextField)c).setText("");
                continue;
            }
            if (c instanceof JCheckBox) {
                ((JCheckBox)c).setSelected(false);
                continue;
            }
            if (!(c instanceof JRadioButton)) continue;
            ((JRadioButton)c).setSelected(false);
        }
        this.btnGrpCondition.clearSelection();
        ConditionTableModel model = (ConditionTableModel)this.conditionTable.getModel();
        model.setConditions(new ArrayList<Condition>());
        this.conditionTable.repaint();
        this.conditionTable.updateUI();
    }

    private void disableAll() {
        for (Component c : this.stuffToEnable) {
            c.setEnabled(false);
        }
    }

    private void enableAll() {
        for (Component c : this.stuffToEnable) {
            c.setEnabled(true);
        }
    }
}

