#!/usr/bin/python

"""
Module IBM DB2 Database Servers Discover for Inguma
Copyright (c) 2008 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""

import sys

from lib.libexploit import CIngumaModule
from lib.libdb2 import CDb2Discover

name = "db2discover"
brief_description = "IBM DB2 database servers discover module"
type = "discover"

class CDb2DiscoverModule(CIngumaModule):

    def help(self):
        print "target = <target host or network>"
        print "port = <target port>"
        print "timeout = <timeout>"

    def run(self):
        
        if self.target == "":
            self.target = "<broadcast>"
            print "[i] Using broadcast address 255.255.255.255"
        
        if self.port == 0 or self.port == None:
            self.port = 553
        
        if self.port != 553:
            print "[!] Warning! using non standard port %d" % int(self.port)
        
        db2Discover = CDb2Discover()
        db2Discover.target = self.target
        db2Discover.port = self.port
        db2Discover.verbose = False
        ret = db2Discover.discover()

        for server in ret:
            print "[+] IBM DB2 Server at %s:%d" % (server[0][0], server[0][1])
            print "  Version   : %s " % server[1]
            print "  Hostname  : %s " % server[2]
            print "  Servername: %s " % server[3]
            print
            self.addToDict("hosts",  server[0][0])
            self.addToDict(server[0][0] + "_db2server",  (server[1],  server[2],  server[3]))

        print "Total of %d IBM DB2 Server(s) found." % len(ret)
        
        return len(ret) > 0

    def printSummary(self):
        pass


